/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.Arrays;
import javax.sql.DataSource;
import org.kuali.common.jdbc.ShowConfigExecutable;
import org.kuali.common.jdbc.ShowDbaConfigExecutable;
import org.kuali.common.jdbc.context.DatabaseProcessContext;
import org.kuali.common.jdbc.spring.JdbcCommonConfig;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.nullify.BeanNullifier;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Deprecated
@Configuration
@Import(value={JdbcCommonConfig.class})
public class JdbcDataSourceConfig {
    protected static final String VENDOR_KEY = "db.vendor";
    protected static final String DRIVER_KEY = "jdbc.driver";
    protected static final String URL_KEY = "jdbc.url";
    protected static final String USERNAME_KEY = "jdbc.username";
    protected static final String PASSWORD_KEY = "jdbc.password";
    protected static final String DBA_URL_KEY = "jdbc.dba.url";
    protected static final String DBA_USERNAME_KEY = "jdbc.dba.username";
    protected static final String DBA_PASSWORD_KEY = "jdbc.dba.password";
    protected static final String ENCODING_KEY = "sql.encoding";
    protected static final String SCHEMA_KEY = "sql.schema";
    protected static final String SHOW_CONFIG_SKIP_KEY = "jdbc.showconfig.skip";
    protected static final boolean DEFAULT_SHOW_CONFIG_SKIP = false;
    protected static final String NULLIFIED_CONTEXT_PROPERTIES_CSV = "username,password,dbaUsername,dbaPassword";
    @Autowired
    Environment env;
    @Autowired
    JdbcCommonConfig commonConfig;

    @Bean
    public DatabaseProcessContext jdbcDatabaseProcessContext() {
        DatabaseProcessContext ctx = new DatabaseProcessContext();
        ctx.setVendor(SpringUtils.getProperty((Environment)this.env, (String)VENDOR_KEY));
        ctx.setDriver(SpringUtils.getProperty((Environment)this.env, (String)DRIVER_KEY));
        ctx.setUrl(SpringUtils.getProperty((Environment)this.env, (String)URL_KEY));
        ctx.setUsername(SpringUtils.getProperty((Environment)this.env, (String)USERNAME_KEY));
        ctx.setPassword(SpringUtils.getProperty((Environment)this.env, (String)PASSWORD_KEY));
        ctx.setDbaUrl(SpringUtils.getProperty((Environment)this.env, (String)DBA_URL_KEY));
        ctx.setDbaUsername(SpringUtils.getProperty((Environment)this.env, (String)DBA_USERNAME_KEY));
        ctx.setDbaPassword(SpringUtils.getProperty((Environment)this.env, (String)DBA_PASSWORD_KEY));
        ctx.setEncoding(SpringUtils.getProperty((Environment)this.env, (String)ENCODING_KEY));
        ctx.setSchema(SpringUtils.getProperty((Environment)this.env, (String)SCHEMA_KEY));
        BeanNullifier nullifier = new BeanNullifier();
        nullifier.setBean((Object)ctx);
        nullifier.setNullTokens(Arrays.asList("NONE", "NULL"));
        nullifier.setProperties(CollectionUtils.getTrimmedListFromCSV((String)NULLIFIED_CONTEXT_PROPERTIES_CSV));
        nullifier.nullify();
        return ctx;
    }

    @Bean
    public DataSource jdbcDataSource() {
        DatabaseProcessContext ctx = this.jdbcDatabaseProcessContext();
        DriverManagerDataSource dmds = new DriverManagerDataSource();
        dmds.setDriverClassName(ctx.getDriver());
        dmds.setUrl(ctx.getUrl());
        dmds.setUsername(ctx.getUsername());
        dmds.setPassword(ctx.getPassword());
        return dmds;
    }

    @Bean
    public DataSource jdbcDbaDataSource() {
        DatabaseProcessContext ctx = this.jdbcDatabaseProcessContext();
        DriverManagerDataSource dmds = new DriverManagerDataSource();
        dmds.setDriverClassName(ctx.getDriver());
        dmds.setUrl(ctx.getDbaUrl());
        dmds.setUsername(ctx.getDbaUsername());
        dmds.setPassword(ctx.getDbaPassword());
        return dmds;
    }

    @Bean
    public Executable jdbcShowDbaConfigExecutable() {
        ShowDbaConfigExecutable exec = new ShowDbaConfigExecutable();
        exec.setService(this.commonConfig.jdbcService());
        exec.setContext(this.jdbcDatabaseProcessContext());
        exec.setDataSource(this.jdbcDbaDataSource());
        exec.setSkip(SpringUtils.getBoolean((Environment)this.env, (String)SHOW_CONFIG_SKIP_KEY, (boolean)false));
        return exec;
    }

    @Bean
    public Executable jdbcShowConfigExecutable() {
        ShowConfigExecutable exec = new ShowConfigExecutable();
        exec.setService(this.commonConfig.jdbcService());
        exec.setContext(this.jdbcDatabaseProcessContext());
        exec.setDataSource(this.jdbcDataSource());
        exec.setSkip(SpringUtils.getBoolean((Environment)this.env, (String)SHOW_CONFIG_SKIP_KEY, (boolean)false));
        return exec;
    }
}

