/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.JdbcExecutable;
import org.kuali.common.jdbc.context.JdbcContext;
import org.kuali.common.jdbc.context.SqlExecutionContext;
import org.kuali.common.jdbc.context.SqlMode;
import org.kuali.common.jdbc.listener.LogSqlListener;
import org.kuali.common.jdbc.listener.NotifyingListener;
import org.kuali.common.jdbc.listener.ProgressListener;
import org.kuali.common.jdbc.listener.SqlListener;
import org.kuali.common.jdbc.spring.SqlConfigContext;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Deprecated
public class SqlConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlConfigUtils.class);
    public static final String SQL_ORDER_KEY = "sql.execution.order";
    public static final String RESOURCES_SUFFIX = ".resources";
    public static final String SQL_NAMESPACE_TOKEN = "sql";
    protected static final String SKIP_PROPERTY_KEY_SUFFIX = ".skip";
    protected static final String SKIP_EXECUTABLE_PROPERTY_KEY_SUFFIX = ".executable.skip";
    protected static final String TRACK_PROGRESS_KEY_SUFFIX = ".trackProgressByUpdateCount";

    public static JdbcExecutable getJdbcExecutable(SqlConfigContext scc) {
        String skipKey = scc.getContext().getGroup() + SKIP_EXECUTABLE_PROPERTY_KEY_SUFFIX;
        JdbcContext context = SqlConfigUtils.getJdbcContext(scc);
        context.setListener(SqlConfigUtils.getSqlListener(scc.getContext().getMode()));
        JdbcExecutable exec = new JdbcExecutable();
        exec.setSkip(SpringUtils.getBoolean((Environment)scc.getEnv(), (String)skipKey, (boolean)false));
        exec.setService(scc.getCommonConfig().jdbcService());
        exec.setContext(context);
        return exec;
    }

    public static SqlListener getSqlListener(SqlMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return new LogSqlListener();
            }
            case SEQUENTIAL: {
                ArrayList<SqlListener> listeners = new ArrayList<SqlListener>();
                listeners.add(new LogSqlListener());
                listeners.add(new ProgressListener());
                return new NotifyingListener(listeners);
            }
        }
        throw new IllegalArgumentException("mode [" + mode.name() + "] is unknown");
    }

    public static JdbcContext getJdbcContext(SqlConfigContext scc) {
        SqlExecutionContext ctx = scc.getContext();
        SqlMode mode = ctx.getMode();
        switch (mode) {
            case CONCURRENT: {
                return SqlConfigUtils.getConcurrentJdbcContext(scc);
            }
            case SEQUENTIAL: {
                return SqlConfigUtils.getSequentialJdbcContext(scc);
            }
        }
        throw new IllegalArgumentException("mode [" + mode.name() + "] is unknown");
    }

    public static List<SqlExecutionContext> getSqlExecutionContexts(Environment env) {
        String csv = SpringUtils.getProperty((Environment)env, (String)SQL_ORDER_KEY);
        if (NullUtils.isNullOrNone((String)csv)) {
            csv = "";
        }
        List propertyKeys = CollectionUtils.getTrimmedListFromCSV((String)csv);
        SqlConfigUtils.validateSqlExecutionOrderValues(env, propertyKeys);
        return SqlConfigUtils.getSqlExecutionContexts(propertyKeys);
    }

    public static void validateSqlExecutionOrderValues(Environment env, List<String> propertykeys) {
        for (String propertyKey : propertykeys) {
            String csv = SpringUtils.getProperty((Environment)env, (String)propertyKey);
            List resources = CollectionUtils.getTrimmedListFromCSV((String)csv);
            SqlConfigUtils.validateResources(resources);
        }
    }

    public static void validateResources(List<String> resources) {
        for (String resource : resources) {
            LocationUtils.validateLocation((String)resource);
            if (!StringUtils.endsWithIgnoreCase((CharSequence)resource, (CharSequence)RESOURCES_SUFFIX)) continue;
            LocationUtils.validateLocationListing((String)resource);
        }
    }

    public static List<SqlExecutionContext> getSqlExecutionContexts(List<String> propertyKeys) {
        ArrayList<SqlExecutionContext> contexts = new ArrayList<SqlExecutionContext>();
        for (String propertyKey : propertyKeys) {
            String[] tokens = StringUtils.split((String)propertyKey, (String)".");
            Assert.isTrue((tokens.length >= 3 ? 1 : 0) != 0, (String)"tokens.length < 3");
            int sqlTokenIndex = 0;
            int modeIndex = tokens.length - 1;
            Assert.isTrue((boolean)tokens[sqlTokenIndex].equals(SQL_NAMESPACE_TOKEN), (String)"sql execution properties must start with a 'sql.' namespace");
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < tokens.length; ++i) {
                if (i == modeIndex) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(".");
                }
                sb.append(tokens[i]);
            }
            String group = sb.toString();
            String modeString = StringUtils.trim((String)tokens[modeIndex].toUpperCase());
            SqlMode mode = SqlMode.valueOf(modeString);
            contexts.add(new SqlExecutionContext(propertyKey, group, mode));
        }
        return contexts;
    }

    public static JdbcContext getConcurrentJdbcContext(SqlConfigContext rcc) {
        String threads = SpringUtils.getProperty((Environment)rcc.getEnv(), (String)"sql.threads");
        JdbcContext ctx = SqlConfigUtils.getBaseJdbcContext(rcc);
        ctx.setMultithreaded(true);
        ctx.setThreads(new Integer(threads));
        return ctx;
    }

    public static JdbcContext getSequentialJdbcContext(SqlConfigContext rcc) {
        JdbcContext ctx = SqlConfigUtils.getBaseJdbcContext(rcc);
        ctx.setMultithreaded(false);
        ctx.setThreads(1);
        return ctx;
    }

    protected static JdbcContext getBaseJdbcContext(SqlConfigContext scc) {
        SqlExecutionContext sec = scc.getContext();
        String group = sec.getGroup();
        String propertyKey = scc.getContext().getKey();
        String skipKey = group + SKIP_PROPERTY_KEY_SUFFIX;
        String trackProgressKey = propertyKey + TRACK_PROGRESS_KEY_SUFFIX;
        String message = "[" + sec.getGroup() + ":" + sec.getMode().name().toLowerCase() + "]";
        boolean skip = SpringUtils.getBoolean((Environment)scc.getEnv(), (String)skipKey, (boolean)false);
        boolean trackProgressByUpdateCount = SpringUtils.getBoolean((Environment)scc.getEnv(), (String)trackProgressKey, (boolean)false);
        logger.debug("{}={}", (Object)trackProgressKey, (Object)trackProgressByUpdateCount);
        List<SqlSupplier> suppliers = scc.getCommonConfig().getSqlSuppliers(propertyKey);
        DataSource dataSource = scc.getDataSourceConfig().jdbcDataSource();
        JdbcContext ctx = new JdbcContext();
        ctx.setMessage(message);
        ctx.setSkip(skip);
        ctx.setDataSource(dataSource);
        ctx.setTrackProgressByUpdateCount(trackProgressByUpdateCount);
        ctx.setSuppliers(suppliers);
        return ctx;
    }
}

