/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.sql.spring;

import org.kuali.common.jdbc.model.Credentials;
import org.kuali.common.jdbc.model.JdbcConnections;
import org.kuali.common.jdbc.service.spring.JdbcConnectionsConfig;
import org.kuali.common.jdbc.sql.model.AdminSql;
import org.kuali.common.jdbc.sql.model.DbaSql;
import org.kuali.common.jdbc.sql.model.SqlContext;
import org.kuali.common.jdbc.sql.model.SqlKeys;
import org.kuali.common.jdbc.vendor.model.DatabaseVendor;
import org.kuali.common.jdbc.vendor.spring.DatabaseVendorConfig;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={SpringServiceConfig.class, DatabaseVendorConfig.class, JdbcConnectionsConfig.class})
public class SqlContextConfig {
    @Autowired
    DatabaseVendor vendor;
    @Autowired
    JdbcConnections connections;
    @Autowired
    EnvironmentService env;

    @Bean
    public SqlContext sqlContext() {
        Credentials auth = this.connections.getNormal().getCredentials();
        int threads = this.env.getInteger(SqlKeys.THREADS.getValue(), Integer.valueOf(8));
        String encoding = this.env.getString(SqlKeys.ENCODING.getValue());
        String schema = this.env.getString(SqlKeys.SCHEMA.getValue(), auth.getUsername());
        String username = this.env.getString(SqlKeys.USERNAME.getValue(), auth.getUsername());
        String password = this.env.getString(SqlKeys.PASSWORD.getValue(), auth.getPassword());
        String validate = this.env.getString(SqlKeys.VALIDATE.getValue(), this.vendor.getSql().getAdmin().getValidate());
        String create = this.env.getString(SqlKeys.CREATE.getValue(), this.vendor.getSql().getAdmin().getCreate());
        String drop = this.env.getString(SqlKeys.DROP.getValue(), this.vendor.getSql().getAdmin().getDrop());
        String dbaBefore = this.env.getString(SqlKeys.DBA_BEFORE.getValue(), this.vendor.getSql().getDba().getBefore());
        String dbaAfter = this.env.getString(SqlKeys.DBA_AFTER.getValue(), this.vendor.getSql().getDba().getAfter());
        DbaSql dba = new DbaSql(dbaBefore, dbaAfter);
        AdminSql admin = new AdminSql(validate, create, drop);
        Credentials creds = new Credentials(username, password);
        return new SqlContext(creds, dba, admin, schema, encoding, threads);
    }
}

