/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.supplier;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kuali.common.jdbc.DefaultSqlReader;
import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.SqlMetaData;
import org.kuali.common.jdbc.SqlReader;
import org.kuali.common.jdbc.supplier.AbstractSupplier;
import org.kuali.common.util.LocationUtils;
import org.springframework.util.Assert;

@Deprecated
public class ComplexStringSupplier
extends AbstractSupplier {
    protected int index = 0;
    protected BufferedReader in;
    List<String> strings;
    SqlReader reader = new DefaultSqlReader();

    public ComplexStringSupplier() {
        this((String)null);
    }

    public ComplexStringSupplier(String sql) {
        this(Arrays.asList(sql));
    }

    public ComplexStringSupplier(List<String> strings) {
        this.strings = strings;
    }

    @Override
    public void open() {
        Assert.notNull(this.strings, (String)"strings is null");
        this.index = 0;
        this.in = this.getBufferedReader(this.strings, this.index);
    }

    @Override
    public List<String> getSql() {
        try {
            List<String> sql = this.reader.getSql(this.in);
            if (sql != null) {
                return sql;
            }
            ++this.index;
            if (this.index == this.strings.size()) {
                return null;
            }
            this.in = this.getBufferedReader(this.strings, this.index);
            return this.getSql();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected BufferedReader getBufferedReader(List<String> strings, int index) {
        String string = strings.get(index);
        return LocationUtils.getBufferedReaderFromString((String)string);
    }

    @Override
    public void close() {
        this.index = 0;
        IOUtils.closeQuietly((Reader)this.in);
    }

    @Override
    public void fillInMetaData() {
        long count = 0L;
        long size = 0L;
        for (String string : this.strings) {
            SqlMetaData smd = this.getMetaData(string);
            count += smd.getCount();
            size += smd.getSize();
        }
        this.metaData = new SqlMetaData(count, size);
    }

    protected SqlMetaData getMetaData(String sql) {
        BufferedReader in = null;
        try {
            in = LocationUtils.getBufferedReaderFromString((String)sql);
            SqlMetaData sqlMetaData = JdbcUtils.getSqlMetaData(in, this.reader);
            return sqlMetaData;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(List<String> strings) {
        this.strings = strings;
    }

    public SqlReader getReader() {
        return this.reader;
    }

    public void setReader(SqlReader reader) {
        this.reader = reader;
    }
}

