/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.jdbc.service.MetaDataUtils;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.jdbc.suppliers.AbstractSupplier;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ListUtils;
import org.kuali.common.util.LocationUtils;

public final class ComplexStringSupplier
extends AbstractSupplier {
    private int index = 0;
    private BufferedReader in;
    private final List<String> strings;
    private final SqlReader reader;
    private final SqlMetaData metaData;
    private boolean open = false;
    private boolean done = false;

    public ComplexStringSupplier(String sql, SqlReader reader) {
        this(CollectionUtils.singletonList((Object)sql), reader);
    }

    public ComplexStringSupplier(List<String> strings, SqlReader reader) {
        Assert.noNulls((Object[])new Object[]{strings, reader});
        this.strings = ListUtils.newImmutableArrayList(strings);
        this.reader = reader;
        this.metaData = MetaDataUtils.getSqlMetaData(this);
    }

    @Override
    public synchronized void open() {
        Assert.isFalse((boolean)this.open, (String)"Already open");
        this.open = true;
        this.done = false;
        this.index = 0;
        this.in = this.getBufferedReader(this.strings, this.index);
    }

    @Override
    public synchronized List<String> getSql() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        if (this.done) {
            return null;
        }
        try {
            String sql = this.reader.getSql(this.in);
            if (sql != null) {
                return Arrays.asList(sql);
            }
            ++this.index;
            if (this.index == this.strings.size()) {
                this.done = true;
                return null;
            }
            this.in = this.getBufferedReader(this.strings, this.index);
            return this.getSql();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void close() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        this.open = false;
        IOUtils.closeQuietly((Reader)this.in);
    }

    protected BufferedReader getBufferedReader(List<String> strings, int index) {
        String string = strings.get(index);
        return LocationUtils.getBufferedReaderFromString((String)string);
    }

    @Override
    public SqlMetaData getMetaData() {
        return this.metaData;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public SqlReader getReader() {
        return this.reader;
    }
}

