/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.suppliers.LocationSupplierFactory;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ListUtils;
import org.kuali.common.util.LocationUtils;

public final class ResourcesSupplierFactory {
    public static final String DEFAULT_EXTENSION = "resources";
    private final String extension;
    private final String suffix;
    private final List<LocationSupplierFactory> factories;

    public ResourcesSupplierFactory(LocationSupplierFactory factory) {
        this(CollectionUtils.singletonList((Object)factory));
    }

    public ResourcesSupplierFactory(List<LocationSupplierFactory> factories) {
        this(DEFAULT_EXTENSION, factories);
    }

    public ResourcesSupplierFactory(String extension, List<LocationSupplierFactory> factories) {
        Assert.noBlanks((String[])new String[]{extension});
        Assert.isFalse((boolean)CollectionUtils.isEmpty(factories), (String)"Must provide at least one factory");
        this.factories = ListUtils.newImmutableArrayList(factories);
        this.extension = extension;
        this.suffix = "." + extension;
    }

    public List<SqlSupplier> getSuppliers(List<String> resourceLocations) {
        ArrayList<SqlSupplier> suppliers = new ArrayList<SqlSupplier>();
        for (String resourceLocation : resourceLocations) {
            suppliers.addAll(this.getSuppliers(resourceLocation));
        }
        return suppliers;
    }

    public List<SqlSupplier> getSuppliers(String resourcesLocation) {
        Assert.noBlanks((String[])new String[]{resourcesLocation});
        Assert.isTrue((boolean)this.isMatch(resourcesLocation));
        List resources = LocationUtils.getLocations((String)resourcesLocation);
        ArrayList<SqlSupplier> suppliers = new ArrayList<SqlSupplier>();
        for (String resource : resources) {
            SqlSupplier supplier = this.getSupplier(resource);
            suppliers.add(supplier);
        }
        return suppliers;
    }

    public SqlSupplier getSupplier(String location) {
        Assert.noBlanks((String[])new String[]{location});
        LocationSupplierFactory factory = this.findFactory(location);
        return factory.getSupplier(location);
    }

    protected LocationSupplierFactory findFactory(String location) {
        for (LocationSupplierFactory factory : this.factories) {
            if (!factory.isMatch(location)) continue;
            return factory;
        }
        throw new IllegalStateException("Unable to locate a factory for [" + location + "]");
    }

    public boolean isMatch(String location) {
        return StringUtils.endsWith((CharSequence)location, (CharSequence)this.suffix);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<LocationSupplierFactory> getFactories() {
        return this.factories;
    }
}

