/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import java.util.List;
import org.kuali.common.jdbc.service.MetaDataUtils;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.jdbc.suppliers.AbstractSupplier;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ListUtils;

public final class SimpleStringSupplier
extends AbstractSupplier {
    private final SqlMetaData metaData;
    private final List<String> strings;
    private boolean open = false;
    private boolean done = false;

    public SimpleStringSupplier(String sql) {
        this(CollectionUtils.singletonList((Object)sql));
    }

    public SimpleStringSupplier(List<String> strings) {
        Assert.notNull(strings);
        this.strings = ListUtils.newImmutableArrayList(strings);
        this.metaData = MetaDataUtils.getSqlMetaData(this);
    }

    @Override
    public synchronized void open() {
        Assert.isFalse((boolean)this.open, (String)"Already open");
        this.open = true;
        this.done = false;
    }

    @Override
    public synchronized List<String> getSql() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        if (this.done) {
            return null;
        }
        this.done = true;
        return this.strings;
    }

    @Override
    public synchronized void close() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        this.open = false;
    }

    @Override
    public SqlMetaData getMetaData() {
        return this.metaData;
    }

    public List<String> getStrings() {
        return this.strings;
    }
}

