/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.suppliers.LocationSupplierFactory;
import org.kuali.common.jdbc.suppliers.SqlLocationContext;
import org.kuali.common.jdbc.suppliers.SqlLocationSupplier;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.Assert;

public class SqlSupplierFactory
implements LocationSupplierFactory {
    public static final String DEFAULT_EXTENSION = "sql";
    private final SqlLocationContext context;
    private final String extension;
    private final String suffix;

    public SqlSupplierFactory(SqlLocationContext context) {
        this(DEFAULT_EXTENSION, context);
    }

    public SqlSupplierFactory(String extension, SqlLocationContext context) {
        Assert.noBlanks((String[])new String[]{extension});
        Assert.noNulls((Object[])new Object[]{context});
        this.extension = extension;
        this.context = context;
        this.suffix = "." + extension;
    }

    @Override
    public SqlSupplier getSupplier(String location) {
        Assert.noBlanks((String[])new String[]{location});
        Assert.isTrue((boolean)this.isMatch(location));
        return new SqlLocationSupplier(location, this.context);
    }

    @Override
    public boolean isMatch(String location) {
        return StringUtils.endsWith((CharSequence)location, (CharSequence)this.suffix);
    }

    public String getExtension() {
        return this.extension;
    }

    public SqlLocationContext getContext() {
        return this.context;
    }
}

