/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.vendor.spring;

import org.kuali.common.jdbc.vendor.model.DatabaseVendor;
import org.kuali.common.jdbc.vendor.model.VendorDefault;
import org.kuali.common.jdbc.vendor.service.DatabaseVendorService;
import org.kuali.common.jdbc.vendor.service.MySqlDatabaseVendorService;
import org.kuali.common.jdbc.vendor.service.OracleDatabaseVendorService;
import org.kuali.common.util.Assert;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={SpringServiceConfig.class})
public class DatabaseVendorConfig {
    private static final String VENDOR_KEY = "db.vendor";
    @Autowired
    EnvironmentService env;

    @Bean
    public DatabaseVendorService databaseVendorService() {
        String vendorString = this.env.getString(VENDOR_KEY);
        Assert.noBlanks((String[])new String[]{vendorString});
        VendorDefault vendor = VendorDefault.valueOf(vendorString.toUpperCase());
        switch (vendor) {
            case ORACLE: {
                return new OracleDatabaseVendorService(this.env, vendor);
            }
            case MYSQL: {
                return new MySqlDatabaseVendorService(this.env, vendor);
            }
        }
        throw new IllegalStateException("Vendor [" + (Object)((Object)vendor) + "] is unknown");
    }

    @Bean
    public DatabaseVendor databaseVendor() {
        return this.databaseVendorService().getDatabaseVendor();
    }
}

