/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.common.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(UrlBuilder.class);

    public String getQuery(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    protected boolean isTargetGroupId(MavenProject project, String organizationGroupId) {
        if (project == null || organizationGroupId == null) {
            return false;
        }
        return organizationGroupId.equals(project.getGroupId());
    }

    protected String getTrimmedGroupId(MavenProject project, String organizationGroupId) {
        String groupId = project.getGroupId();
        if (StringUtils.isEmpty((String)organizationGroupId)) {
            return groupId;
        }
        if (!groupId.startsWith(organizationGroupId)) {
            logger.warn("Group Id: '" + groupId + "' does not start with '" + organizationGroupId + "'");
            return groupId;
        }
        String s = StringUtils.replace((String)groupId, (String)organizationGroupId, (String)"");
        if (s.startsWith(".")) {
            s = s.substring(1);
        }
        s = s.replace(".", "/");
        return s;
    }

    protected boolean isAppendArtifactId(MavenProject project, String trimmedGroupId) {
        if (this.isEmpty(project.getModules())) {
            return true;
        }
        return !trimmedGroupId.endsWith(project.getArtifactId());
    }

    public String getSitePath(MavenProject project, String organizationGroupId) {
        String trimmedGroupId = this.getTrimmedGroupId(project, organizationGroupId);
        StringBuilder sb = new StringBuilder(trimmedGroupId);
        if (this.isAppendArtifactId(project, trimmedGroupId)) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(project.getArtifactId());
        }
        return sb.toString();
    }

    protected boolean isEmpty(Collection<?> c) {
        if (c == null) {
            return true;
        }
        return c.isEmpty();
    }

    protected String getBaseUrl(String protocol, String hostname, MavenProject project, SiteContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol);
        sb.append("://");
        sb.append(hostname);
        sb.append("/");
        sb.append(this.getSitePath(project, context.getOrganizationGroupId()));
        sb.append("/");
        sb.append(project.getVersion());
        sb.append("/");
        return sb.toString();
    }

    public boolean isBaseCase(MavenProject project, String organizationGroupId) {
        if (this.isTargetGroupId(project, organizationGroupId)) {
            return true;
        }
        MavenProject parent = project.getParent();
        if (parent == null) {
            return true;
        }
        return this.isTargetGroupId(parent, organizationGroupId);
    }

    public String getPublicUrl(MavenProject project, SiteContext context) {
        String organizationGroupId = context.getOrganizationGroupId();
        if (this.isBaseCase(project, organizationGroupId)) {
            return this.getBaseUrl(context.getPublicUrlProtocol(), context.getHostname(), project, context);
        }
        return this.getPublicUrl(project.getParent(), context) + project.getArtifactId() + "/";
    }

    public String getPublishUrl(MavenProject project, SiteContext context) {
        String organizationGroupId = context.getOrganizationGroupId();
        if (this.isBaseCase(project, organizationGroupId)) {
            return this.getBaseUrl(context.getPublishUrlProtocol(), context.getBucket(), project, context);
        }
        return this.getPublishUrl(project.getParent(), context) + project.getArtifactId() + "/";
    }

    public boolean isSnapshot(MavenProject project) {
        String version = project.getVersion();
        int pos = version.toUpperCase().indexOf("SNAPSHOT");
        boolean isSnapshot = pos != -1;
        return isSnapshot;
    }

    public MavenProject getMavenProject(String groupId, String artifactId, String packaging) {
        MavenProject project = new MavenProject();
        project.setGroupId(groupId);
        project.setArtifactId(artifactId);
        project.setPackaging(packaging);
        return project;
    }

    public String getDownloadUrl(MavenProject project, SiteContext context) {
        String prefix = context.getDownloadPrefix();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (!prefix.endsWith("/")) {
            sb.append("/");
        }
        if (this.isSnapshot(project)) {
            sb.append(context.getDownloadSnapshotPrefix());
        } else {
            sb.append(context.getDownloadReleasePrefix());
        }
        sb.append("/");
        String groupId = project.getGroupId();
        sb.append(groupId.replace('.', '/'));
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("/");
        sb.append(project.getVersion());
        sb.append("/");
        return sb.toString();
    }
}

