/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.common.ResourceUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertiesUtils {
    PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}");
    ResourceUtils resourceUtils = new ResourceUtils();

    public static String[] splitAndTrim(String csv, String separator) {
        String[] tokens;
        for (String token : tokens = StringUtils.split((String)csv, (String)separator)) {
            token = token.trim();
        }
        return tokens;
    }

    public String getResolvedValue(String value, Properties properties) {
        return this.helper.replacePlaceholders(value, properties);
    }

    public Properties getProperties(List<String> locations) throws IOException {
        Properties properties = new Properties();
        for (String location : locations) {
            properties.putAll((Map<?, ?>)this.getProperties(location));
        }
        return properties;
    }

    public Properties getMavenProperties(MavenProject project) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)this.getEnvironmentProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public Properties getEnvironmentProperties() {
        String prefix = "env.";
        Map<String, String> env = System.getenv();
        Properties properties = new Properties();
        for (Map.Entry<String, String> pair : env.entrySet()) {
            String key = prefix + pair.getKey();
            String value = pair.getValue();
            properties.setProperty(key, value);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String location) throws IOException {
        Properties properties;
        InputStream in = null;
        try {
            in = this.resourceUtils.getInputStream(location);
            Properties properties2 = new Properties();
            if (this.isXml(location)) {
                properties2.loadFromXML(in);
            } else {
                properties2.load(in);
            }
            properties = properties2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    public boolean isXml(String location) {
        return location.toLowerCase().endsWith(".xml");
    }
}

