/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.externals;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.Version;
import org.kuali.common.util.VersionUtils;
import org.kuali.maven.common.Extractor;
import org.kuali.maven.common.PropertiesUtils;
import org.kuali.maven.plugins.externals.AbstractTagMojo;
import org.kuali.maven.plugins.externals.BuildTag;
import org.kuali.maven.plugins.externals.GAV;
import org.kuali.maven.plugins.externals.Mapping;
import org.kuali.maven.plugins.externals.POMUtils;
import org.kuali.maven.plugins.externals.Project;
import org.kuali.maven.plugins.externals.SVNExternal;
import org.kuali.maven.plugins.externals.SVNUtils;
import org.kuali.maven.plugins.externals.TagStyle;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;

public class MojoHelper {
    private static final String QUALIFIER_DELIMETER = "-";
    private static final String MAVEN_SNAPSHOT_TOKEN = "SNAPSHOT";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final String majorQualifierFoundersReleasePrefix = "FR";
    private static final String minorQualiferMilestonePrefix = "M";
    private static final String minorQualiferReleaseCandidatePrefix = "RC";
    SVNUtils svnUtils = SVNUtils.getInstance();
    POMUtils pomUtils = new POMUtils();
    Extractor extractor = new Extractor();
    PropertiesUtils propertiesUtils = new PropertiesUtils();
    NumberFormat nf = NumberFormat.getInstance();
    private final Log logger;
    protected static MojoHelper instance;

    protected MojoHelper(Mojo mojo) {
        this.nf.setMaximumFractionDigits(3);
        this.nf.setMinimumFractionDigits(3);
        this.nf.setGroupingUsed(false);
        this.logger = mojo.getLog();
    }

    public static synchronized MojoHelper getInstance(Mojo mojo) {
        if (instance == null) {
            instance = new MojoHelper(mojo);
        }
        return instance;
    }

    public void incrementVersions(AbstractTagMojo mojo) {
        List<File> files = this.getPoms(mojo.getProject().getBasedir(), mojo.getPom(), mojo.getIgnoreDirectories());
        List<DefaultMutableTreeNode> nodes = this.getNodes(files);
        DefaultMutableTreeNode node = this.getTree(mojo.getProject().getBasedir(), nodes, mojo.getPom());
        this.incrementVersions(node);
        this.updateGavs(node);
        this.updateProperties(node, mojo.getProject().getProperties(), mojo.getMappings());
        this.updateXml(node);
        this.writePoms(node, mojo.getProject().getBasedir());
        List<SVNExternal> externals = this.svnUtils.getExternals(mojo.getProject().getBasedir());
        this.logger.info((CharSequence)"Committing pom changes");
        this.commitChanges(mojo.getProject().getBasedir(), externals, "[externals-maven-plugin] prepare for next development iteration");
    }

    protected List<DefaultMutableTreeNode> getChildren(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            children.add(child);
        }
        return children;
    }

    public void incrementVersions(DefaultMutableTreeNode node) {
        Project project = (Project)node.getUserObject();
        GAV gav = project.getGav();
        String oldVersion = gav.getVersion();
        if (!StringUtils.isBlank((String)oldVersion)) {
            String newVersion = this.getNextVersion(oldVersion);
            GAV newGav = new GAV();
            newGav.setGroupId(gav.getGroupId());
            newGav.setArtifactId(gav.getArtifactId());
            newGav.setVersion(newVersion);
            project.setNewGav(newGav);
            this.logger.info((CharSequence)(StringUtils.repeat((String)"  ", (int)node.getLevel()) + gav.getArtifactId() + ":" + gav.getArtifactId() + ":" + oldVersion + "->" + newVersion));
        }
        List<DefaultMutableTreeNode> children = this.getChildren(node);
        for (DefaultMutableTreeNode child : children) {
            this.incrementVersions(child);
        }
    }

    public void createAndUpdateTags(AbstractTagMojo mojo) {
        int buildNumber = this.getBuildNumber(mojo.getProject(), mojo.getBuildNumberProperty());
        GAV gav = this.getGav(mojo.getProject());
        List<File> files = this.getPoms(mojo.getProject().getBasedir(), mojo.getPom(), mojo.getIgnoreDirectories());
        List<DefaultMutableTreeNode> nodes = this.getNodes(files);
        DefaultMutableTreeNode node = this.getTree(mojo.getProject().getBasedir(), nodes, mojo.getPom());
        List<SVNExternal> externals = this.svnUtils.getExternals(mojo.getProject().getBasedir());
        this.validate(mojo.getProject(), externals, mojo.getMappings());
        BuildTag rootTag = this.getBuildTag(mojo.getProject().getBasedir(), gav, mojo.getTagStyle(), buildNumber);
        this.updateBuildInfo(node, rootTag, mojo.getTagStyle(), buildNumber);
        List<BuildTag> moduleTags = this.getBuildTags(mojo.getProject().getProperties(), externals, mojo.getMappings(), mojo.getTagStyle(), buildNumber);
        this.updateBuildInfo(nodes, moduleTags, mojo.getMappings(), mojo.getTagStyle(), buildNumber);
        this.updateGavs(node);
        this.updateXml(node);
        this.updateProperties(node, mojo.getProject().getProperties(), mojo.getMappings());
        this.updateScm(node, mojo.getScmUrlPrefix());
        SVNInfo repoInfo = this.svnUtils.getInfo(mojo.getProject().getBasedir());
        SVNURL repositoryRoot = repoInfo.getRepositoryRootURL();
        List<SVNExternal> newExternals = this.getExternals(mojo.getProject().getScm().getDeveloperConnection().substring(mojo.getScmUrlPrefix().length()), repositoryRoot.toString(), moduleTags, mojo.getMappings());
        this.createTags(moduleTags, mojo.getCreateTagMessage());
        this.createTag(rootTag, mojo.getCreateTagMessage());
        File checkoutDir = mojo.getCheckoutDir();
        SVNCommitInfo info = this.svnUtils.setExternals(rootTag.getTagUrl(), newExternals, mojo.getExternalsMessage());
        this.logger.info((CharSequence)("Set " + newExternals.size() + " externals @ " + rootTag.getTagUrl()));
        this.logger.info((CharSequence)("Committed revision " + info.getNewRevision() + "."));
        this.logger.info((CharSequence)("Checking out - " + rootTag.getTagUrl()));
        this.logger.info((CharSequence)("Checkout dir - " + checkoutDir.getAbsolutePath()));
        if (checkoutDir.exists()) {
            this.logger.info((CharSequence)("Deleting " + checkoutDir.getAbsolutePath()));
            this.deleteDirectory(checkoutDir);
        }
        long start = System.currentTimeMillis();
        long revision = this.svnUtils.checkout(rootTag.getTagUrl(), checkoutDir, null, null);
        this.logTime("Total checkout time: ", System.currentTimeMillis() - start);
        this.logger.info((CharSequence)("Checked out revision " + revision + "."));
        this.writePoms(node, mojo.getProject().getBasedir(), checkoutDir);
        this.updateExternalsFile(newExternals, mojo.getFile());
        this.commitChanges(checkoutDir, newExternals, mojo.getUpdateTagMessage());
    }

    public GAV getGav(MavenProject project) {
        GAV gav = new GAV();
        gav.setGroupId(project.getGroupId());
        gav.setArtifactId(project.getArtifactId());
        gav.setVersion(project.getVersion());
        return gav;
    }

    public String toString(GAV gav) {
        StringBuilder sb = new StringBuilder();
        sb.append(gav.getGroupId());
        sb.append(":");
        sb.append(gav.getArtifactId());
        sb.append(":");
        sb.append(gav.getVersion());
        return sb.toString();
    }

    public String getGroupId(DefaultMutableTreeNode node) {
        List<Project> projects = this.getProjectPath(node);
        for (Project project : projects) {
            GAV gav = project.getGav();
            if (StringUtils.isBlank((String)gav.getGroupId())) continue;
            return gav.getGroupId();
        }
        throw new IllegalStateException("Unable to determine a version");
    }

    public String getVersion(DefaultMutableTreeNode node) {
        List<Project> projects = this.getProjectPath(node);
        for (Project project : projects) {
            GAV gav = project.getGav();
            if (StringUtils.isBlank((String)gav.getVersion())) continue;
            return gav.getVersion();
        }
        throw new IllegalStateException("Unable to determine a version");
    }

    protected List<Project> getProjectPath(DefaultMutableTreeNode node) {
        Object[] projectObjects = node.getUserObjectPath();
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Object projectObject : projectObjects) {
            projects.add((Project)projectObject);
        }
        Collections.reverse(projects);
        return projects;
    }

    public String getDisplayString(DefaultMutableTreeNode node) {
        Project project = (Project)node.getUserObject();
        GAV gav = project.getGav();
        GAV parent = project.getParent();
        int level = node.getLevel();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.repeat((String)" ", (int)level));
        sb.append(this.toString(parent));
        sb.append(" -> ");
        sb.append(this.toString(gav));
        sb.append("\n");
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            sb.append(this.getDisplayString(child));
        }
        return sb.toString();
    }

    public String getDisplayString(DefaultMutableTreeNode node, File basedir, String pomFile) {
        Project project = (Project)node.getUserObject();
        File pom = project.getPom();
        String pomPath = pom.getAbsolutePath();
        String displayPath = pomPath.replace(basedir.getAbsolutePath(), "");
        displayPath = displayPath.replace(pomFile, "");
        if (!node.isRoot()) {
            displayPath = displayPath.substring(0, displayPath.length() - 1);
            int pos = displayPath.lastIndexOf(File.separator);
            displayPath = displayPath.substring(pos);
            displayPath = displayPath.replace("/", "");
        }
        int level = node.getLevel();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.repeat((String)" ", (int)level));
        sb.append(displayPath);
        sb.append("\n");
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            sb.append(this.getDisplayString(child, basedir, pomFile));
        }
        return sb.toString();
    }

    protected List<DefaultMutableTreeNode> getNodes(List<File> files) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (File file : files) {
            String pomContents = this.read(file);
            GAV parent = this.pomUtils.getParentGAV(pomContents);
            GAV gav = this.pomUtils.getGAV(pomContents);
            Project project = new Project();
            project.setPom(file);
            project.setPomContents(pomContents);
            project.setGav(gav);
            project.setParent(parent);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(project);
            nodes.add(node);
        }
        return nodes;
    }

    public Map<String, DefaultMutableTreeNode> getMap(List<DefaultMutableTreeNode> nodes) {
        HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
        for (DefaultMutableTreeNode node : nodes) {
            Project project = (Project)node.getUserObject();
            File file = project.getPom();
            map.put(file.getAbsolutePath(), node);
        }
        return map;
    }

    public DefaultMutableTreeNode getTree(File basedir, List<DefaultMutableTreeNode> nodes, String pomFile) {
        Map<String, DefaultMutableTreeNode> map = this.getMap(nodes);
        for (DefaultMutableTreeNode child : nodes) {
            Project project = (Project)child.getUserObject();
            File pom = project.getPom();
            File pomDir = pom.getParentFile();
            File parentPom = new File(pomDir.getParentFile(), pomFile);
            String parentPomPath = parentPom.getAbsolutePath();
            DefaultMutableTreeNode parent = map.get(parentPomPath);
            if (parent == null) continue;
            parent.add(child);
        }
        String rootPom = basedir + File.separator + pomFile;
        DefaultMutableTreeNode root = map.get(rootPom);
        return root;
    }

    protected IOFileFilter getIgnoreDirectoryFilter(String dir) {
        return FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter((String)dir)}));
    }

    protected IOFileFilter getIgnoreDirectoriesFilter(String csv) {
        return this.getIgnoreDirectoriesFilter(csv.split(","));
    }

    protected IOFileFilter getIgnoreDirectoriesFilter(String ... directories) {
        IOFileFilter[] filters = new IOFileFilter[directories.length];
        for (int i = 0; i < filters.length; ++i) {
            String dir = directories[i].trim();
            filters[i] = this.getIgnoreDirectoryFilter(dir);
        }
        return FileFilterUtils.and((IOFileFilter[])filters);
    }

    public List<File> getPoms(File basedir, String pomFile, String ignoreDirectoriesCSV) {
        IOFileFilter fileFilter = FileFilterUtils.nameFileFilter((String)pomFile);
        IOFileFilter dirFilter = this.getIgnoreDirectoriesFilter(ignoreDirectoriesCSV);
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles((File)basedir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter));
        Collections.sort(files);
        return files;
    }

    public List<SVNExternal> getExternals(String scmUrlPrefix, String repoPrefix, List<BuildTag> moduleTags, List<Mapping> mappings) {
        ArrayList<SVNExternal> externals = new ArrayList<SVNExternal>();
        for (int i = 0; i < mappings.size(); ++i) {
            Mapping mapping = mappings.get(i);
            BuildTag moduleTag = moduleTags.get(i);
            SVNExternal external = new SVNExternal();
            external.setPath(mapping.getModule());
            external.setUrl(this.computeRelativeUrl(scmUrlPrefix, repoPrefix, moduleTag.getTagUrl()));
            externals.add(external);
        }
        return externals;
    }

    private String computeRelativeUrl(String sourceUrl, String repoURL, String tagUrl) {
        if (sourceUrl.startsWith("\\^")) {
            if (tagUrl.startsWith("/")) {
                return "^" + tagUrl;
            }
            return "^/" + tagUrl;
        }
        String subTagUrl = tagUrl.substring(repoURL.length());
        if (subTagUrl.startsWith("/")) {
            return "^" + subTagUrl;
        }
        return "^/" + subTagUrl;
    }

    public boolean exists(String url) {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(url);
        return resource.exists();
    }

    public void createTag(BuildTag buildTag, String message) {
        this.createTags(Collections.singletonList(buildTag), message);
    }

    public void createTags(List<BuildTag> buildTags, String message) {
        for (BuildTag buildTag : buildTags) {
            String src = buildTag.getSourceUrl();
            long revision = buildTag.getSourceRevision();
            String dst = buildTag.getTagUrl();
            boolean exists = this.exists(dst);
            if (exists) {
                this.logger.info((CharSequence)("Skip existing tag [" + dst + "]"));
                buildTag.setSkipped(true);
                continue;
            }
            SVNCommitInfo info = this.svnUtils.copy(src, revision, dst, message);
            this.logger.info((CharSequence)("Created [" + dst + "]"));
            this.logger.debug((CharSequence)("Comitted revision " + info.getNewRevision()));
        }
    }

    public void updateExternalsFile(List<SVNExternal> externals, File externalsFile) {
        StringBuilder sb = new StringBuilder();
        for (SVNExternal external : externals) {
            sb.append(external.getUrl());
            sb.append(" ");
            sb.append(external.getPath());
            sb.append("\n");
        }
        this.write(externalsFile, sb.toString());
        this.logger.info((CharSequence)("Updated svn:externals control file - " + externalsFile.getAbsolutePath()));
    }

    public void commitChanges(File dir, List<SVNExternal> externals, String msg) {
        ArrayList<File> workingCopyPaths = new ArrayList<File>();
        workingCopyPaths.add(dir);
        for (SVNExternal external : externals) {
            String path = dir.getAbsolutePath() + File.separator + external.getPath();
            workingCopyPaths.add(new File(path));
        }
        File[] commitDirs = workingCopyPaths.toArray(new File[workingCopyPaths.size()]);
        SVNCommitInfo info = this.svnUtils.commit(commitDirs, msg, null, null);
        this.logger.info((CharSequence)("Committed revision " + info.getNewRevision() + "."));
    }

    public void logTime(String msg, long elapsed) {
        double millis = (double)elapsed * 1.0;
        double millisPerSecond = 1000.0;
        double millisPerMinute = 60.0 * millisPerSecond;
        double millisPerHour = 60.0 * millisPerMinute;
        if (millis > millisPerHour) {
            this.logger.info((CharSequence)(msg + this.nf.format(millis / millisPerHour) + "h"));
        } else if (millis > millisPerMinute) {
            this.logger.info((CharSequence)(msg + this.nf.format(millis / millisPerMinute) + "m"));
        } else {
            this.logger.info((CharSequence)(msg + this.nf.format(millis / millisPerSecond) + "s"));
        }
    }

    public void writePoms(DefaultMutableTreeNode node, File baseDir) {
        int count = 0;
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            String newContents;
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            Project project = (Project)element.getUserObject();
            File pom = project.getPom();
            String oldContents = this.read(pom);
            if (oldContents.equals(newContents = project.getPomContents())) continue;
            this.logger.debug((CharSequence)("Updating " + pom.getAbsolutePath()));
            this.write(pom, newContents);
            ++count;
        }
        this.logger.info((CharSequence)("Updated " + count + " Maven pom's"));
    }

    public void writePoms(DefaultMutableTreeNode node, File baseDir, File checkoutDir) {
        int count = 0;
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            String newContents;
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            Project project = (Project)element.getUserObject();
            File pom = project.getPom();
            String relativePath = this.getRelativePath(baseDir, pom);
            File newPom = new File(checkoutDir.getAbsolutePath() + File.separator + relativePath);
            String oldContents = this.read(pom);
            if (oldContents.equals(newContents = project.getPomContents())) continue;
            this.logger.debug((CharSequence)("Updating " + newPom.getAbsolutePath()));
            this.write(newPom, newContents);
            ++count;
        }
        this.logger.info((CharSequence)("Updated " + count + " Maven pom's"));
    }

    protected String getRelativePath(File dir, File file) {
        String dirPath = dir.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        return filePath.replace(dirPath, "");
    }

    public void updateScm(DefaultMutableTreeNode root, String scmUrlPrefix) {
        Project project = (Project)root.getUserObject();
        BuildTag buildTag = project.getBuildTag();
        String url = buildTag.getTagUrl();
        String oldXml = project.getPomContents();
        String newXml = this.pomUtils.updateScm(oldXml, scmUrlPrefix, url);
        project.setPomContents(newXml);
    }

    protected String getGroupId(Project project) {
        GAV gav = project.getGav();
        GAV parent = project.getParent();
        String groupId = gav.getGroupId();
        String parentGroupId = parent.getGroupId();
        if (!StringUtils.isBlank((String)groupId)) {
            return groupId;
        }
        return parentGroupId;
    }

    protected String getVersion(Project project) {
        GAV gav = project.getGav();
        GAV parent = project.getParent();
        String version = gav.getVersion();
        String parentVersion = parent.getVersion();
        if (!StringUtils.isBlank((String)version)) {
            return version;
        }
        return parentVersion;
    }

    public void updateGavs(DefaultMutableTreeNode node) {
        Project project = (Project)node.getUserObject();
        if (project.getNewGav() != null) {
            project.setGav(project.getNewGav());
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            String newParentVersion;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            Project childProject = (Project)child.getUserObject();
            String oldParentVersion = childProject.getParent().getVersion();
            if (!oldParentVersion.equals(newParentVersion = this.getVersion(node))) {
                childProject.getParent().setVersion(newParentVersion);
            }
            this.updateGavs(child);
        }
    }

    public void updateProperties(DefaultMutableTreeNode node, Properties properties, List<Mapping> mappings) {
        Project project = (Project)node.getUserObject();
        Properties versionProperties = this.getVersionProperties(properties, mappings, node);
        String oldXml = project.getPomContents();
        String newXml = this.pomUtils.updateProperties(oldXml, versionProperties);
        project.setPomContents(newXml);
    }

    public Properties getVersionProperties(Properties properties, List<Mapping> mappings, DefaultMutableTreeNode node) {
        Properties newProperties = new Properties();
        for (Mapping mapping : mappings) {
            String artifactId = mapping.getModule();
            String key = mapping.getVersionProperty();
            String oldValue = properties.getProperty(key);
            if (StringUtils.isBlank((String)oldValue)) {
                throw new IllegalStateException("No existing value for '" + key + "'");
            }
            DefaultMutableTreeNode moduleNode = this.findNode(node, artifactId);
            String newValue = this.getVersion(moduleNode);
            newProperties.setProperty(key, newValue);
        }
        return newProperties;
    }

    protected DefaultMutableTreeNode findNode(DefaultMutableTreeNode node, String artifactId) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            Project project = (Project)element.getUserObject();
            GAV gav = project.getGav();
            if (!gav.getArtifactId().equals(artifactId)) continue;
            return element;
        }
        throw new IllegalStateException("Unable to locate " + artifactId);
    }

    public void updateXml(DefaultMutableTreeNode node) {
        Project project = (Project)node.getUserObject();
        String version = project.getGav().getVersion();
        if (!StringUtils.isBlank((String)version)) {
            String oldXml = project.getPomContents();
            String newXml = this.pomUtils.updateVersion(oldXml, version);
            project.setPomContents(newXml);
        }
        String parentVersion = project.getParent().getVersion();
        String oldXml = project.getPomContents();
        String newXml = this.pomUtils.updateParentVersion(oldXml, parentVersion);
        project.setPomContents(newXml);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.updateXml(child);
        }
    }

    protected void log(DefaultMutableTreeNode node) {
        StringBuilder sb = new StringBuilder();
        this.logger.info((CharSequence)sb.toString());
    }

    public Map<String, DefaultMutableTreeNode> getGavMap(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            Project project = (Project)element.getUserObject();
            GAV gav = project.getGav();
            String gavId = this.toString(gav);
            map.put(gavId, element);
        }
        return map;
    }

    public void validateMappings(Properties properties, List<Mapping> mappings, DefaultMutableTreeNode node) {
        for (Mapping mapping : mappings) {
            boolean valid = this.isValid(properties, mapping, node);
            if (valid) continue;
            throw new IllegalStateException("Version mismatch on " + mapping.getModule());
        }
    }

    public boolean isValid(Properties properties, Mapping mapping, DefaultMutableTreeNode node) {
        String gavVersion;
        DefaultMutableTreeNode match = this.findNode(node, mapping.getModule());
        Project project = (Project)match.getUserObject();
        GAV gav = project.getGav();
        String propertyVersion = properties.getProperty(mapping.getVersionProperty());
        if (propertyVersion.equals(gavVersion = gav.getVersion())) {
            return true;
        }
        this.logger.error((CharSequence)String.format("(artifactId, propertyVersion, gavVersion) = (%s, %s, %s)", project.getGav().getArtifactId(), propertyVersion, gavVersion));
        return false;
    }

    public void validateParents(DefaultMutableTreeNode node, Map<String, DefaultMutableTreeNode> map) {
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Project project;
            GAV parentGav;
            String parentGavId;
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)e.nextElement();
            if (element.isRoot() || (parent = map.get(parentGavId = this.toString(parentGav = (project = (Project)element.getUserObject()).getParent()))) != null) continue;
            throw new IllegalStateException(parentGavId + " could not be located");
        }
    }

    public void fillInGavs(DefaultMutableTreeNode node) {
        Project project = (Project)node.getUserObject();
        GAV gav = project.getGav();
        String groupId = this.getGroupId(node);
        String version = this.getVersion(node);
        if (gav.getGroupId() == null) {
            gav.setGroupId(groupId);
            this.logger.debug((CharSequence)("Update " + gav.getArtifactId() + "->" + groupId));
        }
        if (gav.getVersion() == null) {
            gav.setVersion(version);
            this.logger.debug((CharSequence)("Update " + gav.getArtifactId() + "->" + version));
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            this.fillInGavs(child);
        }
    }

    public void updateBuildInfo(DefaultMutableTreeNode node, BuildTag buildTag, TagStyle tagStyle, int buildNumber) {
        Project project = (Project)node.getUserObject();
        project.setBuildTag(buildTag);
        GAV oldGav = project.getGav();
        String newVersion = this.getNewVersion(oldGav.getVersion(), buildNumber, buildTag.getSourceRevision(), tagStyle);
        GAV newGav = new GAV();
        newGav.setGroupId(oldGav.getGroupId());
        newGav.setArtifactId(oldGav.getArtifactId());
        newGav.setVersion(newVersion);
        project.setNewGav(newGav);
        this.logger.info((CharSequence)("GAV Update - [" + this.toString(oldGav) + "->" + newVersion + "]"));
    }

    public void updateBuildInfo(List<DefaultMutableTreeNode> nodes, List<BuildTag> moduleTags, List<Mapping> mappings, TagStyle tagStyle, int buildNumber) {
        for (int i = 0; i < mappings.size(); ++i) {
            Mapping mapping = mappings.get(i);
            BuildTag moduleTag = moduleTags.get(i);
            DefaultMutableTreeNode node = this.findNode(nodes, mapping.getModule());
            this.updateBuildInfo(node, moduleTag, tagStyle, buildNumber);
        }
    }

    protected DefaultMutableTreeNode findNode(List<DefaultMutableTreeNode> nodes, String artifactId) {
        for (DefaultMutableTreeNode node : nodes) {
            Project project = (Project)node.getUserObject();
            if (!project.getGav().getArtifactId().equals(artifactId)) continue;
            return node;
        }
        throw new IllegalStateException("Unable to locate " + artifactId);
    }

    public List<BuildTag> getBuildTags(Properties properties, List<SVNExternal> externals, List<Mapping> mappings, TagStyle tagStyle, int buildNumber) {
        Collections.sort(externals);
        Collections.sort(mappings);
        ArrayList<BuildTag> buildTags = new ArrayList<BuildTag>();
        for (int i = 0; i < externals.size(); ++i) {
            SVNExternal external = externals.get(i);
            Mapping mapping = mappings.get(i);
            BuildTag buildTag = this.getBuildTag(properties, external, mapping, tagStyle, buildNumber);
            buildTags.add(buildTag);
        }
        return buildTags;
    }

    public BuildTag getBuildTag(File workingCopy, GAV gav, TagStyle tagStyle, int buildNumber) {
        String sourceUrl = this.svnUtils.getUrl(workingCopy);
        long sourceRevision = this.svnUtils.getLastRevision(workingCopy);
        String version = gav.getVersion();
        String tag = this.getTag(sourceUrl, version, gav.getArtifactId(), buildNumber, sourceRevision, tagStyle);
        BuildTag buildTag = new BuildTag();
        buildTag.setSourceUrl(sourceUrl);
        buildTag.setSourceRevision(sourceRevision);
        buildTag.setTagUrl(tag);
        return buildTag;
    }

    public BuildTag getBuildTag(Properties properties, SVNExternal external, Mapping mapping, TagStyle tagStyle, int buildNumber) {
        File workingCopy = external.getWorkingCopyPath();
        String sourceUrl = this.svnUtils.getUrl(workingCopy);
        long sourceRevision = this.svnUtils.getLastRevision(workingCopy);
        String version = properties.getProperty(mapping.getVersionProperty());
        String tag = this.getTag(sourceUrl, version, mapping.getModule(), buildNumber, sourceRevision, tagStyle);
        BuildTag buildTag = new BuildTag();
        buildTag.setSourceUrl(sourceUrl);
        buildTag.setSourceRevision(sourceRevision);
        buildTag.setTagUrl(tag);
        return buildTag;
    }

    public String getNewVersion(String version, int buildNumber, long revision, TagStyle tagStyle) {
        String trimmed = this.trimSnapshot(version);
        switch (tagStyle) {
            case REVISION: {
                return trimmed + "-r" + revision;
            }
            case BUILDNUMBER: {
                return trimmed + "-build-" + buildNumber;
            }
            case RELEASE: {
                return trimmed;
            }
        }
        throw new IllegalArgumentException((Object)((Object)tagStyle) + " is unknown");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNextVersion(String version) {
        if (!version.contains(MAVEN_SNAPSHOT_TOKEN)) {
            throw new IllegalArgumentException(version + " is not a " + MAVEN_SNAPSHOT_TOKEN);
        }
        Version v = VersionUtils.getVersion((String)version);
        String qualifier = v.getQualifier();
        if (qualifier != null && !qualifier.isEmpty()) {
            String[] qualifierParts = qualifier.split(QUALIFIER_DELIMETER);
            if (qualifierParts.length > 0) {
                StringBuilder nextQualifer = new StringBuilder();
                if (!this.qualifierContainsVersionedPrefix(majorQualifierFoundersReleasePrefix, qualifierParts[0])) throw new IllegalArgumentException("invalid major qualifier: " + qualifierParts[0]);
                if (qualifierParts.length == 2) {
                    nextQualifer.append(qualifierParts[0]);
                    nextQualifer.append(QUALIFIER_DELIMETER);
                    if (this.qualifierContainsVersionedPrefix(minorQualiferMilestonePrefix, qualifierParts[1])) {
                        String nextMilestone = this.incrementQualifier(minorQualiferMilestonePrefix, qualifierParts[1]);
                        nextQualifer.append(nextMilestone);
                    } else {
                        if (!this.qualifierContainsVersionedPrefix(minorQualiferReleaseCandidatePrefix, qualifierParts[1])) throw new IllegalArgumentException("invalid minor qualifier: " + qualifierParts[1]);
                        String nextReleaseCandidate = this.incrementQualifier(minorQualiferReleaseCandidatePrefix, qualifierParts[1]);
                        nextQualifer.append(nextReleaseCandidate);
                    }
                    v.setQualifier(nextQualifer.toString());
                } else {
                    String nextMajorQualifer = this.incrementQualifier(majorQualifierFoundersReleasePrefix, qualifierParts[0]);
                    v.setQualifier(nextMajorQualifer);
                }
            }
        } else {
            Integer oldIncremental = new Integer(v.getIncremental());
            Integer newIncremental = oldIncremental + 1;
            v.setIncremental(newIncremental.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(v.getMajor());
        sb.append(".");
        sb.append(v.getMinor());
        sb.append(".");
        sb.append(v.getIncremental());
        sb.append(QUALIFIER_DELIMETER);
        if (!StringUtils.isBlank((String)v.getQualifier())) {
            sb.append(v.getQualifier());
            sb.append(QUALIFIER_DELIMETER);
        }
        sb.append(MAVEN_SNAPSHOT_TOKEN);
        return sb.toString();
    }

    private String incrementQualifier(String targetPrefix, String qualifier) {
        if (qualifier.toLowerCase().startsWith(targetPrefix.toLowerCase())) {
            String baseQualifier = qualifier.substring(0, targetPrefix.length());
            String token = "";
            try {
                token = qualifier.substring(targetPrefix.length());
                Integer oldVersion = new Integer(token);
                Integer newVersion = oldVersion + 1;
                return baseQualifier + newVersion;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("failed to convert " + token + " suffix of " + qualifier + "into an Integer", e);
            }
        }
        throw new IllegalArgumentException("'" + qualifier + "' does not contain a part starting with '" + targetPrefix);
    }

    protected boolean isKnownMainQualifier(String qualifier) {
        return this.qualifierContainsVersionedPrefix(majorQualifierFoundersReleasePrefix, qualifier);
    }

    protected boolean isKnownSubQualifier(String qualifier) {
        return this.qualifierContainsVersionedPrefix(minorQualiferMilestonePrefix, qualifier) || this.qualifierContainsVersionedPrefix(minorQualiferReleaseCandidatePrefix, qualifier);
    }

    private boolean qualifierContainsVersionedPrefix(String targetPrefix, String qualifier) {
        if (StringUtils.isBlank((String)qualifier)) {
            return false;
        }
        if (qualifier.length() < targetPrefix.length()) {
            return false;
        }
        if (qualifier.toLowerCase().startsWith(targetPrefix.toLowerCase())) {
            try {
                String suffix = StringUtils.substring((String)qualifier, (int)targetPrefix.length());
                Integer.parseInt(suffix);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean isDigit(char c) {
        for (char digit : DIGITS) {
            if (c != digit) continue;
            return true;
        }
        return false;
    }

    public String getTag(String url, String version, String artifactId, int buildNumber, long revision, TagStyle tagStyle) {
        switch (tagStyle) {
            case REVISION: {
                return this.getRevisionTag(url, version, artifactId, revision);
            }
            case BUILDNUMBER: {
                return this.getBuildNumberTag(url, version, artifactId, buildNumber);
            }
            case RELEASE: {
                return this.getReleaseTag(url, version, artifactId);
            }
        }
        throw new IllegalArgumentException((Object)((Object)tagStyle) + " is unknown");
    }

    public int getBuildNumber(MavenProject project, String buildNumberProperty) {
        Properties properties = this.propertiesUtils.getMavenProperties(project);
        String buildNumber = properties.getProperty(buildNumberProperty);
        if (StringUtils.isBlank((String)buildNumber)) {
            this.logger.warn((CharSequence)(buildNumberProperty + " is blank"));
            return 0;
        }
        return new Integer(buildNumber);
    }

    public String getReleaseTag(String url, String version, String artifactId) {
        String tagBase = this.extractor.getTagBase(url);
        if (StringUtils.isBlank((String)tagBase)) {
            throw new IllegalArgumentException("Unable to calculate tag base from [" + url + "]");
        }
        String trimmed = this.trimSnapshot(version);
        StringBuilder sb = new StringBuilder();
        sb.append(tagBase);
        sb.append("/");
        sb.append(artifactId);
        sb.append(QUALIFIER_DELIMETER);
        sb.append(trimmed);
        return sb.toString();
    }

    public String getBuildNumberTag(String url, String version, String artifactId, int buildNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseTag(url, version, artifactId));
        sb.append("/");
        sb.append("build-" + buildNumber);
        return sb.toString();
    }

    public String getRevisionTag(String url, String version, String artifactId, long revision) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseTag(url, version, artifactId));
        sb.append("/");
        sb.append("r" + revision);
        return sb.toString();
    }

    protected String getBaseTag(String url, String version, String artifactId) {
        String tagBase = this.extractor.getTagBase(url);
        if (StringUtils.isBlank((String)tagBase)) {
            throw new IllegalArgumentException("Unable to calculate tag base from [" + url + "]");
        }
        Version v = this.parseVersion(version);
        String trimmed = this.trimSnapshot(version);
        StringBuilder sb = new StringBuilder();
        sb.append(tagBase);
        sb.append("/");
        sb.append("builds");
        sb.append("/");
        sb.append(artifactId);
        sb.append(QUALIFIER_DELIMETER);
        sb.append(v.getMajor());
        sb.append(".");
        sb.append(v.getMinor());
        sb.append("/");
        sb.append(trimmed);
        return sb.toString();
    }

    public void validate(MavenProject project, List<SVNExternal> externals, List<Mapping> mappings) {
        this.validate(externals, mappings);
        this.validate(project, mappings);
        this.validateProjectModules(project, externals);
    }

    public void validateProjectModules(MavenProject project, List<SVNExternal> externals) {
        List modules = project.getModules();
        if (this.isEmpty(modules) && this.isEmpty(externals)) {
            return;
        }
        if (this.isEmpty(externals) && !this.isEmpty(modules)) {
            throw new IllegalArgumentException("No externals detected but " + modules.size() + " modules were detected");
        }
        if (!this.isEmpty(externals) && this.isEmpty(modules)) {
            throw new IllegalArgumentException(externals.size() + " externals were detected but no modules were detected");
        }
        if (externals.size() != modules.size()) {
            throw new IllegalArgumentException("Mismatch. " + externals.size() + " externals were detected. " + modules.size() + " modules were detected");
        }
        Collections.sort(modules);
        Collections.sort(externals);
        for (int i = 0; i < modules.size(); ++i) {
            String module2;
            String module1 = (String)modules.get(i);
            if (module1.equals(module2 = externals.get(i).getPath())) continue;
            throw new IllegalArgumentException("Mismatch. " + module1 + " <> " + module2);
        }
    }

    public void validate(List<SVNExternal> externals, List<Mapping> mappings) {
        if (this.isEmpty(externals) && this.isEmpty(mappings)) {
            return;
        }
        if (this.isEmpty(externals) && !this.isEmpty(mappings)) {
            throw new IllegalArgumentException("No externals detected but " + mappings.size() + " mappings were supplied");
        }
        if (!this.isEmpty(externals) && this.isEmpty(mappings)) {
            throw new IllegalArgumentException(externals.size() + " externals were detected but no mappings were supplied");
        }
        if (externals.size() != mappings.size()) {
            throw new IllegalArgumentException("Mismatch. " + externals.size() + " externals were detected. " + mappings.size() + " mappings were supplied");
        }
        for (SVNExternal external : externals) {
            File workingCopy = external.getWorkingCopyPath();
            if (workingCopy.exists()) continue;
            throw new IllegalArgumentException(workingCopy.getAbsolutePath() + " does not exist");
        }
    }

    public void validate(MavenProject project, List<Mapping> mappings) {
        this.validate(project.getProperties(), mappings);
        this.validateModules(project.getModules(), mappings);
    }

    public void validateModules(List<String> modules, List<Mapping> mappings) {
        Collections.sort(mappings);
        Collections.sort(modules);
        if (this.isEmpty(modules) && this.isEmpty(mappings)) {
            return;
        }
        if (this.isEmpty(modules) && !this.isEmpty(mappings)) {
            throw new IllegalArgumentException("No modules detected but " + mappings.size() + " mappings were supplied");
        }
        if (!this.isEmpty(modules) && this.isEmpty(mappings)) {
            throw new IllegalArgumentException(modules.size() + " modules were detected but no mappings were supplied");
        }
        if (modules.size() != mappings.size()) {
            throw new IllegalArgumentException("Mismatch. " + modules.size() + " modules were detected. " + mappings.size() + " mappings were supplied");
        }
        for (int i = 0; i < modules.size(); ++i) {
            String module2;
            String module1 = modules.get(i);
            if (module1.equals(module2 = mappings.get(i).getModule())) continue;
            throw new IllegalArgumentException("Mismatch. " + module1 + " <> " + module2);
        }
    }

    public void validate(Properties properties, List<Mapping> mappings) {
        if (this.isEmpty(mappings)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int missingCount = 0;
        for (Mapping mapping : mappings) {
            String key = mapping.getVersionProperty();
            String value = properties.getProperty(key);
            if (!StringUtils.isBlank((String)value)) continue;
            if (missingCount++ != 0) {
                sb.append(", ");
            }
            sb.append(key);
        }
        if (missingCount != 0) {
            throw new IllegalArgumentException("Missing values for [" + sb.toString() + "]");
        }
    }

    public String trimSnapshot(String version) {
        if (version.toUpperCase().endsWith("-SNAPSHOT")) {
            int length = MAVEN_SNAPSHOT_TOKEN.length() + 1;
            return StringUtils.left((String)version, (int)(version.length() - length));
        }
        return version;
    }

    public boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    protected Version parseVersion(String s) {
        boolean snapshot = s.toUpperCase().endsWith("-SNAPSHOT");
        Version version = new Version();
        version.setSnapshot(snapshot);
        String[] tokens = StringUtils.split((String)s, (String)".-");
        if (tokens.length > 0) {
            version.setMajor(tokens[0]);
        }
        if (tokens.length > 1) {
            version.setMinor(tokens[1]);
        }
        if (tokens.length > 2) {
            version.setIncremental(tokens[2]);
        }
        String qualifier = this.getQualifier(tokens);
        version.setQualifier(qualifier);
        return version;
    }

    protected String getQualifier(String[] tokens) {
        if (tokens.length <= 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i < tokens.length && !tokens[i].toUpperCase().equals(MAVEN_SNAPSHOT_TOKEN); ++i) {
            if (i != 3) {
                sb.append(QUALIFIER_DELIMETER);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public void write(File file, String data) {
        try {
            FileUtils.write((File)file, (CharSequence)data);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void deleteDirectory(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String read(File file) {
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

