/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.dao.NotificationMessegeDeliveryDao;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class NotificationMessageDeliveryServiceImpl
implements NotificationMessageDeliveryService {
    private static Logger LOG = Logger.getLogger(NotificationMessageDeliveryServiceImpl.class);
    private DataObjectService dataObjectService;
    private NotificationMessegeDeliveryDao ntdDao;

    public NotificationMessageDeliveryServiceImpl(DataObjectService dataObjectService, NotificationMessegeDeliveryDao ntdDao) {
        this.dataObjectService = dataObjectService;
        this.ntdDao = ntdDao;
    }

    @Override
    public NotificationMessageDelivery getNotificationMessageDelivery(Long id) {
        return (NotificationMessageDelivery)this.dataObjectService.find(NotificationMessageDelivery.class, (Object)id);
    }

    @Override
    public NotificationMessageDelivery getNotificationMessageDeliveryByDelivererId(String id) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"deliverySystemId", (Object)id)});
        List results = this.dataObjectService.findMatching(NotificationMessageDelivery.class, criteria.build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new RuntimeException("More than one message delivery found with the following delivery system id: " + id);
        }
        return (NotificationMessageDelivery)results.iterator().next();
    }

    @Override
    public Collection<NotificationMessageDelivery> getNotificationMessageDeliveries() {
        return this.dataObjectService.findMatching(NotificationMessageDelivery.class, QueryByCriteria.Builder.create().build()).getResults();
    }

    @Override
    public Collection<NotificationMessageDelivery> getNotificationMessageDeliveries(NotificationBo notification, String userRecipientId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"notification.id", (Object)notification.getId()), PredicateFactory.equal((String)"userRecipientId", (Object)userRecipientId)});
        return this.dataObjectService.findMatching(NotificationMessageDelivery.class, criteria.build()).getResults();
    }

    @Override
    public Collection<NotificationMessageDelivery> takeMessageDeliveriesForDispatch() {
        Collection messageDeliveries = this.ntdDao.getUndeliveredMessageDelivers(this.dataObjectService);
        ArrayList<NotificationMessageDelivery> savedMsgDel = new ArrayList<NotificationMessageDelivery>();
        LOG.debug((Object)("Retrieved " + messageDeliveries.size() + " available message deliveries: " + System.currentTimeMillis()));
        for (NotificationMessageDelivery delivery : messageDeliveries) {
            delivery.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
            savedMsgDel.add((NotificationMessageDelivery)this.dataObjectService.save((Object)delivery, new PersistenceOption[0]));
        }
        return savedMsgDel;
    }

    @Override
    public Collection<NotificationMessageDelivery> takeMessageDeliveriesForAutoRemoval() {
        Collection<NotificationMessageDelivery> messageDeliveries = this.ntdDao.getMessageDeliveriesForAutoRemoval(new Timestamp(System.currentTimeMillis()), this.dataObjectService);
        ArrayList<NotificationMessageDelivery> savedMsgDel = new ArrayList<NotificationMessageDelivery>();
        for (NotificationMessageDelivery d : messageDeliveries) {
            d.setLockedDateValue(new Timestamp(System.currentTimeMillis()));
            savedMsgDel.add((NotificationMessageDelivery)this.dataObjectService.save((Object)d, new PersistenceOption[0]));
        }
        return savedMsgDel;
    }

    @Override
    public void unlockMessageDelivery(NotificationMessageDelivery messageDelivery) {
        NotificationMessageDelivery d = (NotificationMessageDelivery)this.dataObjectService.find(NotificationMessageDelivery.class, (Object)messageDelivery.getId());
        if (d == null) {
            throw new RuntimeException("NotificationMessageDelivery #" + messageDelivery.getId() + " not found to unlock");
        }
        d.setLockedDateValue(null);
        this.dataObjectService.save((Object)d, new PersistenceOption[0]);
    }
}

