/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;

public class ConfiguredNamespaceContext
implements NamespaceContext {
    private static final Logger LOG = Logger.getLogger(ConfiguredNamespaceContext.class);
    private Map<String, String> prefixToNamespace = new HashMap<String, String>();
    private Map<String, HashSet<String>> namespaceToPrefix = new HashMap<String, HashSet<String>>();

    public ConfiguredNamespaceContext(Map<String, String> prefixToNamespace) {
        this.prefixToNamespace = prefixToNamespace;
        for (Map.Entry<String, String> entry : prefixToNamespace.entrySet()) {
            String namespace = entry.getValue();
            String prefix = entry.getKey();
            HashSet<String> prefixes = this.namespaceToPrefix.get(namespace);
            if (prefixes == null) {
                prefixes = new HashSet(4);
                this.namespaceToPrefix.put(namespace, prefixes);
            }
            prefixes.add(prefix);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        return this.prefixToNamespace.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        Iterator<String> prefixes = this.getPrefixes(namespaceURI);
        if (prefixes != null) {
            return prefixes.next();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        HashSet<String> prefixes = this.namespaceToPrefix.get(namespaceURI);
        if (prefixes != null && prefixes.size() > 0) {
            return prefixes.iterator();
        }
        return null;
    }
}

