/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;

public class ContentTypeResourceResolver {
    protected static final String CONTENT_TYPE_PREFIX = "resource:notification/ContentType";
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private NotificationContentTypeService notificationContentTypeService;

    public ContentTypeResourceResolver(NotificationContentTypeService notificationContentTypeService) {
        this.notificationContentTypeService = notificationContentTypeService;
    }

    public NotificationContentTypeBo resolveContentType(String id) {
        if (!id.startsWith(CONTENT_TYPE_PREFIX)) {
            return null;
        }
        String contentType = id.substring(CONTENT_TYPE_PREFIX.length());
        NotificationContentTypeBo notificationContentType = this.notificationContentTypeService.getNotificationContentType(contentType);
        if (contentType == null) {
            this.LOG.warn((Object)("Content type '" + contentType + "' not found in notification database"));
            return null;
        }
        this.LOG.info((Object)("Resolved '" + id + "' to notification content type: " + (Object)((Object)notificationContentType)));
        return notificationContentType;
    }
}

