/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.dao.impl;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.kuali.rice.kew.actionlist.dao.ActionListDAO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class ActionListDAOJpaImpl
implements ActionListDAO {
    protected EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public int getCount(String principalId) {
        TypedQuery query = this.entityManager.createNamedQuery("ActionItem.DistinctDocumentsForPrincipalId", Long.class);
        query.setParameter("principalId", (Object)principalId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(String principalId) {
        TypedQuery query = this.entityManager.createNamedQuery("ActionItem.GetMaxDateAndCountForPrincipalId", new Object[0].getClass());
        query.setParameter("principalId", (Object)principalId);
        return Arrays.asList((Object[])query.getSingleResult());
    }

    @Override
    public DocumentRouteHeaderValue getMinimalRouteHeader(String documentId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph("DocumentRouteHeaderValue.ActionListAttributesOnly");
        TypedQuery query = this.entityManager.createQuery("SELECT rh FROM DocumentRouteHeaderValue rh WHERE rh.documentId = :documentId", DocumentRouteHeaderValue.class);
        query.setHint("javax.persistence.fetchgraph", (Object)entityGraph);
        query.setParameter("documentId", (Object)documentId);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return (DocumentRouteHeaderValue)result.get(0);
    }
}

