/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.util.WebFriendlyRecipient;

public final class ActionListUtil {
    private ActionListUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static List<WebFriendlyRecipient> getWebFriendlyRecipients(Collection<Recipient> recipients) {
        ArrayList<WebFriendlyRecipient> newRecipients = new ArrayList<WebFriendlyRecipient>(recipients.size());
        for (Recipient recipient : recipients) {
            newRecipients.add(new WebFriendlyRecipient(recipient));
        }
        ArrayList<WebFriendlyRecipient> recipientList = new ArrayList<WebFriendlyRecipient>(newRecipients);
        Collections.sort(recipientList, new Comparator<WebFriendlyRecipient>(){
            Comparator<String> comp = new ComparableComparator();

            @Override
            public int compare(WebFriendlyRecipient o1, WebFriendlyRecipient o2) {
                return this.comp.compare(o1.getDisplayName().trim().toLowerCase(), o2.getDisplayName().trim().toLowerCase());
            }
        });
        return recipientList;
    }
}

