/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actions.SuperUserActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.BlanketApproveEngine;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class SuperUserNodeApproveEvent
extends SuperUserActionTakenEvent {
    private static final Logger LOG = Logger.getLogger(SuperUserNodeApproveEvent.class);
    private String nodeName;

    public SuperUserNodeApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("r", "SU_ROUTE_LEVEL_APPROVE", routeHeader, principal);
    }

    public SuperUserNodeApproveEvent(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessor, String nodeName) {
        super("r", "SU_ROUTE_LEVEL_APPROVE", routeHeader, principal, annotation, runPostProcessor);
        this.nodeName = nodeName;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        if (StringUtils.isEmpty((String)this.nodeName)) {
            throw new InvalidActionTakenException("No approval node name set");
        }
        DocumentType docType = this.getRouteHeader().getDocumentType();
        String errorMessage = super.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            LOG.info((Object)"User not authorized");
            ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
            errors.add(new WorkflowServiceErrorImpl(errorMessage, SuperUserActionTakenEvent.AUTHORIZATION));
            throw new WorkflowServiceErrorException(errorMessage, errors);
        }
        ActionTakenValue actionTaken = this.saveActionTaken();
        this.notifyActionTaken(actionTaken);
        if (this.getRouteHeader().isInException()) {
            LOG.debug((Object)"Moving document back to Enroute from Exception");
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.getRouteHeader().markDocumentEnroute();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(routeHeaderValue);
        }
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.BLANKET_APPROVAL, Collections.singleton(this.nodeName), actionTaken, docType.getSuperUserApproveNotificationPolicy().getPolicyValue(), this.isRunPostProcessorLogic());
        try {
            BlanketApproveEngine blanketApproveEngine = (BlanketApproveEngine)KEWServiceLocator.getWorkflowEngineFactory().newEngine(config);
            blanketApproveEngine.process(this.getRouteHeader().getDocumentId(), null);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WorkflowRuntimeException(e.toString(), (Throwable)e);
        }
    }

    @Override
    protected void markDocument() throws WorkflowException {
    }
}

