/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.framework.config.module.WebModuleConfiguration;
import org.kuali.rice.kew.lifecycle.StandaloneLifeCycle;
import org.kuali.rice.kew.plugin.PluginRegistry;
import org.kuali.rice.kew.plugin.PluginRegistryFactory;

public class KEWConfigurer
extends ModuleConfigurer {
    public static final String KEW_DATASOURCE_OBJ = "org.kuali.workflow.datasource";
    private DataSource dataSource;

    public KEWConfigurer() {
        super("kew");
        this.setValidRunModes(Arrays.asList(RunMode.THIN, RunMode.REMOTE, RunMode.EMBEDDED, RunMode.LOCAL));
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info((Object)("KEWConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode()));
        ArrayList<String> springFileLocations = new ArrayList<String>();
        if (RunMode.THIN == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KewThinSpringBeans.xml");
        } else if (RunMode.REMOTE == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KewRemoteSpringBeans.xml");
        } else if (RunMode.EMBEDDED == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KewEmbeddedSpringBeans.xml");
        } else if (RunMode.LOCAL == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KewLocalSpringBeans.xml");
        }
        return springFileLocations;
    }

    public List<Lifecycle> loadLifecycles() throws Exception {
        LinkedList<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
        if (this.getRunMode().equals((Object)RunMode.LOCAL)) {
            lifecycles.add(this.createStandaloneLifeCycle());
        }
        return lifecycles;
    }

    private Lifecycle createStandaloneLifeCycle() throws Exception {
        return new StandaloneLifeCycle();
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
    }

    private void configureDataSource() {
        if (this.getDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject(KEW_DATASOURCE_OBJ, (Object)this.getDataSource());
        }
    }

    public Collection<ResourceLoader> getResourceLoadersToRegister() throws Exception {
        ArrayList<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
        String pluginRegistryEnabled = ConfigContext.getCurrentContextConfig().getProperty("plugin.registry.enabled");
        if (!StringUtils.isBlank((String)pluginRegistryEnabled) && Boolean.valueOf(pluginRegistryEnabled).booleanValue()) {
            PluginRegistry registry = new PluginRegistryFactory().createPluginRegistry();
            registry.start();
            resourceLoaders.add(registry);
        }
        return resourceLoaders;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean hasWebInterface() {
        return true;
    }

    protected WebModuleConfiguration loadWebModule() {
        WebModuleConfiguration configuration = super.loadWebModule();
        configuration.setWebSpringFiles(Arrays.asList(this.getDefaultConfigPackagePath() + "KewWebSpringBeans.xml"));
        return configuration;
    }
}

