/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaProcessor;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.impl.document.ApplicationDocumentStatusUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

public class DocumentSearchCriteriaProcessorKEWAdapter
implements DocumentSearchCriteriaProcessor {
    public static final String SUPERUSER_SEARCH_FIELD = "superUserSearch";
    public static final String CLEARSAVED_SEARCH_FIELD = "resetSavedSearch";
    private static final String DOCUMENT_ATTRIBUTE_FIELD_MARKER = "DOCUMENT_ATTRIBUTE_FIELD_MARKER";
    private static final String APPLICATION_DOCUMENT_STATUS = "applicationDocumentStatus";
    private static final String DATE_APP_DOC_STATUS_CHANGED_FROM = "rangeLowerBoundKeyPrefix_dateApplicationDocumentStatusChanged";
    private static final String DATE_APP_DOC_STATUS_CHANGED = "dateApplicationDocumentStatusChanged";
    private static final String ROUTE_NODE_NAME = "routeNodeName";
    private static final String ROUTE_NODE_LOGIC = "routeNodeLogic";
    private static final String[] BASIC_FIELD_NAMES = new String[]{"documentTypeName", "initiatorPrincipalName", "documentId", "applicationDocumentStatus", "dateCreated", "DOCUMENT_ATTRIBUTE_FIELD_MARKER", "saveName"};
    private static final String[] ADVANCED_FIELD_NAMES = new String[]{"documentTypeName", "initiatorPrincipalName", "approverPrincipalName", "viewerPrincipalName", "groupViewerName", "groupViewerId", "documentId", "applicationDocumentId", "statusCode", "applicationDocumentStatus", "dateApplicationDocumentStatusChanged", "routeNodeName", "routeNodeLogic", "dateCreated", "dateApproved", "dateLastModified", "dateFinalized", "title", "DOCUMENT_ATTRIBUTE_FIELD_MARKER", "saveName"};
    private static final Collection<String> DOCUMENTTYPE_DEPENDENT_FIELDS = Arrays.asList("DOCUMENT_ATTRIBUTE_FIELD_MARKER", "applicationDocumentStatus", "rangeLowerBoundKeyPrefix_dateApplicationDocumentStatusChanged", "dateApplicationDocumentStatusChanged", "routeNodeName", "routeNodeLogic");
    private static final Collection<String> DOCSTATUS_DEPENDENT_FIELDS = Arrays.asList("applicationDocumentStatus", "rangeLowerBoundKeyPrefix_dateApplicationDocumentStatusChanged", "dateApplicationDocumentStatusChanged");
    private static final Collection<String> ROUTE_NODE_DEPENDENT_FIELDS = Arrays.asList("routeNodeName", "routeNodeLogic");

    @Override
    public List<Row> getRows(DocumentType documentType, List<Row> defaultRows, boolean advancedSearch, boolean superUserSearch) {
        List<Row> rows = null;
        rows = advancedSearch ? this.loadRowsForAdvancedSearch(defaultRows, documentType) : this.loadRowsForBasicSearch(defaultRows, documentType);
        this.addHiddenFields(rows, advancedSearch, superUserSearch);
        return rows;
    }

    protected List<Row> loadRowsForAdvancedSearch(List<Row> defaultRows, DocumentType documentType) {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.loadRowsWithFields(rows, defaultRows, ADVANCED_FIELD_NAMES, documentType);
        return rows;
    }

    protected List<Row> loadRowsForBasicSearch(List<Row> defaultRows, DocumentType documentType) {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.loadRowsWithFields(rows, defaultRows, BASIC_FIELD_NAMES, documentType);
        return rows;
    }

    protected void loadRowsWithFields(List<Row> rowsToLoad, List<Row> defaultRows, String[] fieldNames, DocumentType documentType) {
        for (String fieldName : fieldNames) {
            if (DOCUMENTTYPE_DEPENDENT_FIELDS.contains(fieldName) && documentType == null || DOCSTATUS_DEPENDENT_FIELDS.contains(fieldName) && !documentType.isAppDocStatusInUse().booleanValue() || ROUTE_NODE_DEPENDENT_FIELDS.contains(fieldName) && this.getRouteNodesByDocumentType(documentType, false).size() == 0) continue;
            if (fieldName.equals(DOCUMENT_ATTRIBUTE_FIELD_MARKER)) {
                rowsToLoad.addAll(this.getDocumentAttributeRows(documentType));
                continue;
            }
            for (Row row : defaultRows) {
                boolean matched = false;
                for (Field field : row.getFields()) {
                    if (!field.getPropertyName().equals(fieldName) && !field.getPropertyName().endsWith("_" + fieldName)) continue;
                    matched = true;
                    if (APPLICATION_DOCUMENT_STATUS.equals(field.getPropertyName())) {
                        this.applyApplicationDocumentStatusCustomizations(field, documentType);
                        break;
                    }
                    if (!ROUTE_NODE_NAME.equals(field.getPropertyName())) continue;
                    this.applyRouteNodeNameCustomizations(field, documentType);
                }
                if (!matched) continue;
                rowsToLoad.add(row);
            }
        }
    }

    protected List<Row> getDocumentAttributeRows(DocumentType documentType) {
        List remotableAttributeFields;
        ArrayList documentAttributeRows = new ArrayList();
        DocumentSearchCriteriaConfiguration configuration = KEWServiceLocator.getDocumentSearchCustomizationMediator().getDocumentSearchCriteriaConfiguration(documentType);
        if (configuration != null && (remotableAttributeFields = configuration.getFlattenedSearchAttributeFields()) != null && !remotableAttributeFields.isEmpty()) {
            documentAttributeRows.addAll(FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields));
        }
        ArrayList<Row> fixedDocumentAttributeRows = new ArrayList<Row>();
        for (Row row : documentAttributeRows) {
            List fields = row.getFields();
            for (Field field : fields) {
                if (field.getMaxLength() == 0) {
                    field.setMaxLength(100);
                }
                field.setPropertyName("documentAttribute." + field.getPropertyName());
                if (StringUtils.isNotBlank((String)field.getLookupParameters())) {
                    field.setLookupParameters(this.prefixLookupParameters(field.getLookupParameters()));
                }
                if (!StringUtils.isNotBlank((String)field.getFieldConversions())) continue;
                field.setFieldConversions(this.prefixFieldConversions(field.getFieldConversions()));
            }
            fixedDocumentAttributeRows.add(row);
        }
        return fixedDocumentAttributeRows;
    }

    protected void applyApplicationDocumentStatusCustomizations(Field field, DocumentType documentType) {
        if (documentType.getValidApplicationStatuses() == null || documentType.getValidApplicationStatuses().size() == 0) {
            field.setFieldType("text");
        } else {
            field.setFieldType("multiselect");
            ArrayList<ConcreteKeyValue> validValues = new ArrayList<ConcreteKeyValue>();
            LinkedHashSet<String> statusesToDisplay = new LinkedHashSet<String>();
            for (ApplicationDocumentStatus status : documentType.getValidApplicationStatuses()) {
                statusesToDisplay.add(status.getStatusName());
            }
            LinkedHashMap<String, List<String>> appDocStatusCategories = ApplicationDocumentStatusUtils.getApplicationDocumentStatusCategories(documentType.getName());
            if (!appDocStatusCategories.isEmpty()) {
                for (Map.Entry entry : appDocStatusCategories.entrySet()) {
                    boolean addedCategoryHeading = false;
                    for (String member : (List)entry.getValue()) {
                        if (!statusesToDisplay.remove(member)) continue;
                        if (!addedCategoryHeading) {
                            addedCategoryHeading = true;
                            validValues.add(new ConcreteKeyValue("category:" + (String)entry.getKey(), (String)entry.getKey()));
                        }
                        validValues.add(new ConcreteKeyValue(member, "- " + member));
                    }
                }
            }
            for (String string : statusesToDisplay) {
                validValues.add(new ConcreteKeyValue(string, string));
            }
            field.setFieldValidValues(validValues);
            if (validValues.size() > 5) {
                field.setSize(5);
            } else {
                field.setSize(validValues.size());
            }
        }
    }

    protected List<RouteNode> getRouteNodesByDocumentType(DocumentType documentType, boolean includeBlankNodes) {
        List<RouteNode> nodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, true);
        if (nodes.size() > 0 && !includeBlankNodes) {
            ArrayList<RouteNode> namedNodes = new ArrayList<RouteNode>();
            for (RouteNode node : nodes) {
                if (!StringUtils.isNotBlank((String)node.getName())) continue;
                namedNodes.add(node);
            }
            return namedNodes;
        }
        return nodes;
    }

    protected void applyRouteNodeNameCustomizations(Field field, DocumentType documentType) {
        List<RouteNode> nodes = this.getRouteNodesByDocumentType(documentType, false);
        ArrayList<ConcreteKeyValue> values = new ArrayList<ConcreteKeyValue>(nodes.size());
        for (RouteNode node : nodes) {
            values.add(new ConcreteKeyValue(node.getName(), node.getName()));
        }
        field.setFieldValidValues(values);
    }

    protected void addHiddenFields(List<Row> rows, boolean advancedSearch, boolean superUserSearch) {
        Row hiddenRow = new Row();
        hiddenRow.setHidden(true);
        Field detailedField = new Field();
        detailedField.setPropertyName("isAdvancedSearch");
        detailedField.setPropertyValue(advancedSearch ? "YES" : "NO");
        detailedField.setFieldType("hidden");
        Field superUserSearchField = new Field();
        superUserSearchField.setPropertyName(SUPERUSER_SEARCH_FIELD);
        superUserSearchField.setPropertyValue(superUserSearch ? "YES" : "NO");
        superUserSearchField.setFieldType("hidden");
        Field clearSavedSearchField = new Field();
        clearSavedSearchField.setPropertyName(CLEARSAVED_SEARCH_FIELD);
        clearSavedSearchField.setPropertyValue(superUserSearch ? "YES" : "NO");
        clearSavedSearchField.setFieldType("hidden");
        ArrayList<Field> hiddenFields = new ArrayList<Field>();
        hiddenFields.add(detailedField);
        hiddenFields.add(superUserSearchField);
        hiddenFields.add(clearSavedSearchField);
        hiddenRow.setFields(hiddenFields);
        rows.add(hiddenRow);
    }

    private String prefixLookupParameters(String lookupParameters) {
        StringBuilder newLookupParameters = new StringBuilder("");
        String[] conversions = StringUtils.split((String)lookupParameters, (String)",");
        for (int m = 0; m < conversions.length; ++m) {
            String conversion = conversions[m];
            String[] conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
            String conversionFrom = conversionPair[0];
            String conversionTo = conversionPair[1];
            conversionFrom = "documentAttribute." + conversionFrom;
            newLookupParameters.append(conversionFrom).append(":").append(conversionTo);
            if (m >= conversions.length) continue;
            newLookupParameters.append(",");
        }
        return newLookupParameters.toString();
    }

    private String prefixFieldConversions(String fieldConversions) {
        StringBuilder newFieldConversions = new StringBuilder("");
        String[] conversions = StringUtils.split((String)fieldConversions, (String)",");
        for (int l = 0; l < conversions.length; ++l) {
            String conversion = conversions[l];
            String[] conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
            String conversionFrom = conversionPair[0];
            String conversionTo = conversionPair[1];
            conversionTo = "documentAttribute." + conversionTo;
            newFieldConversions.append(conversionFrom).append(":").append(conversionTo);
            if (l >= conversions.length) continue;
            newFieldConversions.append(",");
        }
        return newFieldConversions.toString();
    }
}

