/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.var.schemes;

import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.service.BranchService;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.kuali.rice.kew.service.KEWServiceLocator;

public final class VariableScheme
implements PropertyScheme {
    private static final Logger LOG = Logger.getLogger(VariableScheme.class);

    @Override
    public String getName() {
        return "variable";
    }

    @Override
    public String getShortName() {
        return "var";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        LOG.debug((Object)("getting variable: " + property.locator));
        BranchService branchService = KEWServiceLocator.getBranchService();
        String value = branchService.getScopedVariableValue(context.getNodeInstance().getBranch(), "var::" + property.locator);
        LOG.debug((Object)("variable '" + property.locator + "': " + value));
        return value;
    }

    public String toString() {
        return "[VariableScheme]";
    }
}

