/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.api.search.SearchExpressionUtils;
import org.kuali.rice.core.api.uif.AttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.impl.document.ApplicationDocumentStatusUtils;
import org.kuali.rice.kew.impl.document.search.DocumentSearchCriteriaTranslator;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class DocumentSearchCriteriaTranslatorImpl
implements DocumentSearchCriteriaTranslator {
    private static final Logger LOG = Logger.getLogger(DocumentSearchCriteriaTranslatorImpl.class);
    private static final String DOCUMENT_STATUSES = "documentStatuses";
    private static final String ROUTE_NODE_LOOKUP_LOGIC = "routeNodeLookupLogic";
    private static final String[] DIRECT_TRANSLATE_FIELD_NAMES = new String[]{"documentId", "applicationDocumentId", "applicationDocumentStatus", "initiatorPrincipalName", "initiatorPrincipalId", "viewerPrincipalName", "viewerPrincipalId", "groupViewerId", "approverPrincipalName", "approverPrincipalId", "routeNodeName", "documentTypeName", "saveName", "title", "isAdvancedSearch"};
    private static final Set<String> DIRECT_TRANSLATE_FIELD_NAMES_SET = new HashSet<String>(Arrays.asList(DIRECT_TRANSLATE_FIELD_NAMES));
    private static final String[] DATE_RANGE_TRANSLATE_FIELD_NAMES = new String[]{"dateCreated", "dateLastModified", "dateApproved", "dateFinalized"};
    private static final Set<String> DATE_RANGE_TRANSLATE_FIELD_NAMES_SET = new HashSet<String>(Arrays.asList(DATE_RANGE_TRANSLATE_FIELD_NAMES));

    @Override
    public DocumentSearchCriteria translateFieldsToCriteria(Map<String, String> fieldValues) {
        String documentStatusesValue;
        String routeNodeLookupLogic;
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        ArrayList<String> documentAttributeFields = new ArrayList<String>();
        for (Map.Entry<String, String> field : fieldValues.entrySet()) {
            try {
                if (!StringUtils.isNotBlank((String)field.getValue())) continue;
                if (DIRECT_TRANSLATE_FIELD_NAMES_SET.contains(field.getKey())) {
                    PropertyUtils.setNestedProperty((Object)criteria, (String)field.getKey(), (Object)field.getValue());
                    continue;
                }
                if (DATE_RANGE_TRANSLATE_FIELD_NAMES_SET.contains(field.getKey())) {
                    this.applyDateRangeField(criteria, field.getKey(), field.getValue());
                    continue;
                }
                if (!field.getKey().startsWith("documentAttribute.")) continue;
                documentAttributeFields.add(field.getKey());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set document search criteria field: " + field.getKey(), e);
            }
        }
        if (!documentAttributeFields.isEmpty()) {
            this.translateDocumentAttributeFieldsToCriteria(fieldValues, documentAttributeFields, criteria);
        }
        if (StringUtils.isNotBlank((String)(routeNodeLookupLogic = fieldValues.get(ROUTE_NODE_LOOKUP_LOGIC)))) {
            criteria.setRouteNodeLookupLogic(RouteNodeLookupLogic.valueOf((String)routeNodeLookupLogic));
        }
        if (StringUtils.isNotBlank((String)(documentStatusesValue = fieldValues.get("statusCode")))) {
            String[] documentStatuses;
            for (String documentStatus : documentStatuses = documentStatusesValue.split(",")) {
                if (documentStatus.startsWith("category:")) {
                    String categoryCode = StringUtils.remove((String)documentStatus, (String)"category:");
                    criteria.getDocumentStatusCategories().add(DocumentStatusCategory.fromCode((String)categoryCode));
                    continue;
                }
                criteria.getDocumentStatuses().add(DocumentStatus.fromCode((String)documentStatus));
            }
        }
        LinkedHashMap<String, List<String>> applicationDocumentStatusGroupings = ApplicationDocumentStatusUtils.getApplicationDocumentStatusCategories(criteria.getDocumentTypeName());
        String applicationDocumentStatusesValue = fieldValues.get("applicationDocumentStatus");
        if (StringUtils.isNotBlank((String)applicationDocumentStatusesValue)) {
            String[] applicationDocumentStatuses;
            for (String applicationDocumentStatus : applicationDocumentStatuses = applicationDocumentStatusesValue.split(",")) {
                if (applicationDocumentStatus.startsWith("category:")) {
                    String categoryCode = StringUtils.remove((String)applicationDocumentStatus, (String)"category:");
                    if (!applicationDocumentStatusGroupings.containsKey(categoryCode)) continue;
                    criteria.getApplicationDocumentStatuses().addAll((Collection)applicationDocumentStatusGroupings.get(categoryCode));
                    continue;
                }
                criteria.getApplicationDocumentStatuses().add(applicationDocumentStatus);
            }
        }
        criteria.setApplicationDocumentStatus(null);
        return criteria.build();
    }

    @Override
    public Map<String, String[]> translateCriteriaToFields(DocumentSearchCriteria criteria) {
        RouteNodeLookupLogic lookupLogic;
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String property : DIRECT_TRANSLATE_FIELD_NAMES) {
            DocumentSearchCriteriaTranslatorImpl.convertCriteriaPropertyToField(criteria, property, values);
        }
        for (String property : DATE_RANGE_TRANSLATE_FIELD_NAMES) {
            DocumentSearchCriteriaTranslatorImpl.convertCriteriaRangeField(criteria, property, values);
        }
        Map docAttrValues = criteria.getDocumentAttributeValues();
        if (!docAttrValues.isEmpty()) {
            Map<String, AttributeLookupSettings> attributeLookupSettingsMap = this.getAttributeLookupSettings((DocumentSearchCriteriaContract)criteria);
            for (Map.Entry entry : docAttrValues.entrySet()) {
                AttributeLookupSettings lookupSettings = attributeLookupSettingsMap.get(entry.getKey());
                if (lookupSettings != null && lookupSettings.isRanged()) {
                    DocumentSearchCriteriaTranslatorImpl.convertAttributeRangeField((String)entry.getKey(), (List)entry.getValue(), values);
                    continue;
                }
                values.put("documentAttribute." + (String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
            }
        }
        if ((lookupLogic = criteria.getRouteNodeLookupLogic()) != null) {
            values.put(ROUTE_NODE_LOOKUP_LOGIC, new String[]{lookupLogic.name()});
        }
        ArrayList<String> statuses = new ArrayList<String>();
        for (DocumentStatus status : criteria.getDocumentStatuses()) {
            statuses.add(status.getCode());
        }
        for (DocumentStatusCategory category : criteria.getDocumentStatusCategories()) {
            statuses.add("category:" + category.getCode());
        }
        values.put("statusCode", statuses.toArray(new String[0]));
        return values;
    }

    protected static void convertAttributeRangeField(String attrKey, List<String> attrValues, Map<String, String[]> values) {
        String upper;
        String lower;
        Range range;
        String value = "";
        if (attrValues != null && !attrValues.isEmpty()) {
            value = attrValues.get(0);
            if (attrValues.size() > 1) {
                LOG.warn((Object)("Encountered multi-valued ranged document search attribute '" + attrKey + "': " + attrValues));
            }
        }
        if ((range = SearchExpressionUtils.parseRange((String)value)) != null) {
            lower = range.getLowerBoundValue();
            upper = range.getUpperBoundValue();
        } else {
            lower = null;
            upper = value;
        }
        values.put("documentAttribute.rangeLowerBoundKeyPrefix_" + attrKey, new String[]{lower});
        values.put("documentAttribute." + attrKey, new String[]{upper});
    }

    protected static void convertCriteriaRangeField(DocumentSearchCriteria criteria, String property, Map<String, String[]> values) {
        DocumentSearchCriteriaTranslatorImpl.convertCriteriaPropertyToField(criteria, property + "From", "rangeLowerBoundKeyPrefix_" + property, values);
        DocumentSearchCriteriaTranslatorImpl.convertCriteriaPropertyToField(criteria, property + "To", property, values);
    }

    protected static void convertCriteriaPropertyToField(DocumentSearchCriteria criteria, String property, Map<String, String[]> values) {
        DocumentSearchCriteriaTranslatorImpl.convertCriteriaPropertyToField(criteria, property, property, values);
    }

    protected static void convertCriteriaPropertyToField(DocumentSearchCriteria criteria, String property, String fieldName, Map<String, String[]> values) {
        try {
            Object val = PropertyUtils.getProperty((Object)criteria, (String)property);
            if (val != null) {
                values.put(fieldName, new String[]{ObjectUtils.toString((Object)val)});
            }
        }
        catch (NoSuchMethodException nsme) {
            LOG.error((Object)("Error reading property '" + property + "' of criteria"), (Throwable)nsme);
        }
        catch (InvocationTargetException ite) {
            LOG.error((Object)("Error reading property '" + property + "' of criteria"), (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            LOG.error((Object)("Error reading property '" + property + "' of criteria"), (Throwable)iae);
        }
    }

    protected void applyDateRangeField(DocumentSearchCriteria.Builder criteria, String fieldName, String fieldValue) throws Exception {
        DateTime lowerDateTime = DocumentSearchInternalUtils.getLowerDateTimeBound(fieldValue);
        DateTime upperDateTime = DocumentSearchInternalUtils.getUpperDateTimeBound(fieldValue);
        if (lowerDateTime != null) {
            PropertyUtils.setNestedProperty((Object)criteria, (String)(fieldName + "From"), (Object)lowerDateTime);
        }
        if (upperDateTime != null) {
            PropertyUtils.setNestedProperty((Object)criteria, (String)(fieldName + "To"), (Object)upperDateTime);
        }
    }

    protected Map<String, AttributeLookupSettings> getAttributeLookupSettings(DocumentSearchCriteriaContract criteria) {
        String documentTypeName = criteria.getDocumentTypeName();
        HashMap<String, AttributeLookupSettings> attributeLookupSettingsMap = new HashMap<String, AttributeLookupSettings>();
        if (StringUtils.isNotEmpty((String)documentTypeName)) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByNameCaseInsensitive(documentTypeName);
            if (documentType != null) {
                DocumentSearchCriteriaConfiguration configuration = KEWServiceLocator.getDocumentSearchCustomizationMediator().getDocumentSearchCriteriaConfiguration(documentType);
                if (configuration != null) {
                    List remotableAttributeFields = configuration.getFlattenedSearchAttributeFields();
                    for (RemotableAttributeField raf : remotableAttributeFields) {
                        attributeLookupSettingsMap.put(raf.getName(), raf.getAttributeLookupSettings());
                    }
                }
            } else {
                LOG.error((Object)("Searching against unknown document type '" + documentTypeName + "'; searchable attribute ranges will not work."));
            }
        }
        return attributeLookupSettingsMap;
    }

    protected String translateRangePropertyToExpression(Map<String, String> fieldValues, String property, String prefix, AttributeLookupSettings settings) {
        String lowerBoundValue = fieldValues.get(prefix + "rangeLowerBoundKeyPrefix_" + property);
        String upperBoundValue = fieldValues.get(prefix + property);
        Range range = new Range();
        range.setLowerBoundInclusive(settings.isLowerBoundInclusive());
        range.setUpperBoundInclusive(settings.isUpperBoundInclusive());
        range.setLowerBoundValue(lowerBoundValue);
        range.setUpperBoundValue(upperBoundValue);
        String expr = range.toString();
        if (StringUtils.isEmpty((String)expr)) {
            expr = upperBoundValue;
        }
        return expr;
    }

    protected void translateDocumentAttributeFieldsToCriteria(Map<String, String> fieldValues, List<String> fields, DocumentSearchCriteria.Builder criteria) {
        Map<String, AttributeLookupSettings> attributeLookupSettingsMap = this.getAttributeLookupSettings((DocumentSearchCriteriaContract)criteria);
        for (String field : fields) {
            String documentAttributeName = field.substring("documentAttribute.".length());
            if (documentAttributeName.startsWith("rangeLowerBoundKeyPrefix_")) {
                String tempDocumentAttributeName = StringUtils.substringAfter((String)documentAttributeName, (String)"rangeLowerBoundKeyPrefix_");
                String tempField = fieldValues.get("documentAttribute." + tempDocumentAttributeName);
                if (!StringUtils.isEmpty((String)tempField)) continue;
                documentAttributeName = tempDocumentAttributeName;
            }
            String value = fieldValues.get(field);
            AttributeLookupSettings lookupSettings = attributeLookupSettingsMap.get(documentAttributeName);
            if (lookupSettings != null && lookupSettings.isRanged()) {
                value = this.translateRangePropertyToExpression(fieldValues, documentAttributeName, "documentAttribute.", lookupSettings);
            }
            this.applyDocumentAttribute(criteria, documentAttributeName, value);
        }
    }

    protected void applyDocumentAttribute(DocumentSearchCriteria.Builder criteria, String documentAttributeName, String attributeValue) {
        criteria.addDocumentAttributeValue(documentAttributeName, attributeValue);
    }
}

