/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.framework.persistence.jdbc.sql.Criteria;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SqlBuilder;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.QueryComponent;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.impl.document.search.DocumentSearchGenerator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.MessageMap;

public class DocumentSearchGeneratorImpl
implements DocumentSearchGenerator {
    private static final Logger LOG = Logger.getLogger(DocumentSearchGeneratorImpl.class);
    private static final String ROUTE_NODE_TABLE = "KREW_RTE_NODE_T";
    private static final String ROUTE_NODE_INST_TABLE = "KREW_RTE_NODE_INSTN_T";
    private static final String DATABASE_WILDCARD_CHARACTER_STRING = "%";
    private static final char DATABASE_WILDCARD_CHARACTER = "%".toCharArray()[0];
    private org.kuali.rice.kew.api.doctype.DocumentTypeService apiDocumentTypeService;
    private DatabasePlatform dbPlatform;
    private MessageMap messageMap;
    private SqlBuilder sqlBuilder = null;

    @Override
    public DocumentSearchCriteria clearSearch(DocumentSearchCriteria criteria) {
        return DocumentSearchCriteria.Builder.create().build();
    }

    public org.kuali.rice.kew.doctype.bo.DocumentType getValidDocumentType(String documentTypeFullName) {
        if (!StringUtils.isEmpty((String)documentTypeFullName)) {
            org.kuali.rice.kew.doctype.bo.DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByNameCaseInsensitive(documentTypeFullName);
            if (documentType == null) {
                throw new RuntimeException("No Valid Document Type Found for document type name '" + documentTypeFullName + "'");
            }
            return documentType;
        }
        return null;
    }

    @Override
    public List<RemotableAttributeError> validateSearchableAttributes(DocumentSearchCriteria.Builder criteria) {
        List<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        org.kuali.rice.kew.doctype.bo.DocumentType documentType = null;
        try {
            documentType = this.getValidDocumentType(criteria.getDocumentTypeName());
        }
        catch (RuntimeException re) {
            errors.add(RemotableAttributeError.Builder.create((String)"documentTypeName", (String[])new String[]{re.getMessage()}).build());
        }
        if (documentType != null) {
            errors = KEWServiceLocator.getDocumentSearchCustomizationMediator().validateLookupFieldParameters(documentType, criteria.build());
        } else {
            criteria.setDocumentAttributeValues(new HashMap());
        }
        return errors == null ? Collections.emptyList() : Collections.unmodifiableList(errors);
    }

    public QueryComponent getSearchableAttributeSql(Map<String, List<String>> documentAttributeValues, List<RemotableAttributeField> searchFields, String whereClausePredicatePrefix) {
        StringBuilder fromSql = new StringBuilder();
        StringBuilder whereSql = new StringBuilder();
        Criteria finalCriteria = null;
        int tableIndex = 1;
        SqlBuilder sqlBuilder = this.getSqlBuilder();
        Iterator<String> iterator = documentAttributeValues.keySet().iterator();
        while (iterator.hasNext()) {
            List<String> searchValues;
            String documentAttributeName;
            String documentAttributeNameForSQL = documentAttributeName = iterator.next();
            if (documentAttributeName.contains("documentAttribute.")) {
                documentAttributeNameForSQL = documentAttributeName.replaceFirst("documentAttribute.", "");
            }
            if (CollectionUtils.isEmpty(searchValues = documentAttributeValues.get(documentAttributeName)) || documentAttributeName.contains("{CheckboxPresentOnFormAnnotation}")) continue;
            String tableAlias = "EXT" + tableIndex;
            RemotableAttributeField searchField = this.getSearchFieldByName(documentAttributeName, searchFields);
            String tableName = DocumentSearchInternalUtils.getAttributeTableName(searchField);
            boolean caseSensitive = DocumentSearchInternalUtils.isLookupCaseSensitive(searchField);
            Criteria crit = null;
            Class<?> dataTypeClass = DocumentSearchInternalUtils.getDataTypeClass(searchField);
            if (searchValues.size() > 1) {
                crit = new Criteria(tableName, tableAlias);
                crit.setDbPlatform(sqlBuilder.getDbPlatform());
                crit.in("VAL", searchValues, dataTypeClass);
            } else {
                crit = sqlBuilder.createCriteria("VAL", searchValues.get(0), tableName, tableAlias, dataTypeClass, !caseSensitive);
            }
            sqlBuilder.addCriteria("KEY_CD", documentAttributeNameForSQL, String.class, false, false, crit);
            sqlBuilder.andCriteria("DOC_HDR_ID", tableAlias + ".DOC_HDR_ID", "KREW_DOC_HDR_T", "DOC_HDR", SqlBuilder.JoinType.class, false, false, crit);
            if (finalCriteria == null) {
                finalCriteria = crit;
            } else {
                sqlBuilder.andCriteria(finalCriteria, crit);
            }
            String whereClausePrefix = whereSql.length() == 0 ? whereClausePredicatePrefix : this.getGeneratedPredicatePrefix(whereSql.length());
            QueryComponent qc = this.generateSearchableAttributeSql(tableName, documentAttributeNameForSQL, whereClausePrefix, tableIndex);
            fromSql.append(qc.getFromSql());
            ++tableIndex;
        }
        if (finalCriteria == null) {
            return new QueryComponent("", "", "");
        }
        String whereClausePrefix = whereSql.length() == 0 ? whereClausePredicatePrefix : this.getGeneratedPredicatePrefix(whereSql.length());
        return new QueryComponent("", fromSql.toString(), whereClausePrefix + " " + finalCriteria.buildWhere());
    }

    private RemotableAttributeField getSearchFieldByName(String fieldName, List<RemotableAttributeField> searchFields) {
        for (RemotableAttributeField searchField : searchFields) {
            if (!searchField.getName().equals(fieldName) && !searchField.getName().equals("documentAttribute." + fieldName)) continue;
            return searchField;
        }
        throw new IllegalStateException("Failed to locate a RemotableAttributeField for fieldName=" + fieldName);
    }

    public QueryComponent generateSearchableAttributeSql(String tableName, String documentAttributeName, String whereSqlStarter, int tableIndex) {
        String tableIdentifier = "EXT" + tableIndex;
        QueryComponent joinSqlComponent = this.getSearchableAttributeJoinSql(tableName, tableIdentifier, whereSqlStarter, documentAttributeName);
        return new QueryComponent("", joinSqlComponent.getFromSql(), joinSqlComponent.getWhereSql());
    }

    public QueryComponent getSearchableAttributeJoinSql(String tableName, String tableIdentifier, String whereSqlStarter, String attributeTableKeyColumnName) {
        return new QueryComponent("", this.generateSearchableAttributeFromSql(tableName, tableIdentifier).toString(), this.generateSearchableAttributeWhereClauseJoin(whereSqlStarter, tableIdentifier, attributeTableKeyColumnName).toString());
    }

    public StringBuilder generateSearchableAttributeWhereClauseJoin(String whereSqlStarter, String tableIdentifier, String attributeTableKeyColumnName) {
        StringBuilder whereSql = new StringBuilder(this.constructWhereClauseElement(whereSqlStarter, "DOC_HDR.DOC_HDR_ID", "=", this.getDbPlatform().escapeString(tableIdentifier + ".DOC_HDR_ID"), null, null));
        whereSql.append((CharSequence)this.constructWhereClauseElement(" and ", tableIdentifier + ".KEY_CD", "=", this.getDbPlatform().escapeString(attributeTableKeyColumnName), "'", "'"));
        return whereSql;
    }

    public StringBuilder generateSearchableAttributeFromSql(String tableName, String tableIdentifier) {
        if (StringUtils.isBlank((String)tableName)) {
            throw new IllegalArgumentException("tableName was null or blank");
        }
        if (StringUtils.isBlank((String)tableIdentifier)) {
            throw new IllegalArgumentException("tableIdentifier was null or blank");
        }
        StringBuilder fromSql = new StringBuilder();
        fromSql.append(" ,").append(tableName).append(" ").append(this.getDbPlatform().escapeString(tableIdentifier)).append(" ");
        return fromSql;
    }

    public StringBuilder constructWhereClauseElement(String clauseStarter, String queryTableColumnName, String operand, String valueToSearch, String valuePrefix, String valueSuffix) {
        StringBuilder whereSql = new StringBuilder();
        valuePrefix = valuePrefix != null ? valuePrefix : "";
        valueSuffix = valueSuffix != null ? valueSuffix : "";
        whereSql.append(" " + clauseStarter + " ").append(this.getDbPlatform().escapeString(queryTableColumnName)).append(" " + operand + " ").append(valuePrefix).append(valueToSearch).append(valueSuffix).append(" ");
        return whereSql;
    }

    @Override
    public DocumentSearchResults.Builder processResultSet(DocumentSearchCriteria criteria, boolean criteriaModified, Statement searchAttributeStatement, ResultSet resultSet, int maxResultCap, int fetchLimit) throws SQLException {
        DocumentSearchCriteria.Builder criteriaBuilder = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)criteria);
        DocumentSearchResults.Builder results = DocumentSearchResults.Builder.create((DocumentSearchCriteria.Builder)criteriaBuilder);
        results.setCriteriaModified(criteriaModified);
        ArrayList<DocumentSearchResult.Builder> resultList = new ArrayList<DocumentSearchResult.Builder>();
        results.setSearchResults(resultList);
        HashMap<String, DocumentSearchResult.Builder> resultMap = new HashMap<String, DocumentSearchResult.Builder>();
        int startAt = criteria.getStartAtIndex() == null ? 0 : criteria.getStartAtIndex();
        boolean resultSetHasNext = resultSet.next();
        PerformanceLogger perfLog = new PerformanceLogger();
        for (int iteration = 0; resultSetHasNext && resultMap.size() < maxResultCap && iteration < fetchLimit && startAt >= 0; ++iteration) {
            if (iteration >= startAt) {
                DocumentSearchResult.Builder resultBuilder = this.processRow(criteria, searchAttributeStatement, resultSet);
                String documentId = resultBuilder.getDocument().getDocumentId();
                if (!resultMap.containsKey(documentId)) {
                    resultList.add(resultBuilder);
                    resultMap.put(documentId, resultBuilder);
                } else {
                    DocumentSearchResult.Builder previousEntry = (DocumentSearchResult.Builder)resultMap.get(documentId);
                    this.handleMultipleDocumentRows(previousEntry, resultBuilder);
                }
            }
            resultSetHasNext = resultSet.next();
        }
        perfLog.log("Time to read doc search results.", true);
        results.setOverThreshold(resultSetHasNext);
        LOG.debug((Object)("Processed " + resultMap.size() + " document search result rows."));
        return results;
    }

    private void handleMultipleDocumentRows(DocumentSearchResult.Builder existingRow, DocumentSearchResult.Builder newRow) {
        for (DocumentAttribute.AbstractBuilder newDocumentAttribute : newRow.getDocumentAttributes()) {
            existingRow.getDocumentAttributes().add(newDocumentAttribute);
        }
    }

    protected DocumentSearchResult.Builder processRow(DocumentSearchCriteria criteria, Statement searchAttributeStatement, ResultSet rs) throws SQLException {
        String documentId = rs.getString("DOC_HDR_ID");
        String initiatorPrincipalId = rs.getString("INITR_PRNCPL_ID");
        String documentTypeName = rs.getString("DOC_TYP_NM");
        DocumentType documentType = this.getApiDocumentTypeService().getDocumentTypeByName(documentTypeName);
        String documentTypeId = "unavailable";
        if (documentType == null) {
            LOG.warn((Object)("Failed to locate a document type with the given name: " + documentTypeName));
        } else {
            documentTypeId = documentType.getId();
        }
        Document.Builder documentBuilder = Document.Builder.create((String)documentId, (String)initiatorPrincipalId, (String)documentTypeName, (String)documentTypeId);
        DocumentSearchResult.Builder resultBuilder = DocumentSearchResult.Builder.create((Document.Builder)documentBuilder);
        String statusCode = rs.getString("DOC_HDR_STAT_CD");
        Timestamp createTimestamp = rs.getTimestamp("CRTE_DT");
        String title = rs.getString("TTL");
        String applicationDocumentStatus = rs.getString("APP_DOC_STAT");
        documentBuilder.setStatus(DocumentStatus.fromCode((String)statusCode));
        documentBuilder.setDateCreated(new DateTime(createTimestamp.getTime()));
        documentBuilder.setTitle(title);
        documentBuilder.setApplicationDocumentStatus(applicationDocumentStatus);
        documentBuilder.setApplicationDocumentStatusDate(new DateTime((Object)rs.getTimestamp("APP_DOC_STAT_MDFN_DT")));
        documentBuilder.setDateApproved(new DateTime((Object)rs.getTimestamp("APRV_DT")));
        documentBuilder.setDateFinalized(new DateTime((Object)rs.getTimestamp("FNL_DT")));
        documentBuilder.setApplicationDocumentId(rs.getString("APP_DOC_ID"));
        documentBuilder.setDateLastModified(new DateTime((Object)rs.getTimestamp("STAT_MDFN_DT")));
        documentBuilder.setRoutedByPrincipalId(rs.getString("RTE_PRNCPL_ID"));
        documentBuilder.setDocumentHandlerUrl(rs.getString("DOC_HDLR_URL"));
        if (this.isUsingAtLeastOneSearchAttribute(criteria)) {
            this.populateDocumentAttributesValues(resultBuilder, searchAttributeStatement);
        }
        return resultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateDocumentAttributesValues(DocumentSearchResult.Builder resultBuilder, Statement searchAttributeStatement) throws SQLException {
        searchAttributeStatement.setFetchSize(50);
        String documentId = resultBuilder.getDocument().getDocumentId();
        List<SearchableAttributeValue> attributeValues = DocumentSearchInternalUtils.getSearchableAttributeValueObjectTypes();
        PerformanceLogger perfLog = new PerformanceLogger(documentId);
        for (SearchableAttributeValue searchAttValue : attributeValues) {
            String attributeSql = "select KEY_CD, VAL from " + searchAttValue.getAttributeTableName() + " where DOC_HDR_ID = '" + documentId + "'";
            ResultSet attributeResultSet = null;
            try {
                attributeResultSet = searchAttributeStatement.executeQuery(attributeSql);
                while (attributeResultSet.next()) {
                    searchAttValue.setSearchableAttributeKey(attributeResultSet.getString("KEY_CD"));
                    searchAttValue.setupAttributeValue(attributeResultSet, "VAL");
                    if (StringUtils.isEmpty((String)searchAttValue.getSearchableAttributeKey()) || searchAttValue.getSearchableAttributeValue() == null) continue;
                    DocumentAttribute documentAttribute = searchAttValue.toDocumentAttribute();
                    resultBuilder.getDocumentAttributes().add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)documentAttribute));
                }
            }
            finally {
                if (attributeResultSet == null) continue;
                try {
                    attributeResultSet.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not close searchable attribute result set for class " + searchAttValue.getClass().getName()), (Throwable)e);
                }
            }
        }
        perfLog.log("Time to execute doc search search attribute queries.", true);
    }

    @Override
    public String generateSearchSql(DocumentSearchCriteria criteria, List<RemotableAttributeField> searchFields) {
        String docRouteNodeSql;
        String docTypeTableAlias = "DOC1";
        String docHeaderTableAlias = "DOC_HDR";
        String sqlPrefix = "Select * from (";
        String sqlSuffix = ") FINAL_SEARCH order by FINAL_SEARCH.CRTE_DT desc";
        StringBuilder selectSQL = new StringBuilder("select DISTINCT(" + docHeaderTableAlias + ".DOC_HDR_ID), " + StringUtils.join((Object[])new String[]{docHeaderTableAlias + ".INITR_PRNCPL_ID", docHeaderTableAlias + ".DOC_HDR_STAT_CD", docHeaderTableAlias + ".CRTE_DT", docHeaderTableAlias + ".TTL", docHeaderTableAlias + ".APP_DOC_STAT", docHeaderTableAlias + ".STAT_MDFN_DT", docHeaderTableAlias + ".APRV_DT", docHeaderTableAlias + ".FNL_DT", docHeaderTableAlias + ".APP_DOC_ID", docHeaderTableAlias + ".RTE_PRNCPL_ID", docHeaderTableAlias + ".APP_DOC_STAT_MDFN_DT", docTypeTableAlias + ".DOC_TYP_NM", docTypeTableAlias + ".LBL", docTypeTableAlias + ".DOC_HDLR_URL", docTypeTableAlias + ".ACTV_IND"}, (String)", "));
        StringBuilder fromSQL = new StringBuilder(" from KREW_DOC_TYP_T " + docTypeTableAlias + " ");
        StringBuilder fromSQLForDocHeaderTable = new StringBuilder(", KREW_DOC_HDR_T " + docHeaderTableAlias + " ");
        StringBuilder whereSQL = new StringBuilder();
        whereSQL.append(this.getDocumentIdSql(criteria.getDocumentId(), this.getGeneratedPredicatePrefix(whereSQL.length()), docHeaderTableAlias));
        String principalInitiatorIdSql = this.getInitiatorIdSql(criteria.getInitiatorPrincipalId(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        if (StringUtils.isNotBlank((String)principalInitiatorIdSql)) {
            whereSQL.append(principalInitiatorIdSql);
        } else {
            whereSQL.append(this.getInitiatorSql(criteria.getInitiatorPrincipalName(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        }
        whereSQL.append(this.getAppDocIdSql(criteria.getApplicationDocumentId(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDateCreatedSql(criteria.getDateCreatedFrom(), criteria.getDateCreatedTo(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDateLastModifiedSql(criteria.getDateLastModifiedFrom(), criteria.getDateLastModifiedTo(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDateApprovedSql(criteria.getDateApprovedFrom(), criteria.getDateApprovedTo(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDateFinalizedSql(criteria.getDateFinalizedFrom(), criteria.getDateFinalizedTo(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        String principalViewerSql = this.getViewerSql(criteria.getViewerPrincipalName(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        String principalViewerIdSql = this.getViewerIdSql(criteria.getViewerPrincipalId(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        if (StringUtils.isNotBlank((String)principalViewerIdSql)) {
            principalViewerSql = "";
        }
        String groupViewerSql = this.getGroupViewerSql(criteria.getGroupViewerId(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        if (StringUtils.isNotBlank((String)principalViewerSql) || StringUtils.isNotBlank((String)groupViewerSql) || StringUtils.isNotBlank((String)principalViewerIdSql)) {
            whereSQL.append(principalViewerSql);
            whereSQL.append(principalViewerIdSql);
            whereSQL.append(groupViewerSql);
            fromSQL.append(", KREW_ACTN_RQST_T ");
        }
        String principalApproverSql = this.getApproverSql(criteria.getApproverPrincipalName(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        String principalApproverIdSql = this.getApproverIdSql(criteria.getApproverPrincipalId(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        if (StringUtils.isNotBlank((String)principalApproverIdSql)) {
            principalApproverSql = "";
        }
        if (StringUtils.isNotBlank((String)principalApproverSql) || StringUtils.isNotBlank((String)principalApproverIdSql)) {
            whereSQL.append(principalApproverSql);
            whereSQL.append(principalApproverIdSql);
            fromSQL.append(", KREW_ACTN_TKN_T ");
        }
        if (StringUtils.isNotBlank((String)(docRouteNodeSql = this.getDocRouteNodeSql(criteria.getDocumentTypeName(), criteria.getRouteNodeName(), criteria.getRouteNodeLookupLogic(), this.getGeneratedPredicatePrefix(whereSQL.length()))))) {
            whereSQL.append(docRouteNodeSql);
            fromSQL.append(", KREW_RTE_NODE_INSTN_T ");
            fromSQL.append(", KREW_RTE_NODE_T ");
        }
        if (!criteria.getDocumentAttributeValues().isEmpty()) {
            QueryComponent queryComponent = this.getSearchableAttributeSql(criteria.getDocumentAttributeValues(), searchFields, this.getGeneratedPredicatePrefix(whereSQL.length()));
            selectSQL.append(queryComponent.getSelectSql());
            fromSQL.append(queryComponent.getFromSql());
            whereSQL.append(queryComponent.getWhereSql());
        }
        whereSQL.append(this.getDocTypeFullNameWhereSql(criteria, this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDocTitleSql(criteria.getTitle(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getDocumentStatusSql(criteria.getDocumentStatuses(), criteria.getDocumentStatusCategories(), this.getGeneratedPredicatePrefix(whereSQL.length())));
        whereSQL.append(this.getGeneratedPredicatePrefix(whereSQL.length())).append(" DOC_HDR.DOC_TYP_ID = DOC1.DOC_TYP_ID ");
        fromSQL.append((CharSequence)fromSQLForDocHeaderTable);
        String statusTransitionWhereClause = this.getStatusTransitionDateSql(criteria.getDateApplicationDocumentStatusChangedFrom(), criteria.getDateApplicationDocumentStatusChangedTo(), this.getGeneratedPredicatePrefix(whereSQL.length()));
        ArrayList<String> applicationDocumentStatuses = criteria.getApplicationDocumentStatuses();
        if (!StringUtils.isBlank((String)criteria.getApplicationDocumentStatus()) && !criteria.getApplicationDocumentStatuses().contains(criteria.getApplicationDocumentStatus())) {
            applicationDocumentStatuses = new ArrayList<String>(criteria.getApplicationDocumentStatuses());
            applicationDocumentStatuses.add(criteria.getApplicationDocumentStatus());
        }
        whereSQL.append(this.getAppDocStatusesSql((List<String>)applicationDocumentStatuses, this.getGeneratedPredicatePrefix(whereSQL.length()), statusTransitionWhereClause.length()));
        if (statusTransitionWhereClause.length() > 0) {
            whereSQL.append(statusTransitionWhereClause);
            whereSQL.append(this.getGeneratedPredicatePrefix(whereSQL.length())).append(" DOC_HDR.DOC_HDR_ID = STAT_TRAN.DOC_HDR_ID ");
            fromSQL.append(", KREW_APP_DOC_STAT_TRAN_T STAT_TRAN ");
        }
        String finalizedSql = sqlPrefix + " " + selectSQL.toString() + " " + fromSQL.toString() + " " + whereSQL.toString() + " " + sqlSuffix;
        LOG.info((Object)"*********** SEARCH SQL ***************");
        LOG.info((Object)finalizedSql);
        LOG.info((Object)"**************************************");
        return finalizedSql;
    }

    public String getDocumentIdSql(String documentId, String whereClausePredicatePrefix, String tableAlias) {
        if (StringUtils.isBlank((String)documentId)) {
            return "";
        }
        Criteria crit = this.getSqlBuilder().createCriteria("DOC_HDR_ID", documentId, "KREW_DOC_HDR_T", tableAlias, String.class, false, true);
        return whereClausePredicatePrefix + crit.buildWhere();
    }

    public String getDocTitleSql(String docTitle, String whereClausePredicatePrefix) {
        if (StringUtils.isBlank((String)docTitle)) {
            return "";
        }
        docTitle = docTitle.trim().replace("'", "''");
        SqlBuilder sqlBuild = new SqlBuilder();
        Criteria crit = new Criteria("KREW_DOC_HDR_T", "DOC_HDR");
        sqlBuild.addCriteria("TTL", docTitle, String.class, true, true, crit);
        return whereClausePredicatePrefix + crit.buildWhere();
    }

    public String getAppDocIdSql(String appDocId, String whereClausePredicatePrefix) {
        if (StringUtils.isBlank((String)appDocId)) {
            return "";
        }
        String tableAlias = "DOC_HDR";
        Criteria crit = this.getSqlBuilder().createCriteria("APP_DOC_ID", appDocId, "KREW_DOC_HDR_T", tableAlias, String.class);
        return whereClausePredicatePrefix + crit.buildWhere();
    }

    public String getDateCreatedSql(DateTime fromDateCreated, DateTime toDateCreated, String whereClausePredicatePrefix) {
        return this.establishDateString(fromDateCreated, toDateCreated, "KREW_DOC_HDR_T", "DOC_HDR", "CRTE_DT", whereClausePredicatePrefix);
    }

    public String getDateApprovedSql(DateTime fromDateApproved, DateTime toDateApproved, String whereClausePredicatePrefix) {
        return this.establishDateString(fromDateApproved, toDateApproved, "KREW_DOC_HDR_T", "DOC_HDR", "APRV_DT", whereClausePredicatePrefix);
    }

    public String getDateFinalizedSql(DateTime fromDateFinalized, DateTime toDateFinalized, String whereClausePredicatePrefix) {
        return this.establishDateString(fromDateFinalized, toDateFinalized, "KREW_DOC_HDR_T", "DOC_HDR", "FNL_DT", whereClausePredicatePrefix);
    }

    public String getDateLastModifiedSql(DateTime fromDateLastModified, DateTime toDateLastModified, String whereClausePredicatePrefix) {
        return this.establishDateString(fromDateLastModified, toDateLastModified, "KREW_DOC_HDR_T", "DOC_HDR", "STAT_MDFN_DT", whereClausePredicatePrefix);
    }

    public String getStatusTransitionDateSql(DateTime fromStatusTransitionDate, DateTime toStatusTransitionDate, String whereClausePredicatePrefix) {
        return this.establishDateString(fromStatusTransitionDate, toStatusTransitionDate, "KREW_DOC_HDR_T", "DOC_HDR", "APP_DOC_STAT_MDFN_DT", whereClausePredicatePrefix);
    }

    public String getViewerSql(String viewer, String whereClausePredicatePrefix) {
        StringBuilder returnSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)viewer)) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("principalName", viewer);
            List personList = KimApiServiceLocator.getPersonService().findPeople(m, false);
            ArrayList<String> principalList = new ArrayList<String>();
            if (CollectionUtils.isEmpty((Collection)personList)) {
                Principal tempPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(viewer.trim());
                if (tempPrincipal != null) {
                    principalList.add(tempPrincipal.getPrincipalId());
                } else {
                    return whereClausePredicatePrefix + " 1 = 0 ";
                }
            }
            for (Person person : personList) {
                principalList.add(person.getPrincipalId());
            }
            Criteria crit = new Criteria("KREW_ACTN_RQST_T", "KREW_ACTN_RQST_T");
            crit.in("PRNCPL_ID", principalList, String.class);
            returnSql.append(whereClausePredicatePrefix + "( (DOC_HDR.DOC_HDR_ID = KREW_ACTN_RQST_T.DOC_HDR_ID and " + crit.buildWhere() + " )");
            TreeSet viewerGroupIds = new TreeSet();
            if (CollectionUtils.isNotEmpty(principalList)) {
                for (String principalId : principalList) {
                    viewerGroupIds.addAll(KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId));
                }
            }
            if (viewerGroupIds != null && !viewerGroupIds.isEmpty()) {
                returnSql.append(" or ( DOC_HDR.DOC_HDR_ID = KREW_ACTN_RQST_T.DOC_HDR_ID and KREW_ACTN_RQST_T.GRP_ID in (");
                boolean first = true;
                for (String groupId : viewerGroupIds) {
                    if (!first) {
                        returnSql.append(",");
                    }
                    returnSql.append("'").append(groupId).append("'");
                    first = false;
                }
                returnSql.append("))");
            }
            returnSql.append(")");
        }
        return returnSql.toString();
    }

    public String getViewerIdSql(String viewerId, String whereClausePredicatePrefix) {
        StringBuilder returnSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)viewerId)) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("principalId", viewerId);
            List personList = KimApiServiceLocator.getPersonService().findPeople(m, false);
            ArrayList<String> principalList = new ArrayList<String>();
            if (CollectionUtils.isEmpty((Collection)personList)) {
                return whereClausePredicatePrefix + " 1 = 0 ";
            }
            for (Person person : personList) {
                principalList.add(person.getPrincipalId());
            }
            Criteria crit = new Criteria("KREW_ACTN_RQST_T", "KREW_ACTN_RQST_T");
            crit.in("PRNCPL_ID", principalList, String.class);
            returnSql.append(whereClausePredicatePrefix + "( DOC_HDR.DOC_HDR_ID = KREW_ACTN_RQST_T.DOC_HDR_ID and " + crit.buildWhere() + " )");
        }
        return returnSql.toString();
    }

    public String getGroupViewerSql(String groupId, String whereClausePredicatePrefix) {
        String sql = "";
        if (StringUtils.isNotBlank((String)groupId)) {
            sql = whereClausePredicatePrefix + " DOC_HDR.DOC_HDR_ID = KREW_ACTN_RQST_T.DOC_HDR_ID and KREW_ACTN_RQST_T.GRP_ID = '" + groupId + "'";
        }
        return sql;
    }

    public String getInitiatorSql(String initiatorPrincipalName, String whereClausePredicatePrefix) {
        if (StringUtils.isBlank((String)initiatorPrincipalName)) {
            return "";
        }
        String tableAlias = "DOC_HDR";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("principalName", initiatorPrincipalName);
        List pList = KimApiServiceLocator.getPersonService().findPeople(m, false);
        ArrayList<String> principalList = new ArrayList<String>();
        if (pList == null || pList.isEmpty()) {
            Principal tempPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(initiatorPrincipalName.trim());
            if (tempPrincipal != null) {
                principalList.add(tempPrincipal.getPrincipalId());
            } else {
                return whereClausePredicatePrefix + " 1 = 0 ";
            }
        }
        for (Person p : pList) {
            principalList.add(p.getPrincipalId());
        }
        Criteria crit = new Criteria("KREW_DOC_HDR_T", tableAlias);
        crit.in("INITR_PRNCPL_ID", principalList, String.class);
        return whereClausePredicatePrefix + crit.buildWhere();
    }

    public String getInitiatorIdSql(String initiatorPrincipalId, String whereClausePredicatePrefix) {
        if (StringUtils.isBlank((String)initiatorPrincipalId)) {
            return "";
        }
        String tableAlias = "DOC_HDR";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("principalId", initiatorPrincipalId);
        List pList = KimApiServiceLocator.getPersonService().findPeople(m, false);
        ArrayList<String> principalList = new ArrayList<String>();
        if (pList == null || pList.isEmpty()) {
            return whereClausePredicatePrefix + " 1 = 0 ";
        }
        for (Person p : pList) {
            principalList.add(p.getPrincipalId());
        }
        Criteria crit = new Criteria("KREW_DOC_HDR_T", tableAlias);
        crit.in("INITR_PRNCPL_ID", principalList, String.class);
        return whereClausePredicatePrefix + crit.buildWhere();
    }

    public String getApproverSql(String approver, String whereClausePredicatePrefix) {
        String returnSql = "";
        if (StringUtils.isNotBlank((String)approver)) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("principalName", approver);
            List pList = KimApiServiceLocator.getPersonService().findPeople(m, false);
            ArrayList<String> principalList = new ArrayList<String>();
            if (pList == null || pList.isEmpty()) {
                Principal tempPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(approver.trim());
                if (tempPrincipal != null) {
                    principalList.add(tempPrincipal.getPrincipalId());
                } else {
                    return whereClausePredicatePrefix + " 1 = 0 ";
                }
            }
            for (Person p : pList) {
                principalList.add(p.getPrincipalId());
            }
            Criteria crit = new Criteria("KREW_ACTN_TKN_T", "KREW_ACTN_TKN_T");
            crit.in("PRNCPL_ID", principalList, String.class);
            returnSql = whereClausePredicatePrefix + " DOC_HDR.DOC_HDR_ID = KREW_ACTN_TKN_T.DOC_HDR_ID and upper(KREW_ACTN_TKN_T.ACTN_CD) in ('" + "A" + "','" + "B" + "')" + " and " + crit.buildWhere();
        }
        return returnSql;
    }

    public String getApproverIdSql(String approverId, String whereClausePredicatePrefix) {
        String returnSql = "";
        if (StringUtils.isNotBlank((String)approverId)) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("principalId", approverId);
            List pList = KimApiServiceLocator.getPersonService().findPeople(m, false);
            ArrayList<String> principalList = new ArrayList<String>();
            if (pList == null || pList.isEmpty()) {
                return whereClausePredicatePrefix + " 1 = 0 ";
            }
            for (Person p : pList) {
                principalList.add(p.getPrincipalId());
            }
            Criteria crit = new Criteria("KREW_ACTN_TKN_T", "KREW_ACTN_TKN_T");
            crit.in("PRNCPL_ID", principalList, String.class);
            returnSql = whereClausePredicatePrefix + " DOC_HDR.DOC_HDR_ID = KREW_ACTN_TKN_T.DOC_HDR_ID and upper(KREW_ACTN_TKN_T.ACTN_CD) in ('" + "A" + "','" + "B" + "')" + " and " + crit.buildWhere();
        }
        return returnSql;
    }

    public String getDocTypeFullNameWhereSql(DocumentSearchCriteria criteria, String whereClausePredicatePrefix) {
        ArrayList<String> documentTypeNamesToSearch = new ArrayList<String>();
        String primaryDocumentTypeName = criteria.getDocumentTypeName();
        if (StringUtils.isNotBlank((String)primaryDocumentTypeName)) {
            documentTypeNamesToSearch.add(primaryDocumentTypeName);
        }
        documentTypeNamesToSearch.addAll(criteria.getAdditionalDocumentTypeNames());
        StringBuilder returnSql = new StringBuilder("");
        if (CollectionUtils.isNotEmpty(documentTypeNamesToSearch)) {
            int index = 0;
            for (String documentTypeName : documentTypeNamesToSearch) {
                if (!StringUtils.isNotBlank((String)documentTypeName)) continue;
                String clause = index++ == 0 ? "" : " or ";
                DocumentTypeService docSrv = KEWServiceLocator.getDocumentTypeService();
                org.kuali.rice.kew.doctype.bo.DocumentType docType = docSrv.findByNameCaseInsensitive(documentTypeName.trim());
                if (docType != null) {
                    if (documentTypeName.contains("*") || documentTypeName.contains(DATABASE_WILDCARD_CHARACTER_STRING)) {
                        this.addDocumentTypeLikeNameToSearchOn(returnSql, documentTypeName.trim(), clause);
                    } else {
                        this.addDocumentTypeNameToSearchOn(returnSql, documentTypeName.trim(), clause);
                    }
                    if (docType.getChildrenDocTypes() == null) continue;
                    this.addChildDocumentTypes(returnSql, docType.getChildrenDocTypes());
                    continue;
                }
                this.addDocumentTypeLikeNameToSearchOn(returnSql, documentTypeName.trim(), clause);
            }
        }
        if (returnSql.length() > 0) {
            returnSql.insert(0, "(");
            returnSql.insert(0, whereClausePredicatePrefix);
            returnSql.append(")");
        }
        return returnSql.toString();
    }

    public void addChildDocumentTypes(StringBuilder whereSql, Collection<org.kuali.rice.kew.doctype.bo.DocumentType> childDocumentTypes) {
        for (org.kuali.rice.kew.doctype.bo.DocumentType child : childDocumentTypes) {
            this.addDocumentTypeNameToSearchOn(whereSql, child.getName());
            this.addChildDocumentTypes(whereSql, child.getChildrenDocTypes());
        }
    }

    public void addDocumentTypeNameToSearchOn(StringBuilder whereSql, String documentTypeName) {
        this.addDocumentTypeNameToSearchOn(whereSql, documentTypeName, " or ");
    }

    public void addDocumentTypeNameToSearchOn(StringBuilder whereSql, String documentTypeName, String clause) {
        whereSql.append(clause).append("upper(DOC1.DOC_TYP_NM) = '" + documentTypeName.toUpperCase() + "'");
    }

    public void addDocumentTypeLikeNameToSearchOn(StringBuilder whereSql, String documentTypeName, String clause) {
        documentTypeName = documentTypeName.replace('*', '%');
        whereSql.append(clause).append(" upper(DOC1.DOC_TYP_NM) LIKE '" + documentTypeName.toUpperCase() + "'");
    }

    public String getDocRouteNodeSql(String documentTypeFullName, String routeNodeName, RouteNodeLookupLogic docRouteLevelLogic, String whereClausePredicatePrefix) {
        String returnSql = "";
        if (StringUtils.isNotBlank((String)routeNodeName)) {
            if (docRouteLevelLogic == null) {
                docRouteLevelLogic = RouteNodeLookupLogic.EXACTLY;
            }
            StringBuilder routeNodeCriteria = new StringBuilder("and KREW_RTE_NODE_T.NM ");
            if (RouteNodeLookupLogic.EXACTLY == docRouteLevelLogic) {
                routeNodeCriteria.append("= '" + this.getDbPlatform().escapeString(routeNodeName) + "' ");
            } else {
                routeNodeCriteria.append("in (");
                StringBuilder routeNodeInCriteria = new StringBuilder();
                boolean foundSpecifiedNode = false;
                List<RouteNode> routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(this.getValidDocumentType(documentTypeFullName), true);
                for (RouteNode routeNode : routeNodes) {
                    if (routeNodeName.equals(routeNode.getRouteNodeName())) {
                        foundSpecifiedNode = true;
                        continue;
                    }
                    if ((foundSpecifiedNode || RouteNodeLookupLogic.BEFORE != docRouteLevelLogic) && (!foundSpecifiedNode || RouteNodeLookupLogic.AFTER != docRouteLevelLogic)) continue;
                    if (routeNodeInCriteria.length() > 0) {
                        routeNodeInCriteria.append(", ");
                    }
                    routeNodeInCriteria.append("'" + routeNode.getRouteNodeName() + "'");
                }
                if (routeNodeInCriteria.length() > 0) {
                    routeNodeCriteria.append((CharSequence)routeNodeInCriteria);
                } else {
                    routeNodeCriteria.append("''");
                }
                routeNodeCriteria.append(") ");
            }
            returnSql = whereClausePredicatePrefix + "DOC_HDR.DOC_HDR_ID = " + ROUTE_NODE_INST_TABLE + ".DOC_HDR_ID and " + ROUTE_NODE_INST_TABLE + ".RTE_NODE_ID = " + ROUTE_NODE_TABLE + ".RTE_NODE_ID and " + ROUTE_NODE_INST_TABLE + ".ACTV_IND = 1 " + routeNodeCriteria.toString() + " ";
        }
        return returnSql;
    }

    public String getDocumentStatusSql(List<DocumentStatus> documentStatuses, List<DocumentStatusCategory> categories, String whereClausePredicatePrefix) {
        if (CollectionUtils.isEmpty(documentStatuses) && CollectionUtils.isEmpty(categories)) {
            return whereClausePredicatePrefix + "DOC_HDR.DOC_HDR_STAT_CD != '" + DocumentStatus.INITIATED.getCode() + "'";
        }
        HashSet<DocumentStatus> statusesToInclude = new HashSet<DocumentStatus>(documentStatuses);
        for (DocumentStatusCategory category : categories) {
            EnumSet categoryStatuses = DocumentStatus.getStatusesForCategory((DocumentStatusCategory)category);
            statusesToInclude.addAll(categoryStatuses);
        }
        HashSet<String> statusCodes = new HashSet<String>();
        for (DocumentStatus statusToInclude : statusesToInclude) {
            statusCodes.add("'" + this.getDbPlatform().escapeString(statusToInclude.getCode()) + "'");
        }
        return whereClausePredicatePrefix + " DOC_HDR.DOC_HDR_STAT_CD in (" + StringUtils.join(statusCodes, (String)", ") + ")";
    }

    public String getAppDocStatusesSql(List<String> appDocStatuses, String whereClausePredicatePrefix, int statusTransitionWhereClauseLength) {
        if (CollectionUtils.isEmpty(appDocStatuses)) {
            return "";
        }
        String inList = this.buildAppDocStatusInList(appDocStatuses);
        if (statusTransitionWhereClauseLength > 0) {
            return whereClausePredicatePrefix + " STAT_TRAN.APP_DOC_STAT_TO" + inList;
        }
        return whereClausePredicatePrefix + " DOC_HDR.APP_DOC_STAT" + inList;
    }

    private String buildAppDocStatusInList(List<String> appDocStatuses) {
        StringBuilder sql = new StringBuilder(" IN (");
        boolean first = true;
        for (String appDocStatus : appDocStatuses) {
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            sql.append("'");
            sql.append(this.getDbPlatform().escapeString(appDocStatus.trim()));
            sql.append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    public String getGeneratedPredicatePrefix(int whereClauseSize) {
        return whereClauseSize > 0 ? " and " : " where ";
    }

    public String establishDateString(DateTime fromDate, DateTime toDate, String tableName, String tableAlias, String colName, String whereStatementClause) {
        String fromDateValue = null;
        if (fromDate != null) {
            fromDateValue = CoreApiServiceLocator.getDateTimeService().toDateString(fromDate.toDate());
        }
        String toDateValue = null;
        if (toDate != null) {
            toDateValue = CoreApiServiceLocator.getDateTimeService().toDateString(toDate.toDate());
            toDateValue = toDateValue + " 23:59:59";
        }
        String searchValue = null;
        if (fromDateValue != null && toDateValue != null) {
            searchValue = fromDateValue + " .. " + toDateValue;
        } else if (fromDateValue != null) {
            searchValue = ">= " + fromDateValue;
        } else if (toDateValue != null) {
            searchValue = "<= " + toDateValue;
        } else {
            return "";
        }
        Criteria crit = this.getSqlBuilder().createCriteria(colName, searchValue, tableName, tableAlias, Date.class, true, true);
        return whereStatementClause + crit.buildWhere();
    }

    public DatabasePlatform getDbPlatform() {
        if (this.dbPlatform == null) {
            this.dbPlatform = (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
        }
        return this.dbPlatform;
    }

    public SqlBuilder getSqlBuilder() {
        if (this.sqlBuilder == null) {
            this.sqlBuilder = new SqlBuilder();
            this.sqlBuilder.setDbPlatform(this.getDbPlatform());
            this.sqlBuilder.setDateTimeService(CoreApiServiceLocator.getDateTimeService());
        }
        return this.sqlBuilder;
    }

    public void setSqlBuilder(SqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected boolean isUsingAtLeastOneSearchAttribute(DocumentSearchCriteria criteria) {
        return criteria.getDocumentAttributeValues().size() > 0 || StringUtils.isNotBlank((String)criteria.getDocumentTypeName());
    }

    protected org.kuali.rice.kew.api.doctype.DocumentTypeService getApiDocumentTypeService() {
        if (this.apiDocumentTypeService == null) {
            this.apiDocumentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.apiDocumentTypeService;
    }

    protected void setApiDocumentTypeService(org.kuali.rice.kew.api.doctype.DocumentTypeService apiDocumentTypeService) {
        this.apiDocumentTypeService = apiDocumentTypeService;
    }
}

