/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.quicklinks.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.quicklinks.ActionListStats;
import org.kuali.rice.kew.quicklinks.InitiatedDocumentType;
import org.kuali.rice.kew.quicklinks.WatchedDocument;
import org.kuali.rice.kew.quicklinks.dao.QuickLinksDAO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class QuickLinksDAOJpa
implements QuickLinksDAO {
    private EntityManager entityManager;
    public static final String FIND_WATCHED_DOCUMENTS_BY_INITIATOR_WORKFLOW_ID_NAME = "DocumentRouteHeaderValue.QuickLinks.FindWatchedDocumentsByInitiatorWorkflowId";
    public static final String FIND_WATCHED_DOCUMENTS_BY_INITIATOR_WORKFLOW_ID_QUERY = "SELECT d FROM DocumentRouteHeaderValue d WHERE d.initiatorWorkflowId = :initiatorWorkflowId AND d.docRouteStatus IN ('R','E') ORDER BY d.createDate DESC";

    @Override
    public List<ActionListStats> getActionListStats(String principalId) {
        try {
            List stats = this.getEntityManager().createNamedQuery("ActionItem.GetQuickLinksDocumentTypeNameAndCount").setParameter("principalId", (Object)principalId).setParameter("delegationType", (Object)DelegationType.SECONDARY.getCode()).getResultList();
            ArrayList<ActionListStats> docTypes = new ArrayList<ActionListStats>(stats.size());
            for (Object[] res : stats) {
                String docTypeName = (String)res[0];
                Long count = (Long)res[1];
                DocumentType docType = this.getDocumentTypeService().findByName(docTypeName);
                if (docType == null) continue;
                docTypes.add(new ActionListStats(docTypeName, docType.getLabel(), count.intValue()));
            }
            Collections.sort(docTypes);
            return docTypes;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error getting action list stats for user: " + principalId, (Throwable)e);
        }
    }

    @Override
    public List<InitiatedDocumentType> getInitiatedDocumentTypesList(String principalId) {
        String documentNames = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "QuickLink", "RESTRICT_DOCUMENT_TYPES");
        if (documentNames != null) {
            documentNames = documentNames.trim();
        }
        if (documentNames == null || "none".equals(documentNames)) {
            documentNames = "";
        }
        StringTokenizer st = new StringTokenizer(documentNames, ",");
        ArrayList<String> docTypesToRestrict = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            docTypesToRestrict.add(st.nextToken());
        }
        try {
            List list = this.getEntityManager().createNamedQuery("DocumentType.QuickLinks.FindInitiatedDocumentTypesListByInitiatorWorkflowId").setParameter("initiatorWorkflowId", (Object)principalId).getResultList();
            ArrayList<InitiatedDocumentType> documentTypesByName = new ArrayList<InitiatedDocumentType>(list.size());
            for (Object[] doc : list) {
                DocumentType docType;
                DocumentTypePolicy quickInitiatePolicy;
                String docTypeName = (String)doc[0];
                String label = (String)doc[1];
                int firstPeriod = docTypeName.indexOf(".");
                String docTypeTopParent = firstPeriod == -1 ? docTypeName.substring(0) : docTypeName.substring(0, firstPeriod);
                if (docTypesToRestrict.contains(docTypeTopParent) || !(quickInitiatePolicy = (docType = KEWServiceLocator.getDocumentTypeService().findByName(docTypeName)).getSupportsQuickInitiatePolicy()).getPolicyValue().booleanValue()) continue;
                documentTypesByName.add(new InitiatedDocumentType(docTypeName, label));
            }
            return documentTypesByName;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error getting initiated document types for user: " + principalId, (Throwable)e);
        }
    }

    @Override
    public List<KeyValue> getNamedSearches(String principalId) {
        return this.getDocumentSearchService().getNamedSearches(principalId);
    }

    @Override
    public List<KeyValue> getRecentSearches(String principalId) {
        return this.getDocumentSearchService().getMostRecentSearches(principalId);
    }

    @Override
    public List<WatchedDocument> getWatchedDocuments(String principalId) {
        try {
            List documentRouteHeaderValues = this.getEntityManager().createNamedQuery(FIND_WATCHED_DOCUMENTS_BY_INITIATOR_WORKFLOW_ID_NAME).setParameter("initiatorWorkflowId", (Object)principalId).getResultList();
            ArrayList<WatchedDocument> watchedDocuments = new ArrayList<WatchedDocument>();
            for (DocumentRouteHeaderValue documentRouteHeader : documentRouteHeaderValues) {
                WatchedDocument watchedDocument = new WatchedDocument(documentRouteHeader.getDocumentId(), documentRouteHeader.getDocRouteStatusLabel(), documentRouteHeader.getDocTitle());
                watchedDocuments.add(watchedDocument);
            }
            return watchedDocuments;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error getting watched documents for user: " + principalId, (Throwable)e);
        }
    }

    public DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    public DocumentSearchService getDocumentSearchService() {
        return (DocumentSearchService)KEWServiceLocator.getService("enDocumentSearchService");
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

