/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class AbstractTransformationFilter
extends XMLFilterImpl {
    private List<String> groupXmlStack = new ArrayList<String>();

    public abstract CurrentElement transformStartElement(CurrentElement var1) throws SAXException;

    public abstract CurrentElement transformEndElement(CurrentElement var1) throws SAXException;

    public abstract List<KeyValue> getElementTransformationList();

    public abstract String getStartingElementPath();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.groupXmlStack.isEmpty()) {
            this.groupXmlStack.add(localName);
        } else {
            this.groupXmlStack.add(this.groupXmlStack.get(this.groupXmlStack.size() - 1) + "." + localName);
        }
        String currentElementKey = this.groupXmlStack.get(this.groupXmlStack.size() - 1);
        CurrentElement currentElement = new CurrentElement(currentElementKey, uri, localName, qName, atts);
        if (this.getElementTransformationList().contains(new ConcreteKeyValue(this.getTrimmedCurrentElementKey(currentElementKey), uri))) {
            CurrentElement transformedElement = this.transformStartElement(currentElement);
            super.startElement(transformedElement.getUri(), transformedElement.getLocalName(), transformedElement.getqName(), transformedElement.getAttributes());
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    protected String getTrimmedCurrentElementKey(String currentElementKey) {
        return currentElementKey.replaceFirst(StringEscapeUtils.escapeJava((String)(this.getStartingElementPath() + ".")), "");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentElementKey = this.groupXmlStack.get(this.groupXmlStack.size() - 1);
        CurrentElement currentElement = new CurrentElement(currentElementKey, uri, localName, qName);
        if (this.getElementTransformationList().contains(new ConcreteKeyValue(this.getTrimmedCurrentElementKey(currentElementKey), uri))) {
            CurrentElement transformedElement = this.transformEndElement(currentElement);
            super.endElement(transformedElement.getUri(), transformedElement.getLocalName(), transformedElement.getqName());
        } else {
            super.endElement(uri, localName, qName);
        }
        if (!this.groupXmlStack.isEmpty()) {
            this.groupXmlStack.remove(currentElementKey);
        }
    }

    public class CurrentElement {
        String nameKey;
        String uri;
        String localName;
        String qName;
        Attributes attributes;

        public CurrentElement() {
        }

        public CurrentElement(String nameKey, String uri, String localName, String qName) {
            this.nameKey = nameKey;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
        }

        public CurrentElement(String nameKey, String uri, String localName, String qName, Attributes attributes) {
            this.nameKey = nameKey;
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attributes = attributes;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = localName;
        }

        public String getqName() {
            return this.qName;
        }

        public void setqName(String qName) {
            this.qName = qName;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public String getNameKey() {
            return this.nameKey;
        }

        public void setNameKey(String nameKey) {
            this.nameKey = nameKey;
        }
    }
}

