/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.common.Coded;

@XmlRootElement(name="actionType")
@XmlType(name="ActionTypeType")
@XmlEnum
public enum ActionType implements Coded
{
    SU_ACKNOWLEDGE("k", "SUPER USER ACKNOWLEDGE"),
    SU_FYI("f", "SUPER USER FYI"),
    SU_COMPLETE("m", "SUPER USER COMPLETE"),
    SU_APPROVE("v", "SUPER USER APPROVE"),
    SU_ROUTE_NODE_APPROVE("r", "SUPER USER ROUTE NODE APPROVE"),
    SU_RETURN_TO_PREVIOUS("z", "SUPER USER RETURN TO PREVIOUS"),
    SU_DISAPPROVE("d", "SUPER USER DISAPPROVE"),
    SU_CANCEL("c", "SUPER USER CANCEL"),
    SU_BLANKET_APPROVE("a", "SUPER USER BLANKET APPROVE"),
    BLANKET_APPROVE("B", "BLANKET APPROVE"),
    FYI("F", "FYI"),
    ADHOC_REQUEST("H", "ADHOC REQUEST"),
    ADHOC_REQUEST_REVOKE("V", "ADHOC REQUEST_REVOKE"),
    SAVE("S", "SAVED"),
    CANCEL("X", "CANCEL"),
    DISAPPROVE("D", "DISAPPROVE"),
    ACKNOWLEDGE("K", "ACKNOWLEDGE"),
    COMPLETE("C", "COMPLETE"),
    ROUTE("O", "ROUTE"),
    APPROVE("A", "APPROVE"),
    RETURN_TO_PREVIOUS("Z", "RETURN TO PREVIOUS"),
    RECALL("L", "RECALL"),
    LOG_MESSAGE("R", "LOG MESSAGE"),
    TAKE_GROUP_AUTHORITY("w", "TAKE GROUP AUTHORITY"),
    RELEASE_GROUP_AUTHORITY("y", "RELEASE GROUP AUTHORITY"),
    MOVE("M", "MOVED");

    private static final Map<ActionType, ActionType> SU_ACTION_TYPE;
    private final String code;
    private final String label;

    private ActionType(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public static ActionType fromCode(String code) {
        return ActionType.fromCode(code, false);
    }

    public static ActionType fromCode(String code, boolean allowMissing) {
        if (code == null) {
            return null;
        }
        for (ActionType status : ActionType.values()) {
            if (!status.code.equals(code)) continue;
            return status;
        }
        if (allowMissing) {
            return null;
        }
        throw new IllegalArgumentException("Failed to locate the ActionType with the given code: " + code);
    }

    public static ActionType fromLabel(String label) {
        if (label == null) {
            return null;
        }
        for (ActionType status : ActionType.values()) {
            if (!status.label.equals(label)) continue;
            return status;
        }
        return null;
    }

    public static ActionType fromCodeOrLabel(String str) {
        ActionType at = ActionType.fromCode(str, true);
        if (at == null && str != null) {
            at = ActionType.fromLabel(str.toUpperCase());
        }
        return at;
    }

    public static ActionType toSuperUserActionType(ActionType at) {
        if (SU_ACTION_TYPE.containsKey((Object)at)) {
            return at;
        }
        return SU_ACTION_TYPE.get((Object)at);
    }

    static {
        SU_ACTION_TYPE = new HashMap<ActionType, ActionType>();
        SU_ACTION_TYPE.put(APPROVE, SU_APPROVE);
        SU_ACTION_TYPE.put(COMPLETE, SU_COMPLETE);
        SU_ACTION_TYPE.put(FYI, SU_FYI);
        SU_ACTION_TYPE.put(ACKNOWLEDGE, SU_ACKNOWLEDGE);
    }
}

