/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.exception.IntrospectionException;
import org.kuali.rice.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.rice.krad.exception.ReferenceAttributeDoesntExistException;
import org.kuali.rice.krad.exception.ReferenceAttributeNotAnOjbReferenceException;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.impl.PersistenceServiceImplBase;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Transactional
@LegacyDataFramework
public class PersistenceServiceOjbImpl
extends PersistenceServiceImplBase
implements PersistenceService {
    private static Logger LOG = Logger.getLogger(PersistenceServiceOjbImpl.class);
    private static final String CLASSPATH_RESOURCE_PREFIX = "classpath:";
    private PersistenceDao persistenceDao;

    @Override
    public void clearCache() {
        this.persistenceDao.clearCache();
    }

    @Override
    public Object resolveProxy(Object o) {
        return this.persistenceDao.resolveProxy(o);
    }

    @Override
    public void loadRepositoryDescriptor(String ojbRepositoryFilePath) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Begin loading OJB Metadata for: " + ojbRepositoryFilePath));
        }
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        InputStream is = null;
        try {
            is = resourceLoader.getResource(CLASSPATH_RESOURCE_PREFIX + ojbRepositoryFilePath).getInputStream();
            ConnectionRepository cr = MetadataManager.getInstance().readConnectionRepository(is);
            MetadataManager.getInstance().mergeConnectionRepository(cr);
            is = resourceLoader.getResource(CLASSPATH_RESOURCE_PREFIX + ojbRepositoryFilePath).getInputStream();
            DescriptorRepository dr = MetadataManager.getInstance().readDescriptorRepository(is);
            MetadataManager.getInstance().mergeDescriptorRepository(dr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"--------------------------------------------------------------------------");
                LOG.debug((Object)("Merging repository descriptor: " + ojbRepositoryFilePath));
                LOG.debug((Object)"--------------------------------------------------------------------------");
            }
        }
        catch (IOException ioe) {
            throw new RiceRuntimeException((Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to close InputStream on OJB repository path " + ojbRepositoryFilePath), (Throwable)e);
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Finished loading OJB Metadata for: " + ojbRepositoryFilePath));
        }
    }

    @Override
    public void retrieveNonKeyFields(Object persistableObject) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieving non-key fields for " + persistableObject));
        }
        this.persistenceDao.retrieveAllReferences(persistableObject);
    }

    @Override
    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieving reference object " + referenceObjectName + " for " + persistableObject));
        }
        this.persistenceDao.retrieveReference(persistableObject, referenceObjectName);
    }

    @Override
    public void retrieveReferenceObjects(Object persistableObject, List referenceObjectNames) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        if (referenceObjectNames == null) {
            throw new IllegalArgumentException("invalid (null) referenceObjectNames");
        }
        if (referenceObjectNames.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) referenceObjectNames");
        }
        int index = 0;
        for (String referenceObjectName : referenceObjectNames) {
            if (StringUtils.isBlank((String)referenceObjectName)) {
                throw new IllegalArgumentException("invalid (blank) name at position " + index);
            }
            this.retrieveReferenceObject(persistableObject, referenceObjectName);
            ++index;
        }
    }

    @Override
    public void retrieveReferenceObjects(List persistableObjects, List referenceObjectNames) {
        if (persistableObjects == null) {
            throw new IllegalArgumentException("invalid (null) persistableObjects");
        }
        if (persistableObjects.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) persistableObjects");
        }
        if (referenceObjectNames == null) {
            throw new IllegalArgumentException("invalid (null) referenceObjectNames");
        }
        if (referenceObjectNames.isEmpty()) {
            throw new IllegalArgumentException("invalid (empty) referenceObjectNames");
        }
        for (Object persistableObject : persistableObjects) {
            this.retrieveReferenceObjects(persistableObject, referenceObjectNames);
        }
    }

    @Override
    public String getFlattenedPrimaryKeyFieldValues(Object persistableObject) {
        if (persistableObject == null) {
            throw new IllegalArgumentException("invalid (null) persistableObject");
        }
        Map primaryKeyValues = this.getPrimaryKeyFieldValues(persistableObject, true);
        StringBuffer flattened = new StringBuffer(persistableObject.getClass().getName());
        flattened.append("(");
        Iterator i = primaryKeyValues.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String fieldName = (String)e.getKey();
            Object fieldValue = e.getValue();
            flattened.append(fieldName + "=" + fieldValue);
            if (!i.hasNext()) continue;
            flattened.append(",");
        }
        flattened.append(")");
        return flattened.toString();
    }

    private void linkObjectsWithCircularReferenceCheck(Object persistableObject, Set referenceSet) {
        if (ObjectUtils.isNull(persistableObject) || referenceSet.contains(persistableObject)) {
            return;
        }
        referenceSet.add(persistableObject);
        ClassDescriptor classDescriptor = this.getClassDescriptor(persistableObject.getClass());
        String className = null;
        String fieldName = null;
        try {
            Vector objectReferences = classDescriptor.getObjectReferenceDescriptors();
            for (ObjectReferenceDescriptor referenceDescriptor : objectReferences) {
                int i;
                className = persistableObject.getClass().getName();
                fieldName = referenceDescriptor.getAttributeName();
                Object referenceObject = PropertyUtils.getProperty((Object)persistableObject, (String)fieldName);
                if (ObjectUtils.isNull(referenceObject) || referenceSet.contains(referenceObject)) continue;
                this.linkObjectsWithCircularReferenceCheck(referenceObject, referenceSet);
                FieldDescriptor[] refFkNames = referenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
                ClassDescriptor refCld = this.getClassDescriptor(referenceDescriptor.getItemClass());
                FieldDescriptor[] refPkNames = refCld.getPkFields();
                HashMap<String, Object> objFkValues = new HashMap<String, Object>();
                for (i = 0; i < refPkNames.length; ++i) {
                    objFkValues.put(refFkNames[i].getAttributeName(), ObjectUtils.getPropertyValue(referenceObject, refPkNames[i].getAttributeName()));
                }
                for (i = 0; i < refFkNames.length; ++i) {
                    Object mainFkValue;
                    FieldDescriptor fkField = refFkNames[i];
                    String fkName = fkField.getAttributeName();
                    Object fkValue = null;
                    if (objFkValues.containsKey(fkName)) {
                        fkValue = objFkValues.get(fkName);
                    }
                    if (ObjectUtils.isNotNull(mainFkValue = ObjectUtils.getPropertyValue(persistableObject, fkName)) && StringUtils.isNotBlank((String)mainFkValue.toString())) {
                        fkValue = mainFkValue;
                    } else if (ObjectUtils.isNull(fkValue) || StringUtils.isBlank((String)fkValue.toString())) {
                        ObjectReferenceDescriptor checkDescriptor;
                        Iterator iter2 = objectReferences.iterator();
                        while (!(!iter2.hasNext() || ObjectUtils.isNotNull(fkValue = this.getReferenceFKValue(persistableObject, checkDescriptor = (ObjectReferenceDescriptor)iter2.next(), fkName)) && StringUtils.isNotBlank((String)fkValue.toString()))) {
                        }
                    }
                    if (!ObjectUtils.isNotNull(fkValue)) continue;
                    fieldName = refPkNames[i].getAttributeName();
                    ObjectUtils.setObjectProperty(referenceObject, fieldName, fkValue.getClass(), fkValue);
                    if (!ObjectUtils.isNull(mainFkValue)) continue;
                    ObjectUtils.setObjectProperty(persistableObject, fkName, fkValue.getClass(), fkValue);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IntrospectionException("no setter for property '" + className + "." + fieldName + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionException("problem accessing property '" + className + "." + fieldName + "'", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionException("problem invoking getter for property '" + className + "." + fieldName + "'", (Throwable)e);
        }
    }

    @Override
    public void linkObjects(Object persistableObject) {
        this.linkObjectsWithCircularReferenceCheck(persistableObject, new HashSet());
    }

    @Override
    public boolean allForeignKeyValuesPopulatedForReference(PersistableBusinessObject bo, String referenceName) {
        boolean allFkeysHaveValues = true;
        if (bo == null) {
            throw new IllegalArgumentException("The Class passed in for the BusinessObject argument was null.");
        }
        if (StringUtils.isBlank((String)referenceName)) {
            throw new IllegalArgumentException("The String passed in for the referenceName argument was null or empty.");
        }
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bo, (String)referenceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + referenceName + "' does not exist " + "on class: '" + bo.getClass().getName() + "'.");
        }
        Class<PersistableBusinessObjectExtension> referenceClass = this.getBusinessObjectAttributeClass(bo.getClass(), referenceName);
        if (referenceClass == null) {
            referenceClass = propertyDescriptor.getPropertyType();
        }
        if (!PersistableBusinessObject.class.isAssignableFrom(referenceClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + referenceName + ") is of class: " + "'" + referenceClass.getName() + "' and is not a " + "descendent of BusinessObject.  Only descendents of BusinessObject " + "can be used.");
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(bo.getClass());
        ObjectReferenceDescriptor referenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(referenceName);
        if (referenceDescriptor == null) {
            throw new ReferenceAttributeNotAnOjbReferenceException("Attribute requested (" + referenceName + ") is not listed " + "in OJB as a reference-descriptor for class: '" + bo.getClass().getName() + "'");
        }
        Vector fkFields = referenceDescriptor.getForeignKeyFields();
        for (String fkFieldName : fkFields) {
            Object fkFieldValue = null;
            try {
                fkFieldValue = PropertyUtils.getSimpleProperty((Object)bo, (String)fkFieldName);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (fkFieldValue == null) {
                return false;
            }
            if (!String.class.isAssignableFrom(fkFieldValue.getClass()) || !StringUtils.isBlank((String)((String)fkFieldValue))) continue;
            return false;
        }
        return allFkeysHaveValues;
    }

    @Override
    public void refreshAllNonUpdatingReferences(PersistableBusinessObject bo) {
        ClassDescriptor classDescriptor = this.getClassDescriptor(bo.getClass());
        Vector references = classDescriptor.getObjectReferenceDescriptors();
        for (ObjectReferenceDescriptor reference : references) {
            if (reference.getCascadingStore() != 17) continue;
            PersistentField persistentField = reference.getPersistentField();
            String referenceName = persistentField.getName();
            this.retrieveReferenceObject(bo, referenceName);
        }
    }

    private Object getReferenceFKValue(Object persistableObject, ObjectReferenceDescriptor chkRefCld, String fkName) {
        ClassDescriptor classDescriptor = this.getClassDescriptor(persistableObject.getClass());
        Object referenceObject = ObjectUtils.getPropertyValue(persistableObject, chkRefCld.getAttributeName());
        if (referenceObject == null) {
            return null;
        }
        FieldDescriptor[] refFkNames = chkRefCld.getForeignKeyFieldDescriptors(classDescriptor);
        ClassDescriptor refCld = this.getClassDescriptor(chkRefCld.getItemClass());
        FieldDescriptor[] refPkNames = refCld.getPkFields();
        Object fkValue = null;
        for (int i = 0; i < refFkNames.length; ++i) {
            FieldDescriptor fkField = refFkNames[i];
            if (!fkField.getAttributeName().equals(fkName)) continue;
            fkValue = ObjectUtils.getPropertyValue(referenceObject, refPkNames[i].getAttributeName());
            break;
        }
        return fkValue;
    }

    @Override
    public boolean isProxied(Object object) {
        return this.persistenceDao.isProxied(object);
    }

    public void setPersistenceDao(PersistenceDao persistenceDao) {
        this.persistenceDao = persistenceDao;
    }
}

