/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="whenConstraint", parent="WhenConstraint")
public class WhenConstraint
implements Constraint {
    protected List<Object> values;
    protected String valuePath;
    protected Constraint constraint;

    @BeanTagAttribute
    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public Object getValue() {
        if (this.values != null && !this.values.isEmpty()) {
            return this.values.get(0);
        }
        return null;
    }

    public void setValue(Object value) {
        this.values = new ArrayList<Object>();
        this.values.add(value);
    }

    @BeanTagAttribute(name="valuePath")
    public String getValuePath() {
        return this.valuePath;
    }

    public void setValuePath(String valuePath) {
        this.valuePath = valuePath;
    }

    @BeanTagAttribute(name="constraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean("WhenConstraint", "NOBEANID");
        if (this.getConstraint() == null) {
            currentValues = new String[]{"constraint = " + this.getConstraint()};
            tracer.createWarning("Constraint must be set", currentValues);
        }
        if (this.getValuePath() == null || this.getValues() == null) {
            currentValues = new String[]{"valuePath = " + this.getValuePath(), "values = " + this.getValues()};
            tracer.createWarning("Value Path or Values must be set", currentValues);
        }
    }
}

