/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validator;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

public class ErrorReport {
    private static final Log LOG = LogFactory.getLog(ErrorReport.class);
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private static final String endl = System.getProperty("line.separator");
    private int errorStatus;
    private String validationFailed;
    private String beanLocation;
    private ArrayList<String> currentValues;
    private ArrayList<String> xmlPages;

    public ErrorReport(int ErrorStatus) {
        this.errorStatus = ErrorStatus;
        this.validationFailed = "";
        this.beanLocation = "";
        this.currentValues = new ArrayList();
        this.xmlPages = new ArrayList();
    }

    public ErrorReport(int errorStatus, String validationFailed, String beanLocation, String[] values) {
        this.errorStatus = errorStatus;
        this.validationFailed = validationFailed;
        this.beanLocation = beanLocation;
        this.currentValues = new ArrayList();
        this.xmlPages = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            this.addCurrentValue(values[i]);
        }
    }

    public ErrorReport(int errorStatus, String validationFailed, ValidationTrace trace) {
        this.errorStatus = errorStatus;
        this.validationFailed = validationFailed;
        this.xmlPages = trace.getRelatedXmls();
        this.beanLocation = trace.getBeanLocation();
        this.currentValues = new ArrayList();
    }

    public ErrorReport(int errorStatus, String validationFailed, ValidationTrace trace, String[] values) {
        this.errorStatus = errorStatus;
        this.validationFailed = validationFailed;
        this.beanLocation = trace.getBeanLocation();
        this.xmlPages = trace.getRelatedXmls();
        this.currentValues = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            this.addCurrentValue(values[i]);
        }
    }

    public ErrorReport(int errorStatus, String validationFailed, String beanLocation) {
        this.errorStatus = errorStatus;
        this.validationFailed = validationFailed;
        this.beanLocation = beanLocation;
        this.currentValues = new ArrayList();
        this.xmlPages = new ArrayList();
    }

    public static ErrorReport createError(String validationFailed, ValidationTrace trace) {
        return new ErrorReport(1, validationFailed, trace);
    }

    public static ErrorReport createWarning(String validationFailed, ValidationTrace trace) {
        return new ErrorReport(2, validationFailed, trace);
    }

    public void addCurrentValue(String value) {
        this.currentValues.add(value);
    }

    public void addXmlPage(String page) {
        this.xmlPages.add(page);
    }

    public void addXmlPages(ArrayList<String> pages) {
        this.xmlPages.addAll(pages);
    }

    public void removeCurrentValue(int index) {
        this.currentValues.remove(index);
    }

    public void removeXmlPage(int index) {
        this.xmlPages.remove(index);
    }

    public void modifyCurrentValue(int index, String value) {
        this.currentValues.set(index, value);
    }

    public void modifyXmlPage(int index, String page) {
        this.xmlPages.set(index, page);
    }

    public String errorMessage() {
        String message = "";
        if (this.errorStatus == 1) {
            message = message + "Dictionary Error Detected: " + this.getValidationFailed() + endl;
        } else if (this.errorStatus == 2) {
            message = message + "Dictionary Warning Detected: " + this.getValidationFailed() + endl;
        }
        message = message + "Bean: " + this.getBeanLocation() + endl;
        message = message + "Values involved:" + endl;
        for (int i = 0; i < this.getCurrentValueSize(); ++i) {
            message = message + this.getCurrentValue(i) + endl;
        }
        return message;
    }

    public String errorPageList() {
        String pages = "Xml Pages Involved" + endl;
        for (int i = 0; i < this.getXmlPageSize(); ++i) {
            pages = pages + this.getXmlPage(i) + endl;
        }
        return pages;
    }

    public void setValidationFailed(String validation) {
        this.validationFailed = validation;
    }

    public void setBeanLocation(String location) {
        this.beanLocation = location;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public String getValidationFailed() {
        return this.validationFailed;
    }

    public String getBeanLocation() {
        return this.beanLocation;
    }

    public String getCurrentValue(int index) {
        return this.currentValues.get(index);
    }

    public String getXmlPage(int index) {
        return this.xmlPages.get(index);
    }

    public int getCurrentValueSize() {
        return this.currentValues.size();
    }

    public int getXmlPageSize() {
        return this.xmlPages.size();
    }

    public boolean isError() {
        return this.errorStatus == 1;
    }

    public boolean isWarning() {
        return this.errorStatus == 2;
    }
}

