/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.container.TabNavigationGroup;
import org.kuali.rice.krad.uif.element.BreadcrumbItem;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.PageBreadcrumbOptions;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="page", parent="Uif-Page"), @BeanTag(name="documentPage", parent="Uif-DocumentPage"), @BeanTag(name="inquiryPage", parent="Uif-InquiryPage"), @BeanTag(name="maintenancePage", parent="Uif-MaintenancePage")})
public class PageGroupBase
extends GroupBase
implements PageGroup {
    private static final long serialVersionUID = 7571981300587270274L;
    private boolean autoFocus = false;
    private PageBreadcrumbOptions breadcrumbOptions;
    private BreadcrumbItem breadcrumbItem;
    private boolean stickyFooter;
    private String formPostUrl;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        for (Component component : this.getItems()) {
            if (component == null || !(component instanceof PageGroup)) continue;
            throw new RuntimeException("The page with id='" + this.getId() + "' contains a page with id='" + component.getId() + "'.  Nesting a page within a page is not allowed since only one " + "page's content can be shown on the View " + "at a time.  This may have been caused by possible misuse of the singlePageView flag (when " + "this flag is true, items set on the View become items of the single page.  Instead use " + "the page property on the View to set the page being used).");
        }
        this.breadcrumbOptions.setupBreadcrumbs(model);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        View view;
        if (StringUtils.isBlank((String)this.getWrapperTag())) {
            this.setWrapperTag("main");
        }
        super.performFinalize(model, parent);
        UifFormBase formBase = (UifFormBase)model;
        if (this.isAutoFocus() && StringUtils.isNotBlank((String)formBase.getFocusId())) {
            this.addDataAttribute("focusId", formBase.getFocusId());
        } else if (this.isAutoFocus()) {
            this.addDataAttribute("focusId", UifConstants.Order.FIRST.name());
        }
        if (StringUtils.isNotBlank((String)formBase.getJumpToId())) {
            this.addDataAttribute("jumpToId", formBase.getJumpToId());
        }
        if (StringUtils.isNotBlank((String)formBase.getJumpToName())) {
            this.addDataAttribute("jumpToName", formBase.getJumpToName());
        }
        this.addDataAttribute("role", "Page");
        String prefixScript = "";
        if (this.getOnDocumentReadyScript() != null) {
            prefixScript = this.getOnDocumentReadyScript();
        }
        if ((view = ViewLifecycle.getView()) instanceof FormView && ((FormView)view).isValidateClientSide()) {
            this.setOnDocumentReadyScript(prefixScript + "\nsetupPage(true);");
        } else {
            this.setOnDocumentReadyScript(prefixScript + "\nsetupPage(false);");
        }
        this.breadcrumbOptions.finalizeBreadcrumbs(model, this, this.breadcrumbItem);
    }

    @Override
    public List<String> getAdditionalTemplates() {
        List<String> additionalTemplates = super.getAdditionalTemplates();
        Header viewHeader = ViewLifecycle.getView().getHeader();
        if (viewHeader != null) {
            if (additionalTemplates.isEmpty()) {
                additionalTemplates = new ArrayList<String>();
            }
            additionalTemplates.add(viewHeader.getTemplate());
        }
        return additionalTemplates;
    }

    @Override
    @BeanTagAttribute(name="autoFocus")
    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    @Override
    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    @Override
    @BeanTagAttribute
    public PageBreadcrumbOptions getBreadcrumbOptions() {
        return this.breadcrumbOptions;
    }

    @Override
    public void setBreadcrumbOptions(PageBreadcrumbOptions breadcrumbOptions) {
        this.breadcrumbOptions = breadcrumbOptions;
    }

    @Override
    public List<BreadcrumbItem> getHomewardPathBreadcrumbs() {
        return this.breadcrumbOptions == null ? null : this.breadcrumbOptions.getHomewardPathBreadcrumbs();
    }

    @Override
    public List<BreadcrumbItem> getPreViewBreadcrumbs() {
        return this.breadcrumbOptions == null ? null : this.breadcrumbOptions.getPreViewBreadcrumbs();
    }

    @Override
    public List<BreadcrumbItem> getPrePageBreadcrumbs() {
        return this.breadcrumbOptions == null ? null : this.breadcrumbOptions.getPrePageBreadcrumbs();
    }

    @Override
    public List<BreadcrumbItem> getBreadcrumbOverrides() {
        return this.breadcrumbOptions == null ? null : this.breadcrumbOptions.getBreadcrumbOverrides();
    }

    @Override
    @BeanTagAttribute
    public BreadcrumbItem getBreadcrumbItem() {
        return this.breadcrumbItem;
    }

    @Override
    public void setBreadcrumbItem(BreadcrumbItem breadcrumbItem) {
        this.breadcrumbItem = breadcrumbItem;
    }

    @Override
    @BeanTagAttribute
    public boolean isStickyFooter() {
        return this.stickyFooter;
    }

    @Override
    public void setStickyFooter(boolean stickyFooter) {
        this.stickyFooter = stickyFooter;
        if (this.getFooter() != null) {
            this.getFooter().addDataAttribute("sticky_footer", Boolean.toString(stickyFooter));
        }
    }

    @Override
    @BeanTagAttribute
    public String getFormPostUrl() {
        return this.formPostUrl;
    }

    @Override
    public void setFormPostUrl(String formPostUrl) {
        this.formPostUrl = formPostUrl;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!PageGroup.class.isAssignableFrom(this.getItems().get(i).getClass()) && !TabNavigationGroup.class.isAssignableFrom(this.getItems().get(i).getClass())) continue;
            String[] currentValues = new String[]{"item(" + i + ").class =" + this.getItems().get(i).getClass()};
            tracer.createError("Items in PageGroup cannot be PageGroup or NaviagtionGroup", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

