/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControlPostData;
import org.kuali.rice.krad.uif.control.TextControlBase;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.widget.QuickFinder;

@BeanTag(name="kimPersonControl", parent="Uif-KimPersonControl")
public class UserControl
extends TextControlBase
implements FilterableLookupCriteriaControl {
    private static final long serialVersionUID = 7468340793076585869L;
    private String principalIdPropertyName;
    private String personNamePropertyName;
    private String personObjectPropertyName;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (!(parent instanceof InputField)) {
            return;
        }
        InputField field = (InputField)parent;
        field.getAdditionalHiddenPropertyNames().add(this.principalIdPropertyName);
        if (this.isRender() && !this.isHidden() && !Boolean.TRUE.equals(this.getReadOnly())) {
            ViewLifecycle.getViewPostMetadata().addAccessibleBindingPath(this.principalIdPropertyName);
        }
        if (!Boolean.TRUE.equals(field.getReadOnly())) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.getPropertyNamesForAdditionalDisplay().add(this.personNamePropertyName);
            } else {
                field.getPropertyNamesForAdditionalDisplay().add(this.personObjectPropertyName + "." + "name");
            }
            String idPropertyPath = field.getBindingInfo().getPropertyAdjustedBindingPath(this.principalIdPropertyName);
            String onChangeScript = "setValue('" + ScriptUtils.escapeName(idPropertyPath) + "','');";
            if (StringUtils.isNotBlank((String)this.getOnChangeScript())) {
                onChangeScript = this.getOnChangeScript() + onChangeScript;
            }
            this.setOnChangeScript(onChangeScript);
        }
        if (Boolean.TRUE.equals(field.getReadOnly()) && StringUtils.isBlank((String)field.getReadOnlyDisplaySuffixPropertyName())) {
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                field.setReadOnlyDisplaySuffixPropertyName(this.personNamePropertyName);
            } else {
                field.setReadOnlyDisplaySuffixPropertyName(this.personObjectPropertyName + "." + "name");
            }
        }
        AttributeQuery attributeQuery = new AttributeQuery();
        MethodInvokerConfig methodInvokerConfig = new MethodInvokerConfig();
        PersonService personService = KimApiServiceLocator.getPersonService();
        methodInvokerConfig.setTargetObject(personService);
        attributeQuery.setQueryMethodInvokerConfig(methodInvokerConfig);
        attributeQuery.setQueryMethodToCall("getPersonByPrincipalName");
        attributeQuery.getQueryMethodArgumentFieldList().add(field.getPropertyName());
        attributeQuery.getReturnFieldMapping().put("principalId", this.principalIdPropertyName);
        if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
            attributeQuery.getReturnFieldMapping().put("name", this.personNamePropertyName);
        } else {
            attributeQuery.getReturnFieldMapping().put("name", this.personObjectPropertyName + "." + "name");
        }
        field.setAttributeQuery(attributeQuery);
        this.buildUserQuickfinder(model, field);
    }

    @Override
    public Map<String, String> filterSearchCriteria(String propertyName, Map<String, String> searchCriteria, FilterableLookupCriteriaControlPostData postData) {
        HashMap<String, String> filteredSearchCriteria = new HashMap<String, String>(searchCriteria);
        UserControlPostData userControlPostData = (UserControlPostData)postData;
        String principalName = searchCriteria.get(propertyName);
        if (StringUtils.isNotBlank((String)principalName)) {
            if (!StringUtils.contains((String)principalName, (String)"*")) {
                Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName);
                if (principal == null) {
                    return null;
                }
                filteredSearchCriteria.put(userControlPostData.getPrincipalIdPropertyName(), principal.getPrincipalId());
            } else {
                List people = KimApiServiceLocator.getPersonService().findPeople(Collections.singletonMap("principalName", principalName));
                if (people != null && people.size() == 0) {
                    return null;
                }
            }
        }
        if (!StringUtils.contains((String)principalName, (String)"*")) {
            filteredSearchCriteria.remove(propertyName);
            filteredSearchCriteria.remove(userControlPostData.getPersonNamePropertyName());
        }
        return filteredSearchCriteria;
    }

    protected void buildUserQuickfinder(Object model, InputField field) {
        QuickFinder quickFinder = field.getQuickfinder();
        if (!field.isEnableAutoQuickfinder()) {
            return;
        }
        if (quickFinder == null) {
            quickFinder = ComponentFactory.getQuickFinder();
            field.setQuickfinder(quickFinder);
        }
        if (StringUtils.isBlank((String)quickFinder.getDataObjectClassName())) {
            quickFinder.setDataObjectClassName(Person.class.getName());
        }
        if (quickFinder.getFieldConversions().isEmpty()) {
            quickFinder.getFieldConversions().put("principalId", this.principalIdPropertyName);
            if (StringUtils.isNotBlank((String)this.personNamePropertyName)) {
                quickFinder.getFieldConversions().put("name", this.personNamePropertyName);
            } else {
                quickFinder.getFieldConversions().put("name", this.personObjectPropertyName + "." + "name");
            }
            quickFinder.getFieldConversions().put("principalName", field.getPropertyName());
        }
    }

    @BeanTagAttribute
    public String getPrincipalIdPropertyName() {
        return this.principalIdPropertyName;
    }

    public void setPrincipalIdPropertyName(String principalIdPropertyName) {
        this.principalIdPropertyName = principalIdPropertyName;
    }

    @BeanTagAttribute
    public String getPersonNamePropertyName() {
        return this.personNamePropertyName;
    }

    public void setPersonNamePropertyName(String personNamePropertyName) {
        this.personNamePropertyName = personNamePropertyName;
    }

    @BeanTagAttribute
    public String getPersonObjectPropertyName() {
        return this.personObjectPropertyName;
    }

    public void setPersonObjectPropertyName(String personObjectPropertyName) {
        this.personObjectPropertyName = personObjectPropertyName;
    }

    @Override
    public UserControlPostData getPostData(String propertyName) {
        return new UserControlPostData(propertyName, this);
    }

    public static class UserControlPostData
    implements FilterableLookupCriteriaControlPostData,
    Serializable {
        private static final long serialVersionUID = 3895010942559014164L;
        private String propertyName;
        private String principalIdPropertyName;
        private String personNamePropertyName;
        private String personObjectPropertyName;

        public UserControlPostData(String propertyName, UserControl userControl) {
            this.propertyName = propertyName;
            this.principalIdPropertyName = userControl.getPrincipalIdPropertyName();
            this.personNamePropertyName = userControl.getPersonNamePropertyName();
            this.personObjectPropertyName = userControl.getPersonObjectPropertyName();
        }

        @Override
        public Class<? extends FilterableLookupCriteriaControl> getControlClass() {
            return UserControl.class;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPrincipalIdPropertyName() {
            return this.principalIdPropertyName;
        }

        public String getPersonNamePropertyName() {
            return this.personNamePropertyName;
        }

        public String getPersonObjectPropertyName() {
            return this.personObjectPropertyName;
        }
    }
}

