/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.util.UrlFactory;

@BeanTag(name="userLinkField", parent="Uif-UserLinkField")
public class UserLinkField
extends LinkField {
    private static final long serialVersionUID = -6328858502087834L;
    private static final Logger LOG = Logger.getLogger(UserLinkField.class);
    private String principalId;
    private String principalName;
    private String dataObjectClassName;
    private String baseInquiryUrl;
    private boolean disableLink;
    private Map<String, String> additionalInquiryParameters;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isNotBlank((String)this.principalId)) {
            this.setHref(this.buildInquiryUrl());
            this.setLinkText(this.getPersonNameByPrincipalId(this.principalId));
        } else if (StringUtils.isNotBlank((String)this.principalName)) {
            this.setHref(this.buildInquiryUrl());
            this.setLinkText(this.getPersonNameByPrincipalName(this.principalName));
        }
        if (StringUtils.isBlank((String)this.getHref())) {
            this.setDisableLink(true);
        }
        if (StringUtils.isBlank((String)this.getLinkText())) {
            this.setLinkText("&nbsp;");
        }
    }

    protected String buildInquiryUrl() {
        Class<?> inquiryObjectClass;
        try {
            inquiryObjectClass = Class.forName(this.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Unable to get class for: " + this.getDataObjectClassName()));
            throw new RuntimeException(e);
        }
        Properties urlParameters = new Properties();
        urlParameters.setProperty("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.setProperty("methodToCall", "start");
        if (StringUtils.isNotBlank((String)this.principalId)) {
            urlParameters.setProperty("principalId", this.principalId);
        } else if (StringUtils.isNotBlank((String)this.principalName)) {
            urlParameters.setProperty("principalName", this.principalName);
        }
        for (Map.Entry<String, String> inquiryParameter : this.additionalInquiryParameters.entrySet()) {
            urlParameters.setProperty(inquiryParameter.getKey(), inquiryParameter.getValue());
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
        String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl((String)this.getBaseInquiryUrl(), (Properties)urlParameters);
        return inquiryUrl;
    }

    protected String getPersonNameByPrincipalId(String principalId) {
        Person person = KimApiServiceLocator.getPersonService().getPerson(principalId);
        if (person == null) {
            this.setDisableLink(true);
            return principalId;
        }
        return person.getName();
    }

    protected String getPersonNameByPrincipalName(String principalName) {
        Person person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName);
        if (person == null) {
            this.setDisableLink(true);
            return principalName;
        }
        return person.getName();
    }

    @BeanTagAttribute
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    @BeanTagAttribute
    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @BeanTagAttribute
    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute
    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    @BeanTagAttribute
    public boolean isDisableLink() {
        return this.disableLink;
    }

    public void setDisableLink(boolean disableLink) {
        this.disableLink = disableLink;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalInquiryParameters() {
        return this.additionalInquiryParameters;
    }

    public void setAdditionalInquiryParameters(Map<String, String> additionalInquiryParameters) {
        this.additionalInquiryParameters = additionalInquiryParameters;
    }
}

