/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.framework.util.ReflectionUtils;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.collections.LineBuilderContext;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.layout.CollectionLayoutUtils;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.layout.collections.CollectionLayoutManagerBase;
import org.kuali.rice.krad.uif.layout.collections.CollectionPagingHelper;
import org.kuali.rice.krad.uif.layout.collections.DataTablesPagingHelper;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ColumnCalculationInfo;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTag(name="tableCollectionLayout-bean", parent="Uif-TableCollectionLayout")
public class TableLayoutManagerBase
extends CollectionLayoutManagerBase
implements TableLayoutManager {
    private static final long serialVersionUID = 3622267585541524208L;
    private int numberOfColumns;
    private boolean suppressLineWrapping;
    private Boolean autoTruncateColumns;
    private boolean applyAlternatingRowStyles;
    private boolean applyDefaultCellWidths;
    private List<String> rowCssClasses = new ArrayList<String>();
    private List<String> rowDataAttributes = new ArrayList<String>();
    private boolean useShortLabels = false;
    private boolean repeatHeader = false;
    private Label headerLabelPrototype;
    private boolean renderSequenceField = true;
    private boolean generateAutoSequence = false;
    private org.kuali.rice.krad.uif.field.Field sequenceFieldPrototype;
    private FieldGroup actionFieldPrototype;
    private boolean separateAddLine = false;
    private int numberOfDataColumns;
    private List<Label> headerLabels = new ArrayList<Label>();
    private List<org.kuali.rice.krad.uif.field.Field> allRowFields = new ArrayList<org.kuali.rice.krad.uif.field.Field>();
    private List<org.kuali.rice.krad.uif.field.Field> firstRowFields = new ArrayList<org.kuali.rice.krad.uif.field.Field>();
    private RichTable richTable;
    private boolean headerAdded;
    private int actionColumnIndex = -1;
    private String actionColumnPlacement;
    private Group rowDetailsGroup;
    private boolean rowDetailsOpen = false;
    private boolean showToggleAllDetails;
    private Action toggleAllDetailsAction;
    private boolean ajaxDetailsRetrieval;
    private Action expandDetailsActionPrototype;
    @KeepExpression
    private String groupingTitle;
    private String groupingPrefix;
    private int groupingColumnIndex;
    private List<String> groupingPropertyNames;
    private boolean renderOnlyLeftTotalLabels;
    private boolean showTotal;
    private boolean showPageTotal;
    private boolean showGroupTotal;
    private boolean generateGroupTotalRows;
    private Label totalLabel;
    private Label pageTotalLabel;
    private Label groupTotalLabelPrototype;
    private List<String> columnsToCalculate = new ArrayList<String>();
    private List<ColumnCalculationInfo> columnCalculations = new ArrayList<ColumnCalculationInfo>();
    private List<Component> footerCalculationComponents;
    private Map<String, String> conditionalRowCssClasses = new HashMap<String, String>();

    @Override
    public void performInitialization(Object model) {
        CollectionGroup collectionGroup = (CollectionGroup)ViewLifecycle.getPhase().getElement();
        if (Boolean.TRUE.equals(collectionGroup.getReadOnly())) {
            this.getAddLineGroup().setReadOnly(true);
            this.actionFieldPrototype.setReadOnly(true);
        }
        this.setupDetails(collectionGroup);
        this.setupGrouping(model, collectionGroup);
        if (collectionGroup.isAddWithDialog()) {
            this.setSeparateAddLine(true);
        }
        super.performInitialization(model);
        this.getRowCssClasses().clear();
        if (this.generateAutoSequence && !(this.getSequenceFieldPrototype() instanceof MessageField)) {
            this.sequenceFieldPrototype = ComponentFactory.getMessageField();
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        for (ColumnCalculationInfo cInfo : this.columnCalculations) {
            ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(cInfo, false);
        }
        if (this.isAutoTruncateColumns() == null) {
            this.setAutoTruncateColumns(CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-KRAD", "All", "AUTO_TRUNCATE_COLUMNS", Boolean.valueOf(false)));
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        UifFormBase formBase = (UifFormBase)model;
        CollectionGroup collectionGroup = (CollectionGroup)ViewLifecycle.getPhase().getElement();
        int totalColumns = this.getNumberOfDataColumns();
        if (this.renderSequenceField) {
            ++totalColumns;
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            ++totalColumns;
        }
        if (collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly())) {
            ++totalColumns;
        }
        this.setNumberOfColumns(totalColumns);
        if (this.isApplyDefaultCellWidths() || Boolean.TRUE.equals(this.isAutoTruncateColumns())) {
            this.addStyleClass("uif-table-fixed");
        }
        if ("addLine".equals(formBase.getActionEvent())) {
            String highlightScript = "jQuery(\"#" + parent.getId() + " tr:first\").effect(\"highlight\",{}, 6000);";
            String onReadyScript = collectionGroup.getOnDocumentReadyScript();
            if (StringUtils.isNotBlank((String)onReadyScript)) {
                highlightScript = onReadyScript + highlightScript;
            }
            collectionGroup.setOnDocumentReadyScript(highlightScript);
        }
        if (this.columnCalculations != null && !this.columnCalculations.isEmpty() && this.richTable != null && this.getAllRowFields() != null && !this.getAllRowFields().isEmpty()) {
            this.setupColumnCalculations(model, collectionGroup, totalColumns);
        }
        if ((this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle())) && this.richTable != null) {
            this.richTable.setGroupingOptionsJSString("{iGroupingColumnIndex: " + this.groupingColumnIndex + ", bGenerateGroupTotalRows:" + this.generateGroupTotalRows + ", bSetGroupingClassOnTR: true" + ", sGroupingClass: 'uif-groupRow'" + (this.getGroupingPrefix() != null ? ", sGroupLabelPrefix: '" + this.getGroupingPrefix() + "'" : "") + "}");
        }
        if ((this.getRichTable() == null || !this.getRichTable().isRender()) && collectionGroup.isUseServerPaging() && this.getPagerWidget() != null) {
            CollectionLayoutUtils.setupPagerWidget(this.getPagerWidget(), collectionGroup, model);
        }
        this.setupEditDetails();
    }

    private void setupEditDetails() {
        List<FieldGroup> fieldGroups = ViewLifecycleUtils.getElementsOfTypeDeep(this.allRowFields, FieldGroup.class);
        for (FieldGroup fieldGroup : fieldGroups) {
            Group group = fieldGroup.getGroup();
            if (group == null) continue;
            List<DialogGroup> dialogGroups = ViewLifecycleUtils.getElementsOfTypeDeep(group.getItems(), DialogGroup.class);
            for (DialogGroup dialogGroup : dialogGroups) {
                List<FieldGroup> fieldGroupsList = ViewLifecycleUtils.getElementsOfTypeDeep(dialogGroup.getItems(), FieldGroup.class);
                for (FieldGroup fieldGroupItem : fieldGroupsList) {
                    Group group1 = fieldGroupItem.getGroup();
                    if (group1 == null || !(group1 instanceof CollectionGroup)) continue;
                    dialogGroup.setDialogCssClass("modal-lg");
                }
            }
        }
    }

    protected void setupGrouping(Object model, CollectionGroup collectionGroup) {
        String groupingTitleExpression = "";
        if (StringUtils.isNotBlank((String)this.getPropertyExpression("groupingTitle"))) {
            groupingTitleExpression = this.getPropertyExpression("groupingTitle");
            this.setGroupingTitle(this.getPropertyExpression("groupingTitle"));
        } else if (this.getGroupingPropertyNames() != null) {
            for (String propertyName : this.getGroupingPropertyNames()) {
                groupingTitleExpression = groupingTitleExpression + ", " + propertyName;
            }
            groupingTitleExpression = groupingTitleExpression.replaceFirst(", ", "@{#lp.");
            groupingTitleExpression = groupingTitleExpression.replace(", ", "}, @{#lp.");
            groupingTitleExpression = groupingTitleExpression.trim() + "}";
        }
        if (StringUtils.isNotBlank((String)groupingTitleExpression)) {
            MessageField groupingMessageField = ComponentFactory.getColGroupingField();
            groupingMessageField.getMessage().getPropertyExpressions().put("messageText", groupingTitleExpression);
            groupingMessageField.addDataAttribute("role", "RowGrouping");
            ArrayList<? extends Component> theItems = new ArrayList<Component>();
            theItems.add(groupingMessageField);
            theItems.addAll(collectionGroup.getItems());
            collectionGroup.setItems(theItems);
        }
    }

    protected void setupColumnCalculations(Object model, Container container, int totalColumns) {
        this.footerCalculationComponents = new ArrayList<Component>(totalColumns);
        for (int i = 0; i < totalColumns; ++i) {
            this.footerCalculationComponents.add(null);
        }
        int leftLabelColumnIndex = 0;
        if (this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle())) {
            leftLabelColumnIndex = 1;
        }
        for (ColumnCalculationInfo cInfo : this.columnCalculations) {
            if (StringUtils.isNotBlank((String)cInfo.getPropertyName())) {
                for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                    Component component = this.getAllRowFields().get(i);
                    if (component == null || !(component instanceof DataField) || !((DataField)component).getPropertyName().equals(cInfo.getPropertyName())) continue;
                    cInfo.setColumnNumber(i);
                }
            } else {
                throw new RuntimeException("TableLayoutManager(" + container.getId() + "->" + this.getId() + ") ColumnCalculationInfo MUST have a propertyName set");
            }
            this.getColumnsToCalculate().add(cInfo.getColumnNumber().toString());
            FieldGroup calculationFieldGroup = ComponentFactory.getFieldGroup();
            calculationFieldGroup.addDataAttribute("role", "totalsBlock");
            ArrayList<org.kuali.rice.krad.uif.field.Field> calculationFieldGroupItems = new ArrayList<org.kuali.rice.krad.uif.field.Field>();
            if (cInfo.isShowPageTotal()) {
                org.kuali.rice.krad.uif.field.Field pageTotalDataField = (org.kuali.rice.krad.uif.field.Field)CopyUtils.copy(cInfo.getPageTotalField());
                this.setupTotalField(pageTotalDataField, cInfo, this.isShowPageTotal(), this.getPageTotalLabel(), "pageTotal", leftLabelColumnIndex);
                calculationFieldGroupItems.add(pageTotalDataField);
            }
            if (cInfo.isShowTotal()) {
                org.kuali.rice.krad.uif.field.Field totalDataField = (org.kuali.rice.krad.uif.field.Field)CopyUtils.copy(cInfo.getTotalField());
                this.setupTotalField(totalDataField, cInfo, this.isShowTotal(), this.getTotalLabel(), "total", leftLabelColumnIndex);
                if (!cInfo.isRecalculateTotalClientSide()) {
                    totalDataField.addDataAttribute("skip_total", "true");
                }
                calculationFieldGroupItems.add(totalDataField);
            }
            if (cInfo.isShowGroupTotal()) {
                org.kuali.rice.krad.uif.field.Field groupTotalDataField = (org.kuali.rice.krad.uif.field.Field)CopyUtils.copy(cInfo.getGroupTotalFieldPrototype());
                this.setupTotalField(groupTotalDataField, cInfo, this.isShowGroupTotal(), this.getGroupTotalLabelPrototype(), "groupTotal", leftLabelColumnIndex);
                groupTotalDataField.setId(container.getId() + "_gTotal" + cInfo.getColumnNumber());
                groupTotalDataField.setStyle("display: none;");
                calculationFieldGroupItems.add(groupTotalDataField);
                this.generateGroupTotalRows = !this.isRenderOnlyLeftTotalLabels() || this.isShowGroupTotal();
            }
            calculationFieldGroup.setItems(calculationFieldGroupItems);
            Component component = this.footerCalculationComponents.get(cInfo.getColumnNumber());
            if (component != null && component instanceof FieldGroup) {
                Group verticalComboCalcGroup = ComponentFactory.getVerticalBoxGroup();
                ArrayList<Component> comboGroupItems = new ArrayList<Component>();
                comboGroupItems.add(component);
                comboGroupItems.add(calculationFieldGroup);
                verticalComboCalcGroup.setItems(comboGroupItems);
                this.footerCalculationComponents.set(cInfo.getColumnNumber(), verticalComboCalcGroup);
                continue;
            }
            if (component != null && component instanceof Group) {
                ArrayList<? extends Component> comboGroupItems = new ArrayList<Component>();
                comboGroupItems.addAll(((Group)component).getItems());
                comboGroupItems.add(calculationFieldGroup);
                ((Group)component).setItems(comboGroupItems);
                this.footerCalculationComponents.set(cInfo.getColumnNumber(), component);
                continue;
            }
            this.footerCalculationComponents.set(cInfo.getColumnNumber(), calculationFieldGroup);
        }
        if (this.renderOnlyLeftTotalLabels && this.footerCalculationComponents.get(leftLabelColumnIndex) == null) {
            ArrayList<Label> groupItems = new ArrayList<Label>();
            Group labelGroup = ComponentFactory.getVerticalBoxGroup();
            if (this.isShowGroupTotal()) {
                Label groupTotalLabel = (Label)CopyUtils.copy(this.groupTotalLabelPrototype);
                groupTotalLabel.setViewStatus("C");
                groupTotalLabel.setStyle("display: none;");
                groupTotalLabel.addDataAttribute("role", "groupTotalLabel");
                groupItems.add(groupTotalLabel);
            }
            if (this.isShowPageTotal()) {
                Label pageTotalLabel = (Label)CopyUtils.copy(this.pageTotalLabel);
                pageTotalLabel.setViewStatus("C");
                pageTotalLabel.addDataAttribute("role", "pageTotal");
                groupItems.add(pageTotalLabel);
            }
            if (this.isShowTotal()) {
                Label totalLabel = (Label)CopyUtils.copy(this.totalLabel);
                totalLabel.setViewStatus("C");
                groupItems.add(totalLabel);
            }
            labelGroup.setItems(groupItems);
            this.footerCalculationComponents.set(leftLabelColumnIndex, labelGroup);
        }
    }

    protected org.kuali.rice.krad.uif.field.Field setupTotalField(org.kuali.rice.krad.uif.field.Field totalField, ColumnCalculationInfo cInfo, boolean show, Label leftLabel, String type, int leftLabelColumnIndex) {
        org.kuali.rice.krad.uif.field.Field totalDataField = totalField;
        totalDataField.addDataAttribute("role", type);
        totalDataField.addDataAttribute("function", cInfo.getCalculationFunctionName());
        totalDataField.addDataAttribute("params", cInfo.getCalculationFunctionExtraData());
        if (cInfo.getColumnNumber() != leftLabelColumnIndex) {
            totalDataField.getFieldLabel().setRender(!this.isRenderOnlyLeftTotalLabels());
        } else if (cInfo.getColumnNumber() == leftLabelColumnIndex && this.isRenderOnlyLeftTotalLabels()) {
            totalDataField.setFieldLabel((Label)CopyUtils.copy(leftLabel));
        }
        if (this.isRenderOnlyLeftTotalLabels()) {
            totalDataField.setRender(show);
        }
        return totalDataField;
    }

    @Override
    public void buildLine(LineBuilderContext lineBuilderContext) {
        int rowCount;
        boolean addLineInTable;
        View view = ViewLifecycle.getView();
        List<org.kuali.rice.krad.uif.field.Field> lineFields = lineBuilderContext.getLineFields();
        CollectionGroup collectionGroup = lineBuilderContext.getCollectionGroup();
        int lineIndex = lineBuilderContext.getLineIndex();
        String idSuffix = lineBuilderContext.getIdSuffix();
        Object currentLine = lineBuilderContext.getCurrentLine();
        List<? extends Component> actions = lineBuilderContext.getLineActions();
        String bindingPath = lineBuilderContext.getBindingPath();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        for (org.kuali.rice.krad.uif.field.Field lineField : lineFields) {
            lineField.pushObjectToContext("parent", collectionGroup);
            lineField.pushAllToContext(view.getContext());
            lineField.pushObjectToContext("ThemeImages", view.getTheme().getImageDirectory());
            lineField.pushObjectToContext("component", lineField);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "rowSpan", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "colSpan", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "required", true);
            expressionEvaluator.evaluatePropertyExpression(view, lineField.getContext(), lineField, "readOnly", true);
            if (!(lineField instanceof DataField) || this.isAutoTruncateColumns() == null || !this.isAutoTruncateColumns().equals(Boolean.TRUE)) continue;
            lineField.addStyleClass("uif-truncate");
        }
        if (this.isAutoTruncateColumns() != null && this.isAutoTruncateColumns().equals(Boolean.TRUE)) {
            String onReadyScript = collectionGroup.getOnDocumentReadyScript();
            if (StringUtils.isBlank((String)onReadyScript)) {
                onReadyScript = "";
            }
            collectionGroup.setOnDocumentReadyScript(onReadyScript + "createTruncateTooltips();");
        }
        if (this.allRowFields.isEmpty()) {
            if (this.isSuppressLineWrapping()) {
                this.setNumberOfDataColumns(lineFields.size());
            } else {
                this.setNumberOfDataColumns(this.getNumberOfColumns());
            }
        }
        boolean isAddLine = false;
        if (lineIndex == -1 || lineFields.size() != this.numberOfDataColumns && (lineIndex + 1) * this.numberOfDataColumns < lineFields.size()) {
            isAddLine = true;
        }
        if (lineIndex == 0 || this.firstRowFields.isEmpty()) {
            this.firstRowFields = lineFields;
        }
        boolean renderActions = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
        int extraColumns = 0;
        String rowCss = "";
        boolean bl = addLineInTable = collectionGroup.isRenderAddLine() && !Boolean.TRUE.equals(collectionGroup.getReadOnly()) && !this.isSeparateAddLine();
        if (collectionGroup.isHighlightNewItems() && ((UifFormBase)lineBuilderContext.getModel()).isAddedCollectionItem(currentLine)) {
            rowCss = collectionGroup.getNewItemsCssClass();
        } else if (isAddLine && addLineInTable) {
            rowCss = collectionGroup.getAddItemCssClass();
            this.addStyleClass("uif-hasAddLine");
        }
        if (rowCss == null) {
            rowCss = "";
        }
        HashMap<String, Object> lineContext = new HashMap<String, Object>();
        lineContext.putAll(this.getContext());
        lineContext.put("line", currentLine);
        lineContext.put("manager", this);
        lineContext.put("view", view);
        lineContext.put("lineSuffix", idSuffix);
        lineContext.put("index", lineIndex);
        lineContext.put("collectionGroup", collectionGroup);
        lineContext.put("isAddLine", isAddLine && !this.isSeparateAddLine());
        lineContext.put("readOnlyLine", Boolean.TRUE.equals(collectionGroup.getReadOnly()));
        if (this.conditionalRowCssClasses != null && !this.conditionalRowCssClasses.isEmpty()) {
            int oddRemainder = 1;
            if (!addLineInTable) {
                oddRemainder = 0;
            }
            boolean isOdd = lineIndex % 2 == oddRemainder || lineIndex == -1;
            rowCss = rowCss + " " + KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, lineIndex, isOdd, lineContext, expressionEvaluator);
        }
        String rowDataAttributes = "";
        if (isAddLine) {
            if (StringUtils.isNotBlank((String)collectionGroup.getAddLineEnterKeyAction())) {
                String addLineEnterKeyAction = collectionGroup.getAddLineEnterKeyAction();
                if (addLineEnterKeyAction.indexOf("@{") != -1) {
                    addLineEnterKeyAction = expressionEvaluator.evaluateExpressionTemplate(lineContext, collectionGroup.getAddLineEnterKeyAction());
                }
                rowDataAttributes = "data-enter_key=\"" + KRADUtils.convertToHTMLAttributeSafeString(addLineEnterKeyAction) + "\"";
            }
        } else if (StringUtils.isNotBlank((String)collectionGroup.getLineEnterKeyAction())) {
            String lineEnterKeyAction = collectionGroup.getLineEnterKeyAction();
            if (lineEnterKeyAction.indexOf("@{") != -1) {
                lineEnterKeyAction = expressionEvaluator.evaluateExpressionTemplate(lineContext, collectionGroup.getLineEnterKeyAction());
            }
            rowDataAttributes = "data-enter_key=\"" + KRADUtils.convertToHTMLAttributeSafeString(lineEnterKeyAction) + "\"";
        }
        this.getRowDataAttributes().add(rowDataAttributes);
        if (isAddLine && this.separateAddLine) {
            this.addEnterKeyDataAttributeToGroup(this.getAddLineGroup(), lineContext, expressionEvaluator, collectionGroup.getAddLineEnterKeyAction());
            if (this.getAddLineGroup().getHeader() != null && StringUtils.isBlank((String)this.getAddLineGroup().getTitle()) && StringUtils.isBlank((String)this.getAddLineGroup().getHeader().getHeaderText())) {
                this.getAddLineGroup().getHeader().setHeaderText(collectionGroup.getAddLabel());
            }
            this.getAddLineGroup().setItems(lineFields);
            if (this.getAddLineGroup().getFooter() != null && (this.getAddLineGroup().getFooter().getItems() == null || this.getAddLineGroup().getFooter().getItems().isEmpty())) {
                this.getAddLineGroup().getFooter().setItems(new ArrayList<Component>(actions));
            }
            return;
        }
        rowCss = StringUtils.removeStart((String)rowCss, (String)" ");
        this.getRowCssClasses().add(rowCss);
        if (!this.headerAdded) {
            this.headerLabels = new ArrayList<Label>();
            this.allRowFields = new ArrayList<org.kuali.rice.krad.uif.field.Field>();
            this.buildTableHeaderRows(collectionGroup, lineFields);
            ContextUtils.pushObjectToContextDeep(this.headerLabels, "line", currentLine);
            ContextUtils.pushObjectToContextDeep(this.headerLabels, "index", (Object)new Integer(lineIndex));
            this.headerAdded = true;
        }
        for (org.kuali.rice.krad.uif.field.Field field : lineFields) {
            field.setLabelRendered(true);
            field.setFieldLabel(null);
            this.setCellAttributes(field);
        }
        int rowSpan = rowCount = this.calculateNumberOfRows(lineFields);
        List<FieldGroup> subCollectionFields = lineBuilderContext.getSubCollectionFields();
        if (subCollectionFields != null) {
            rowSpan += subCollectionFields.size();
        }
        if (this.actionColumnIndex == 1 && renderActions) {
            this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
        }
        if (this.renderSequenceField) {
            org.kuali.rice.krad.uif.field.Field sequenceField = null;
            if (!isAddLine) {
                sequenceField = ComponentUtils.copy(this.getSequenceFieldPrototype(), idSuffix);
                sequenceField.addDataAttribute("vignore", "yes");
                if (this.generateAutoSequence && sequenceField instanceof MessageField) {
                    ((MessageField)sequenceField).setMessageText(Integer.toString(lineIndex + 1));
                }
            } else {
                sequenceField = ComponentFactory.getMessageField();
                String value = null;
                org.kuali.rice.krad.uif.field.Field copyField = ComponentUtils.copy(this.getSequenceFieldPrototype(), idSuffix);
                Field field = ReflectionUtils.findField(copyField.getClass(), (String)"propertyName", String.class);
                if (field != null) {
                    ReflectionUtils.makeAccessible((Field)field);
                    String propertyName = (String)ReflectionUtils.getField((Field)field, (Object)copyField);
                    value = (String)ReflectionUtils.getField((Object)currentLine, (String)propertyName, String.class);
                }
                if (value == null) {
                    Message sequenceMessage = ComponentUtils.copy(collectionGroup.getAddLineLabel(), idSuffix);
                    ((MessageField)sequenceField).setMessage(sequenceMessage);
                } else {
                    ((MessageField)sequenceField).setMessageText(value);
                }
                sequenceField.setCellWidth(this.getSequenceFieldPrototype().getCellWidth());
                sequenceField.setWrapperStyle(this.getSequenceFieldPrototype().getWrapperStyle());
            }
            sequenceField.setRowSpan(rowSpan);
            if (sequenceField instanceof DataBinding) {
                ((DataBinding)((Object)sequenceField)).getBindingInfo().setBindByNamePrefix(bindingPath);
            }
            this.setCellAttributes(sequenceField);
            ContextUtils.updateContextForLine(sequenceField, collectionGroup, currentLine, lineIndex, idSuffix);
            this.allRowFields.add(sequenceField);
            ++extraColumns;
            if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            org.kuali.rice.krad.uif.field.Field selectField = ComponentUtils.copy(this.getSelectFieldPrototype(), idSuffix);
            CollectionLayoutUtils.prepareSelectFieldForLine(selectField, collectionGroup, bindingPath, currentLine);
            ContextUtils.updateContextForLine(selectField, collectionGroup, currentLine, lineIndex, idSuffix);
            this.setCellAttributes(selectField);
            this.allRowFields.add(selectField);
            ++extraColumns;
            if (renderActions && (this.actionColumnIndex == 3 && this.renderSequenceField || this.actionColumnIndex == 2 && !this.renderSequenceField)) {
                this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
        }
        int cellPosition = 0;
        boolean renderActionsLast = this.actionColumnIndex == -1 || this.actionColumnIndex > lineFields.size() + extraColumns;
        boolean hasGrouping = this.groupingPropertyNames != null || StringUtils.isNotBlank((String)this.getGroupingTitle());
        boolean insertActionField = false;
        for (org.kuali.rice.krad.uif.field.Field lineField : lineFields) {
            insertActionField = cellPosition != 0 && lineFields.size() != this.numberOfDataColumns && renderActions && renderActionsLast && cellPosition % this.numberOfDataColumns == 0;
            cellPosition += lineField.getColSpan();
            Map<String, String> lineFieldDataAttributes = lineField.getDataAttributes();
            if (hasGrouping && lineField instanceof MessageField && lineFieldDataAttributes != null && "RowGrouping".equals(lineFieldDataAttributes.get("role"))) {
                int groupFieldIndex = this.allRowFields.size() - extraColumns;
                this.allRowFields.add(groupFieldIndex, lineField);
                this.groupingColumnIndex = 0;
                if (isAddLine) {
                    ((MessageField)lineField).getMessage().getPropertyExpressions().remove("messageText");
                    ((MessageField)lineField).getMessage().setMessageText("addLine");
                }
            } else {
                if (insertActionField) {
                    this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
                }
                this.allRowFields.add(lineField);
            }
            if (!renderActionsLast && cellPosition == this.actionColumnIndex - extraColumns - 1) {
                this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
            }
            if (lineField instanceof FieldGroup) {
                String role;
                FieldGroup lineFieldGroup = (FieldGroup)lineField;
                List<? extends Component> lineFieldItems = lineFieldGroup.getItems();
                if (lineFieldItems != null) {
                    for (Component component : lineFieldItems) {
                        if (component == null || !(component instanceof Action) || component.getDataAttributes() == null || component.getDataAttributes().get("role") == null || !component.getDataAttributes().get("role").equals("detailsLink") || !StringUtils.isBlank((String)((Action)component).getActionScript())) continue;
                        ((Action)component).setActionScript("rowDetailsActionHandler(this,'" + this.getId() + "');");
                    }
                }
                if (collectionGroup.isEditWithDialog() && !isAddLine && lineFieldGroup.getDataAttributes() != null && (role = lineFieldGroup.getDataAttributes().get("role")) != null && role.equals("detailsFieldGroup")) {
                    lineFieldGroup.setReadOnly(true);
                }
            }
            if (!(lineField instanceof InputField) || this.columnCalculations == null) continue;
            for (ColumnCalculationInfo cInfo : this.columnCalculations) {
                if (!cInfo.getPropertyName().equals(((InputField)lineField).getPropertyName())) continue;
                if (cInfo.isCalculateOnKeyUp()) {
                    lineField.addDataAttribute("total", "keyup");
                } else {
                    lineField.addDataAttribute("total", "change");
                }
                lineField.addStyleClass("uif-calculationField");
            }
        }
        if (lineFields.size() == this.numberOfDataColumns && renderActions && renderActionsLast) {
            this.addActionColumn(collectionGroup, idSuffix, currentLine, lineIndex, rowSpan, actions);
        }
        if (subCollectionFields != null) {
            for (FieldGroup subCollectionField : subCollectionFields) {
                subCollectionField.setColSpan(this.numberOfDataColumns);
            }
            this.allRowFields.addAll(subCollectionFields);
        }
    }

    protected void addActionColumn(CollectionGroup collectionGroup, String idSuffix, Object currentLine, int lineIndex, int rowSpan, List<? extends Component> actions) {
        FieldGroup lineActionsField = ComponentUtils.copy(this.getActionFieldPrototype(), idSuffix);
        ContextUtils.updateContextForLine(lineActionsField, collectionGroup, currentLine, lineIndex, idSuffix);
        lineActionsField.setRowSpan(rowSpan);
        lineActionsField.setItems(actions);
        if (lineActionsField.getWrapperCssClasses() != null && !lineActionsField.getWrapperCssClasses().contains("uif-collection-column-action")) {
            lineActionsField.getWrapperCssClasses().add("uif-collection-column-action");
        } else {
            lineActionsField.setWrapperCssClasses(Arrays.asList("uif-collection-column-action"));
        }
        this.setCellAttributes(lineActionsField);
        this.allRowFields.add(lineActionsField);
    }

    protected void buildTableHeaderRows(CollectionGroup collectionGroup, List<org.kuali.rice.krad.uif.field.Field> lineFields) {
        int rowCount = this.calculateNumberOfRows(lineFields);
        boolean renderActions = collectionGroup.isRenderLineActions() && !Boolean.TRUE.equals(collectionGroup.getReadOnly());
        int extraColumns = 0;
        if (this.actionColumnIndex == 1 && renderActions) {
            this.addActionHeader(rowCount, 1);
        }
        if (this.renderSequenceField) {
            this.getSequenceFieldPrototype().setLabelRendered(true);
            this.getSequenceFieldPrototype().setRowSpan(rowCount);
            this.addHeaderField(this.getSequenceFieldPrototype(), 1);
            ++extraColumns;
            if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionHeader(rowCount, 2);
            }
        }
        if (collectionGroup.isIncludeLineSelectionField()) {
            this.getSelectFieldPrototype().setLabelRendered(true);
            this.getSelectFieldPrototype().setRowSpan(rowCount);
            this.addHeaderField(this.getSelectFieldPrototype(), 1);
            ++extraColumns;
            if (this.actionColumnIndex == 3 && renderActions && this.renderSequenceField) {
                this.addActionHeader(rowCount, 3);
            } else if (this.actionColumnIndex == 2 && renderActions) {
                this.addActionHeader(rowCount, 2);
            }
        }
        int cellPosition = 0;
        boolean renderActionsLast = this.actionColumnIndex == -1 || this.actionColumnIndex > lineFields.size() + extraColumns;
        boolean insertActionHeader = false;
        for (org.kuali.rice.krad.uif.field.Field field : lineFields) {
            if (!field.isRender() && StringUtils.isEmpty((String)field.getProgressiveRender())) continue;
            boolean bl = insertActionHeader = cellPosition != 0 && lineFields.size() != this.numberOfDataColumns && renderActions && renderActionsLast && cellPosition % this.numberOfDataColumns == 0;
            if (insertActionHeader) {
                this.addActionHeader(rowCount, cellPosition);
            }
            this.addHeaderField(field, cellPosition += field.getColSpan());
            if (!renderActions || renderActionsLast || cellPosition != this.actionColumnIndex - extraColumns - 1) continue;
            this.addActionHeader(rowCount, ++cellPosition);
        }
        if (lineFields.size() == this.numberOfDataColumns && renderActions && renderActionsLast) {
            this.addActionHeader(rowCount, ++cellPosition);
        }
    }

    protected void addActionHeader(int rowCount, int cellPosition) {
        this.getActionFieldPrototype().setLabelRendered(true);
        this.getActionFieldPrototype().setRowSpan(rowCount);
        if (this.getActionFieldPrototype().getWrapperCssClasses() != null && !this.getActionFieldPrototype().getWrapperCssClasses().contains("uif-collection-column-action")) {
            this.getActionFieldPrototype().getWrapperCssClasses().add("uif-collection-column-action");
        } else {
            this.getActionFieldPrototype().setWrapperCssClasses(Arrays.asList("uif-collection-column-action"));
        }
        this.addHeaderField(this.getActionFieldPrototype(), cellPosition);
    }

    protected void addHeaderField(org.kuali.rice.krad.uif.field.Field field, int column) {
        String labelSuffix = "_c" + column;
        Label headerLabel = ComponentUtils.copy(this.getHeaderLabelPrototype(), labelSuffix);
        if (this.useShortLabels) {
            headerLabel.setLabelText(field.getShortLabel());
        } else {
            headerLabel.setLabelText(field.getLabel());
        }
        if (field.getExpressionGraph() != null && field.getExpressionGraph().containsKey("label")) {
            if (headerLabel.getExpressionGraph() == null) {
                headerLabel.setExpressionGraph(new HashMap<String, String>());
            }
            headerLabel.getExpressionGraph().put("labelText", field.getExpressionGraph().get("label"));
            field.getExpressionGraph().remove("label");
            if (headerLabel.getPropertyExpressions() == null) {
                headerLabel.setPropertyExpressions(new HashMap<String, String>());
            }
            headerLabel.getPropertyExpressions().put("labelText", field.getPropertyExpressions().get("label"));
            field.getPropertyExpressions().remove("label");
        }
        headerLabel.setInlineComponents(field.getFieldLabel().getInlineComponents());
        headerLabel.setRowSpan(field.getRowSpan());
        headerLabel.setColSpan(field.getColSpan());
        if (field.getRequired() != null && field.getRequired().booleanValue()) {
            headerLabel.setRenderRequiredIndicator(!Boolean.TRUE.equals(field.getReadOnly()));
        } else {
            headerLabel.setRenderRequiredIndicator(false);
        }
        this.setCellAttributes(field);
        headerLabel.setWrapperCssClasses(field.getWrapperCssClasses());
        headerLabel.setWrapperStyle(field.getWrapperStyle());
        headerLabel.setCellWidth(field.getCellWidth());
        this.headerLabels.add(headerLabel);
    }

    protected int calculateNumberOfRows(List<? extends org.kuali.rice.krad.uif.field.Field> items) {
        int rowCount = 0;
        if (this.isSuppressLineWrapping()) {
            return 1;
        }
        if (items.size() % this.getNumberOfDataColumns() > 0) {
            org.kuali.rice.krad.uif.field.Field field = items.get(items.size() - 1);
            int colSize = 0;
            for (org.kuali.rice.krad.uif.field.Field field2 : items) {
                colSize += field2.getColSpan();
            }
            field.setColSpan(1 + (this.numberOfDataColumns - colSize % this.numberOfDataColumns));
            rowCount = items.size() / this.getNumberOfDataColumns() + 1;
        } else {
            rowCount = items.size() / this.getNumberOfDataColumns();
        }
        return rowCount;
    }

    protected void setCellAttributes(Component component) {
        if (StringUtils.isNotBlank((String)component.getWidth()) && StringUtils.isBlank((String)component.getCellWidth())) {
            component.setCellWidth(component.getWidth());
            component.setWidth("");
        }
        if (StringUtils.isNotBlank((String)component.getAlign()) && !StringUtils.contains((String)component.getWrapperStyle(), (String)"text-align: ")) {
            if (component.getWrapperStyle() == null) {
                component.setWrapperStyle("");
            }
            component.setWrapperStyle(component.getWrapperStyle() + "text-align: " + component.getAlign() + ";");
            component.setAlign("");
        }
        if (StringUtils.isNotBlank((String)component.getValign()) && !StringUtils.contains((String)component.getWrapperStyle(), (String)"vertical-align: ")) {
            if (component.getWrapperStyle() == null) {
                component.setWrapperStyle("");
            }
            component.setWrapperStyle(component.getWrapperStyle() + "vertical-align: " + component.getValign() + ";");
            component.setValign("");
        }
    }

    @Override
    public void processPagingRequest(Object model, CollectionGroup collectionGroup) {
        boolean richTableEnabled;
        boolean bl = richTableEnabled = this.getRichTable() != null && this.getRichTable().isRender();
        if (richTableEnabled) {
            DataTablesPagingHelper.DataTablesInputs dataTablesInputs = new DataTablesPagingHelper.DataTablesInputs(ViewLifecycle.getRequest());
            DataTablesPagingHelper.processPagingRequest(ViewLifecycle.getView(), (ViewModel)model, collectionGroup, dataTablesInputs);
        } else {
            String pageNumber = ViewLifecycle.getRequest().getParameter("pageNumber");
            CollectionPagingHelper pagingHelper = new CollectionPagingHelper();
            pagingHelper.processPagingRequest(ViewLifecycle.getView(), collectionGroup, (UifFormBase)model, pageNumber);
        }
    }

    @Override
    public Class<? extends Container> getSupportedContainer() {
        return CollectionGroup.class;
    }

    @Override
    public List<Component> getColumnCalculationComponents() {
        if (this.columnCalculations == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(this.columnCalculations.size() * 3);
        for (ColumnCalculationInfo cInfo : this.columnCalculations) {
            components.add(cInfo.getTotalField());
            components.add(cInfo.getPageTotalField());
            components.add(cInfo.getGroupTotalFieldPrototype());
        }
        return components;
    }

    @Override
    @BeanTagAttribute
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    @Override
    @BeanTagAttribute
    public boolean isSuppressLineWrapping() {
        return this.suppressLineWrapping;
    }

    @Override
    public void setSuppressLineWrapping(boolean suppressLineWrapping) {
        this.suppressLineWrapping = suppressLineWrapping;
    }

    @Override
    @BeanTagAttribute
    public Boolean isAutoTruncateColumns() {
        return this.autoTruncateColumns;
    }

    @Override
    public void setAutoTruncateColumns(Boolean autoTruncateColumns) {
        this.autoTruncateColumns = autoTruncateColumns;
    }

    @Override
    @BeanTagAttribute
    public boolean isApplyAlternatingRowStyles() {
        return this.applyAlternatingRowStyles;
    }

    @Override
    public void setApplyAlternatingRowStyles(boolean applyAlternatingRowStyles) {
        this.applyAlternatingRowStyles = applyAlternatingRowStyles;
    }

    @Override
    @BeanTagAttribute
    public boolean isApplyDefaultCellWidths() {
        return this.applyDefaultCellWidths;
    }

    @Override
    public void setApplyDefaultCellWidths(boolean applyDefaultCellWidths) {
        this.applyDefaultCellWidths = applyDefaultCellWidths;
    }

    @Override
    @BeanTagAttribute
    public List<String> getRowCssClasses() {
        return this.rowCssClasses;
    }

    @Override
    public void setRowCssClasses(List<String> rowCssClasses) {
        this.rowCssClasses = rowCssClasses;
    }

    @Override
    @BeanTagAttribute
    public List<String> getRowDataAttributes() {
        return this.rowDataAttributes;
    }

    @Override
    public void setRowDataAttributes(List<String> rowDataAttributes) {
        this.rowDataAttributes = rowDataAttributes;
    }

    @Override
    @BeanTagAttribute
    public boolean isUseShortLabels() {
        return this.useShortLabels;
    }

    @Override
    public void setUseShortLabels(boolean useShortLabels) {
        this.useShortLabels = useShortLabels;
    }

    @Override
    @BeanTagAttribute
    public boolean isRepeatHeader() {
        return this.repeatHeader;
    }

    @Override
    public void setRepeatHeader(boolean repeatHeader) {
        this.repeatHeader = repeatHeader;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public Label getHeaderLabelPrototype() {
        return this.headerLabelPrototype;
    }

    @Override
    public void setHeaderLabelPrototype(Label headerLabelPrototype) {
        this.headerLabelPrototype = headerLabelPrototype;
    }

    @Override
    public List<Label> getHeaderLabels() {
        return this.headerLabels;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderSequenceField() {
        return this.renderSequenceField;
    }

    @Override
    public void setRenderSequenceField(boolean renderSequenceField) {
        this.renderSequenceField = renderSequenceField;
    }

    @Override
    @BeanTagAttribute
    public String getSequencePropertyName() {
        if (this.getSequenceFieldPrototype() != null && this.getSequenceFieldPrototype() instanceof DataField) {
            return ((DataField)this.getSequenceFieldPrototype()).getPropertyName();
        }
        return null;
    }

    @Override
    public void setSequencePropertyName(String sequencePropertyName) {
        if (this.getSequenceFieldPrototype() != null && this.getSequenceFieldPrototype() instanceof DataField) {
            ((DataField)this.getSequenceFieldPrototype()).setPropertyName(sequencePropertyName);
        }
    }

    @Override
    @BeanTagAttribute
    public boolean isGenerateAutoSequence() {
        return this.generateAutoSequence;
    }

    @Override
    public void setGenerateAutoSequence(boolean generateAutoSequence) {
        this.generateAutoSequence = generateAutoSequence;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public org.kuali.rice.krad.uif.field.Field getSequenceFieldPrototype() {
        return this.sequenceFieldPrototype;
    }

    @Override
    public void setSequenceFieldPrototype(org.kuali.rice.krad.uif.field.Field sequenceFieldPrototype) {
        this.sequenceFieldPrototype = sequenceFieldPrototype;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public FieldGroup getActionFieldPrototype() {
        return this.actionFieldPrototype;
    }

    @Override
    public void setActionFieldPrototype(FieldGroup actionFieldPrototype) {
        this.actionFieldPrototype = actionFieldPrototype;
    }

    @Override
    @BeanTagAttribute
    public boolean isSeparateAddLine() {
        return this.separateAddLine;
    }

    @Override
    public void setSeparateAddLine(boolean separateAddLine) {
        this.separateAddLine = separateAddLine;
    }

    @Override
    public List<org.kuali.rice.krad.uif.field.Field> getAllRowFields() {
        return this.allRowFields;
    }

    @Override
    @ViewLifecycleRestriction
    public List<org.kuali.rice.krad.uif.field.Field> getFirstRowFields() {
        return this.firstRowFields;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public RichTable getRichTable() {
        return this.richTable;
    }

    @Override
    public void setRichTable(RichTable richTable) {
        this.richTable = richTable;
    }

    @Override
    @BeanTagAttribute
    public int getNumberOfDataColumns() {
        return this.numberOfDataColumns;
    }

    @Override
    public void setNumberOfDataColumns(int numberOfDataColumns) {
        this.numberOfDataColumns = numberOfDataColumns;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getHiddenColumns() {
        if (this.richTable != null) {
            return this.richTable.getHiddenColumns();
        }
        return null;
    }

    @Override
    public void setHiddenColumns(Set<String> hiddenColumns) {
        if (this.richTable != null) {
            this.richTable.setHiddenColumns(hiddenColumns);
        }
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SETVALUE)
    public Set<String> getSortableColumns() {
        if (this.richTable != null) {
            return this.richTable.getSortableColumns();
        }
        return null;
    }

    @Override
    public void setSortableColumns(Set<String> sortableColumns) {
        if (this.richTable != null) {
            this.richTable.setSortableColumns(sortableColumns);
        }
    }

    @Override
    public int getActionColumnIndex() {
        return this.actionColumnIndex;
    }

    @Override
    @BeanTagAttribute
    public String getActionColumnPlacement() {
        return this.actionColumnPlacement;
    }

    @Override
    public void setActionColumnPlacement(String actionColumnPlacement) {
        this.actionColumnPlacement = actionColumnPlacement;
        if ("LEFT".equals(actionColumnPlacement)) {
            this.actionColumnIndex = 1;
        } else if ("RIGHT".equals(actionColumnPlacement)) {
            this.actionColumnIndex = -1;
        } else if (StringUtils.isNumeric((String)actionColumnPlacement)) {
            this.actionColumnIndex = Integer.parseInt(actionColumnPlacement);
        }
    }

    @Override
    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    @BeanTagAttribute
    public Group getRowDetailsGroup() {
        return this.rowDetailsGroup;
    }

    @Override
    public void setRowDetailsGroup(Group rowDetailsGroup) {
        this.rowDetailsGroup = rowDetailsGroup;
    }

    public void setupDetails(CollectionGroup collectionGroup) {
        if (this.getRowDetailsGroup() == null || this.getRichTable() == null || !this.getRichTable().isRender()) {
            return;
        }
        collectionGroup.addDataAttribute("details_default_open", Boolean.toString(this.rowDetailsOpen));
        this.toggleAllDetailsAction.addDataAttribute("open", Boolean.toString(this.rowDetailsOpen));
        this.toggleAllDetailsAction.addDataAttribute("tableid", this.getId());
        FieldGroup detailsFieldGroup = ComponentFactory.getFieldGroup();
        TreeMap<String, String> dataAttributes = new TreeMap<String, String>();
        dataAttributes.put("role", "detailsFieldGroup");
        detailsFieldGroup.setDataAttributes(dataAttributes);
        Action rowDetailsAction = this.getExpandDetailsActionPrototype();
        rowDetailsAction.addDataAttribute("role", "detailsLink");
        rowDetailsAction.setId(collectionGroup.getId() + "_detLink");
        ArrayList<Component> detailsItems = new ArrayList<Component>();
        detailsItems.add(rowDetailsAction);
        dataAttributes = new TreeMap();
        dataAttributes.put("role", "details");
        dataAttributes.put("open", Boolean.toString(this.rowDetailsOpen));
        this.getRowDetailsGroup().setDataAttributes(dataAttributes);
        detailsItems.add(this.getRowDetailsGroup());
        detailsFieldGroup.setItems(detailsItems);
        detailsFieldGroup.setId(collectionGroup.getId() + "_detGroup");
        this.getRowDetailsGroup().setHidden(true);
        if (this.ajaxDetailsRetrieval) {
            this.getRowDetailsGroup().setRetrieveViaAjax(true);
        }
        detailsFieldGroup.setReadOnly(collectionGroup.getReadOnly());
        ArrayList<? extends Component> theItems = new ArrayList<Component>();
        theItems.add(detailsFieldGroup);
        theItems.addAll(collectionGroup.getItems());
        collectionGroup.setItems(theItems);
    }

    @Override
    public List<String> getColumnsToCalculate() {
        return this.columnsToCalculate;
    }

    @Override
    @BeanTagAttribute
    public boolean isShowTotal() {
        return this.showTotal;
    }

    @Override
    public void setShowTotal(boolean showTotal) {
        this.showTotal = showTotal;
    }

    @Override
    @BeanTagAttribute
    public boolean isShowPageTotal() {
        return this.showPageTotal;
    }

    @Override
    public void setShowPageTotal(boolean showPageTotal) {
        this.showPageTotal = showPageTotal;
    }

    @Override
    @BeanTagAttribute
    public boolean isShowGroupTotal() {
        return this.showGroupTotal;
    }

    @Override
    public void setShowGroupTotal(boolean showGroupTotal) {
        this.showGroupTotal = showGroupTotal;
    }

    @Override
    @BeanTagAttribute
    public Label getTotalLabel() {
        return this.totalLabel;
    }

    @Override
    public void setTotalLabel(Label totalLabel) {
        this.totalLabel = totalLabel;
    }

    @Override
    @BeanTagAttribute
    public Label getPageTotalLabel() {
        return this.pageTotalLabel;
    }

    @Override
    public void setPageTotalLabel(Label pageTotalLabel) {
        this.pageTotalLabel = pageTotalLabel;
    }

    @Override
    @BeanTagAttribute
    public Label getGroupTotalLabelPrototype() {
        return this.groupTotalLabelPrototype;
    }

    @Override
    public void setGroupTotalLabelPrototype(Label groupTotalLabelPrototype) {
        this.groupTotalLabelPrototype = groupTotalLabelPrototype;
    }

    @Override
    @BeanTagAttribute
    public List<ColumnCalculationInfo> getColumnCalculations() {
        return this.columnCalculations;
    }

    @Override
    public void setColumnCalculations(List<ColumnCalculationInfo> columnCalculations) {
        this.columnCalculations = columnCalculations;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderOnlyLeftTotalLabels() {
        return this.renderOnlyLeftTotalLabels;
    }

    @Override
    public void setRenderOnlyLeftTotalLabels(boolean renderOnlyLeftTotalLabels) {
        this.renderOnlyLeftTotalLabels = renderOnlyLeftTotalLabels;
    }

    @Override
    public List<Component> getFooterCalculationComponents() {
        return this.footerCalculationComponents;
    }

    @Override
    @BeanTagAttribute
    public List<String> getGroupingPropertyNames() {
        return this.groupingPropertyNames;
    }

    @Override
    public void setGroupingPropertyNames(List<String> groupingPropertyNames) {
        this.groupingPropertyNames = groupingPropertyNames;
    }

    @Override
    @BeanTagAttribute
    public String getGroupingTitle() {
        return this.groupingTitle;
    }

    @Override
    public void setGroupingTitle(String groupingTitle) {
        if (groupingTitle != null && !groupingTitle.contains("@{")) {
            throw new RuntimeException("groupingTitle MUST contain a springEL expression to uniquely identify a collection group (often related to some value of the line). Value provided: " + this.getGroupingTitle());
        }
        this.groupingTitle = groupingTitle;
    }

    @Override
    @BeanTagAttribute
    public String getGroupingPrefix() {
        return this.groupingPrefix;
    }

    @Override
    public void setGroupingPrefix(String groupingPrefix) {
        this.groupingPrefix = groupingPrefix;
    }

    @Override
    @BeanTagAttribute
    public boolean isRowDetailsOpen() {
        return this.rowDetailsOpen;
    }

    @Override
    public void setRowDetailsOpen(boolean rowDetailsOpen) {
        this.rowDetailsOpen = rowDetailsOpen;
    }

    @Override
    @BeanTagAttribute
    public boolean isShowToggleAllDetails() {
        return this.showToggleAllDetails;
    }

    @Override
    public void setShowToggleAllDetails(boolean showToggleAllDetails) {
        this.showToggleAllDetails = showToggleAllDetails;
    }

    @Override
    @BeanTagAttribute
    public Action getToggleAllDetailsAction() {
        return this.toggleAllDetailsAction;
    }

    @Override
    public void setToggleAllDetailsAction(Action toggleAllDetailsAction) {
        this.toggleAllDetailsAction = toggleAllDetailsAction;
    }

    @Override
    @BeanTagAttribute
    public boolean isAjaxDetailsRetrieval() {
        return this.ajaxDetailsRetrieval;
    }

    @Override
    public void setAjaxDetailsRetrieval(boolean ajaxDetailsRetrieval) {
        this.ajaxDetailsRetrieval = ajaxDetailsRetrieval;
    }

    @Override
    @ViewLifecycleRestriction(value={"INITIALIZE"})
    @BeanTagAttribute
    public Action getExpandDetailsActionPrototype() {
        return this.expandDetailsActionPrototype;
    }

    @Override
    public int getGroupingColumnIndex() {
        return this.groupingColumnIndex;
    }

    @Override
    public void setExpandDetailsActionPrototype(Action expandDetailsActionPrototype) {
        this.expandDetailsActionPrototype = expandDetailsActionPrototype;
    }

    protected void setHeaderLabels(List<Label> headerLabels) {
        this.headerLabels = headerLabels;
    }

    protected void setAllRowFields(List<org.kuali.rice.krad.uif.field.Field> allRowFields) {
        this.allRowFields = allRowFields;
    }

    protected void setFirstRowFields(List<org.kuali.rice.krad.uif.field.Field> firstRowFields) {
        this.firstRowFields = firstRowFields;
    }

    protected void setHeaderAdded(boolean headerAdded) {
        this.headerAdded = headerAdded;
    }

    protected void setActionColumnIndex(int actionColumnIndex) {
        this.actionColumnIndex = actionColumnIndex;
    }

    protected void setGroupingColumnIndex(int groupingColumnIndex) {
        this.groupingColumnIndex = groupingColumnIndex;
    }

    protected void setGenerateGroupTotalRows(boolean generateGroupTotalRows) {
        this.generateGroupTotalRows = generateGroupTotalRows;
    }

    protected void setColumnsToCalculate(List<String> columnsToCalculate) {
        this.columnsToCalculate = columnsToCalculate;
    }

    protected void setFooterCalculationComponents(List<Component> footerCalculationComponents) {
        this.footerCalculationComponents = footerCalculationComponents;
    }

    @Override
    @BeanTagAttribute
    public Map<String, String> getConditionalRowCssClasses() {
        return this.conditionalRowCssClasses;
    }

    @Override
    public void setConditionalRowCssClasses(Map<String, String> conditionalRowCssClasses) {
        this.conditionalRowCssClasses = conditionalRowCssClasses;
    }

    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("TableLayoutManager", this.getId());
        if (this.getRowDetailsGroup() != null) {
            boolean validTable = false;
            if (this.getRichTable() != null && this.getRichTable().isRender()) {
                validTable = true;
            }
            if (!validTable) {
                String[] currentValues = new String[]{"rowDetailsGroup =" + this.getRowDetailsGroup(), "richTable =" + this.getRichTable()};
                tracer.createError("If rowDetailsGroup is set richTable must be set and its render true", currentValues);
            }
        }
    }
}

