/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ViewLifecycleRefreshBuild
implements Runnable {
    @Override
    public void run() {
        View view = ViewLifecycle.getView();
        UifFormBase form = (UifFormBase)ViewLifecycle.getModel();
        HttpServletRequest request = ViewLifecycle.getRequest();
        String flashMapSelectedLineValues = "";
        if (RequestContextUtils.getInputFlashMap((HttpServletRequest)request) != null) {
            flashMapSelectedLineValues = (String)RequestContextUtils.getInputFlashMap((HttpServletRequest)request).get("selectedLineValues");
        }
        String refreshCallerType = "";
        if (request.getParameterMap().containsKey("refreshCallerType")) {
            refreshCallerType = request.getParameter("refreshCallerType");
        }
        if (StringUtils.equals((String)refreshCallerType, (String)"MULTI_VALUE_LOOKUP")) {
            String lookupCollectionName = "";
            if (request.getParameterMap().containsKey("lookupCollectionName")) {
                lookupCollectionName = request.getParameter("lookupCollectionName");
            }
            String lookupCollectionId = "";
            if (request.getParameterMap().containsKey("lookupCollectionId")) {
                lookupCollectionId = request.getParameter("lookupCollectionId");
            }
            if (StringUtils.isBlank((String)lookupCollectionName)) {
                throw new RuntimeException("Lookup collection name is required for processing multi-value lookup results");
            }
            String multiValueReturnFields = "";
            if (request.getParameterMap().containsKey("multiValueReturnFields")) {
                multiValueReturnFields = request.getParameter("multiValueReturnFields");
            }
            String selectedLineValues = "";
            if (request.getParameterMap().containsKey("selectedLineValues")) {
                selectedLineValues = request.getParameter("selectedLineValues");
            }
            if (!StringUtils.isBlank((String)flashMapSelectedLineValues)) {
                selectedLineValues = flashMapSelectedLineValues;
            }
            ViewLifecycle.getHelper().processMultipleValueLookupResults(form, lookupCollectionId, lookupCollectionName, multiValueReturnFields, selectedLineValues);
        }
        if (request.getParameterMap().containsKey("referencesToRefresh")) {
            String referencesToRefresh = request.getParameter("referencesToRefresh");
            ViewLifecycle.getHelper().refreshReferences(referencesToRefresh);
        }
        if (request.getParameterMap().containsKey("quickfinderId")) {
            String jumpToId;
            String quickfinderId = request.getParameter("quickfinderId");
            String focusId = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderFocusId");
            if (StringUtils.isNotBlank((String)focusId)) {
                form.setFocusId(focusId);
            }
            if (StringUtils.isNotBlank((String)(jumpToId = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderJumpToId")))) {
                form.setJumpToId(jumpToId);
            }
            String callbackMethodToCall = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackMethodToCall");
            MethodInvokerConfig callbackMethod = (MethodInvokerConfig)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackMethod");
            if (StringUtils.isNotBlank((String)callbackMethodToCall) || callbackMethod != null) {
                if (callbackMethod == null) {
                    callbackMethod = new MethodInvokerConfig();
                }
                Map callbackContext = (Map)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackContext");
                if (callbackMethod.getTargetClass() == null && callbackMethod.getTargetObject() == null) {
                    callbackMethod.setTargetObject(ViewLifecycle.getHelper());
                }
                callbackMethod.setTargetMethod(callbackMethodToCall);
                Object[] arguments = new Object[]{form, quickfinderId, callbackContext};
                callbackMethod.setArguments(arguments);
                try {
                    callbackMethod.prepare();
                    Class<?> methodReturnType = callbackMethod.getPreparedMethod().getReturnType();
                    if (StringUtils.equals((String)"void", (String)methodReturnType.getName())) {
                        callbackMethod.invoke();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking callback method for quickfinder: " + quickfinderId, e);
                }
            }
        }
    }
}

