/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.AttributeDefinitionBase;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.lookup.LookupInputField;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.HiddenControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UserControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.service.UifDefaultingService;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.InquiryView;

public class UifDefaultingServiceImpl
implements UifDefaultingService {
    private static final Logger LOG = Logger.getLogger(UifDefaultingServiceImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected DataObjectService dataObjectService;
    protected static final String ANY_CHARACTER_PATTERN_CONSTRAINT = "UTF8AnyCharacterPatternConstraint";
    protected static final String DATE_PATTERN_CONSTRAINT = "BasicDatePatternConstraint";
    protected static final String FLOATING_POINT_PATTERN_CONSTRAINT = "FloatingPointPatternConstraintTemplate";
    protected static final String BIG_DECIMAL_PATTERN_CONSTRAINT = "BigDecimalPatternConstraintTemplate";
    protected static final String TIMESTAMP_PATTERN_CONSTRAINT = "TimestampPatternConstraint";
    protected static final String CURRENCY_PATTERN_CONSTRAINT = "CurrencyPatternConstraint";

    @Override
    public String deriveHumanFriendlyNameFromPropertyName(String camelCasedName) {
        if (StringUtils.isBlank((String)camelCasedName)) {
            return camelCasedName;
        }
        if (camelCasedName.contains(".")) {
            camelCasedName = StringUtils.substringAfterLast((String)camelCasedName, (String)".");
        }
        StringBuilder label = new StringBuilder(camelCasedName);
        label.replace(0, 1, label.substring(0, 1).toUpperCase());
        for (int i = 0; i < label.length(); ++i) {
            if (!Character.isUpperCase(label.charAt(i)) && !Character.isDigit(label.charAt(i))) continue;
            label.insert(i, ' ');
            ++i;
        }
        return label.toString().trim();
    }

    protected UifDisplayHint getHintOfType(DataObjectAttribute attr, UifDisplayHintType hintType) {
        if (attr != null && attr.getDisplayHints() != null) {
            for (UifDisplayHint hint : attr.getDisplayHints()) {
                if (!hint.value().equals((Object)hintType)) continue;
                return hint;
            }
        }
        return null;
    }

    protected boolean hasHintOfType(DataObjectAttribute attr, UifDisplayHintType hintType) {
        return this.getHintOfType(attr, hintType) != null;
    }

    protected Control getControlInstance(AttributeDefinition attrDef, DataObjectAttribute dataObjectAttribute) {
        Control c = null;
        if (dataObjectAttribute != null && this.hasHintOfType(dataObjectAttribute, UifDisplayHintType.HIDDEN)) {
            c = ComponentFactory.getHiddenControl();
        } else if (attrDef.getOptionsFinder() != null) {
            c = dataObjectAttribute != null && this.hasHintOfType(dataObjectAttribute, UifDisplayHintType.RADIO) ? ComponentFactory.getRadioGroupControl() : ComponentFactory.getSelectControl();
        } else if (attrDef.getName().endsWith(".principalName") && dataObjectAttribute != null) {
            c = ComponentFactory.getUserControl();
            String relationshipName = StringUtils.removeEnd((String)attrDef.getName(), (String)".principalName");
            DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(dataObjectAttribute.getOwningType());
            if (metadata != null) {
                DataObjectRelationship relationship = metadata.getRelationship(relationshipName);
                if (relationship != null && CollectionUtils.isNotEmpty((Collection)relationship.getAttributeRelationships())) {
                    ((UserControl)c).setPrincipalIdPropertyName(((DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(0)).getParentAttributeName());
                    ((UserControl)c).setPersonNamePropertyName(relationshipName + "." + "name");
                    ((UserControl)c).setPersonObjectPropertyName(relationshipName);
                }
            } else {
                LOG.warn((Object)("Attempt to pull relationship name: " + relationshipName + " resulted in missing metadata when looking for: " + dataObjectAttribute.getOwningType()));
            }
        } else {
            switch (attrDef.getDataType()) {
                case STRING: {
                    if (attrDef.getMaxLength() != null && attrDef.getMaxLength() > 200) {
                        c = ComponentFactory.getTextAreaControl();
                        break;
                    }
                    c = ComponentFactory.getTextControl();
                    break;
                }
                case BOOLEAN: {
                    c = ComponentFactory.getCheckboxControl();
                    break;
                }
                case DATE: 
                case DATETIME: 
                case TRUNCATED_DATE: {
                    c = ComponentFactory.getDateControl();
                    break;
                }
                case CURRENCY: 
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LARGE_INTEGER: 
                case LONG: 
                case PRECISE_DECIMAL: {
                    c = ComponentFactory.getTextControl();
                    break;
                }
                case MARKUP: {
                    c = ComponentFactory.getTextAreaControl();
                    break;
                }
                default: {
                    c = ComponentFactory.getTextControl();
                }
            }
        }
        return c;
    }

    protected void customizeControlInstance(Control c, AttributeDefinition attrDef, DataObjectAttribute dataObjectAttribute) {
        c.setRequired(attrDef.isRequired());
        if (c instanceof TextControl) {
            if (attrDef.getMaxLength() != null) {
                ((TextControl)c).setMaxLength(attrDef.getMaxLength());
                ((TextControl)c).setSize(attrDef.getMaxLength());
                if (attrDef.getMaxLength() > 80) {
                    ((TextControl)c).setTextExpand(true);
                }
            }
            if (attrDef.getMinLength() != null) {
                ((TextControl)c).setMinLength(attrDef.getMinLength());
            }
        }
        if (c instanceof TextAreaControl) {
            if (attrDef.getMaxLength() != null) {
                ((TextAreaControl)c).setMaxLength(attrDef.getMaxLength());
                ((TextAreaControl)c).setRows(attrDef.getMaxLength() / ((TextAreaControl)c).getCols());
            }
            if (attrDef.getMinLength() != null) {
                ((TextAreaControl)c).setMinLength(attrDef.getMinLength());
            }
        }
    }

    @Override
    public Control deriveControlAttributeFromMetadata(AttributeDefinition attrDef) {
        DataObjectAttribute dataObjectAttribute = attrDef.getDataObjectAttribute();
        Control c = this.getControlInstance(attrDef, dataObjectAttribute);
        if (c != null) {
            this.customizeControlInstance(c, attrDef, dataObjectAttribute);
        }
        return c;
    }

    @Override
    public ValidCharactersConstraint deriveValidCharactersConstraint(AttributeDefinition attrDef) {
        Object consObj;
        ValidCharactersConstraint validCharactersConstraint = null;
        if (attrDef.getDataObjectAttribute() != null && StringUtils.isNotBlank((String)attrDef.getDataObjectAttribute().getValidCharactersConstraintBeanName()) && (consObj = this.dataDictionaryService.getDictionaryBean(attrDef.getDataObjectAttribute().getValidCharactersConstraintBeanName())) != null && consObj instanceof ValidCharactersConstraint) {
            validCharactersConstraint = (ValidCharactersConstraint)consObj;
        }
        if (validCharactersConstraint == null && attrDef.getDataType() != null) {
            if (attrDef.getDataType() == DataType.CURRENCY) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(CURRENCY_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType() == DataType.PRECISE_DECIMAL) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(BIG_DECIMAL_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType().isNumeric()) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(FLOATING_POINT_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType().isTemporal()) {
                if (attrDef.getDataType() == DataType.DATE) {
                    validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(DATE_PATTERN_CONSTRAINT);
                } else if (attrDef.getDataType() == DataType.TIMESTAMP) {
                    validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(TIMESTAMP_PATTERN_CONSTRAINT);
                }
            }
        }
        if (validCharactersConstraint == null) {
            validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(ANY_CHARACTER_PATTERN_CONSTRAINT);
        }
        return validCharactersConstraint;
    }

    protected Group createInquirySection(String groupId, String headerText) {
        Group group = ComponentFactory.getGroupWithDisclosureGridLayout();
        group.setId(groupId);
        group.setHeaderText(headerText);
        group.setItems(new ArrayList());
        return group;
    }

    protected CollectionGroup createCollectionInquirySection(String groupId, String headerText) {
        CollectionGroup group = ComponentFactory.getCollectionWithDisclosureGroupTableLayout();
        group.setId(groupId);
        group.setHeaderText(headerText);
        group.setItems(new ArrayList());
        ((TableLayoutManager)group.getLayoutManager()).setRenderSequenceField(false);
        return group;
    }

    protected void addAttributeSectionsToInquiryView(InquiryView view, DataObjectEntry dataObjectEntry) {
        HashMap<String, Group> inquirySectionsById = new HashMap<String, Group>();
        Group currentGroup = this.createInquirySection("default", dataObjectEntry.getObjectLabel());
        inquirySectionsById.put(currentGroup.getId(), currentGroup);
        view.getItems().add(currentGroup);
        List<? extends Component> items = currentGroup.getItems();
        for (AttributeDefinition attr : dataObjectEntry.getAttributes()) {
            boolean dontDisplay = this.hasHintOfType(attr.getDataObjectAttribute(), UifDisplayHintType.NO_INQUIRY);
            dontDisplay |= attr.getControlField() instanceof HiddenControl;
            UifDisplayHint sectionHint = this.getHintOfType(attr.getDataObjectAttribute(), UifDisplayHintType.SECTION);
            if (sectionHint != null) {
                if (StringUtils.isNotBlank((String)sectionHint.id())) {
                    currentGroup = (Group)inquirySectionsById.get(sectionHint.id());
                    if (currentGroup == null) {
                        String sectionLabel = sectionHint.label();
                        if (StringUtils.isBlank((String)sectionLabel)) {
                            sectionLabel = this.deriveHumanFriendlyNameFromPropertyName(sectionHint.id());
                        }
                        currentGroup = this.createInquirySection(sectionHint.id(), sectionHint.label());
                        inquirySectionsById.put(currentGroup.getId(), currentGroup);
                        view.getItems().add(currentGroup);
                    }
                } else {
                    LOG.warn((Object)"SECTION UifDisplayHint given without an ID - assuming 'default'");
                    currentGroup = (Group)inquirySectionsById.get("default");
                }
                items = currentGroup.getItems();
            }
            if (dontDisplay) continue;
            DataField dataField = ComponentFactory.getDataField();
            dataField.setPropertyName(attr.getName());
            dataField.setLabel(attr.getLabel());
            items.add(dataField);
        }
    }

    protected void addCollectionSectionsToInquiryView(InquiryView view, DataObjectEntry dataObjectEntry) {
        for (CollectionDefinition coll : dataObjectEntry.getCollections()) {
            DataObjectEntry collectionEntry = this.dataDictionaryService.getDataDictionary().getDataObjectEntry(coll.getDataObjectClass());
            HashSet<String> collectionFieldsLinkedToParent = new HashSet<String>();
            if (coll.getDataObjectCollection() != null) {
                for (DataObjectAttributeRelationship rel : coll.getDataObjectCollection().getAttributeRelationships()) {
                    collectionFieldsLinkedToParent.add(rel.getChildAttributeName());
                }
            }
            if (collectionEntry == null) {
                LOG.warn((Object)("Unable to find DataObjectEntry for collection class: " + coll.getDataObjectClass()));
                continue;
            }
            CollectionGroup section = this.createCollectionInquirySection(coll.getName(), coll.getLabel());
            try {
                section.setCollectionObjectClass(Class.forName(coll.getDataObjectClass()));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Unable to set class on collection section - class not found: " + coll.getDataObjectClass()));
            }
            section.setPropertyName(coll.getName());
            for (AttributeDefinition attr : collectionEntry.getAttributes()) {
                boolean dontDisplay = this.hasHintOfType(attr.getDataObjectAttribute(), UifDisplayHintType.NO_INQUIRY);
                dontDisplay |= attr.getControlField() instanceof HiddenControl;
                if (dontDisplay |= collectionFieldsLinkedToParent.contains(attr.getName())) continue;
                DataField dataField = ComponentFactory.getDataField();
                dataField.setPropertyName(attr.getName());
                section.getItems().add(dataField);
            }
            view.getItems().add(section);
        }
    }

    @Override
    public InquiryView deriveInquiryViewFromMetadata(DataObjectEntry dataObjectEntry) {
        InquiryView view = ComponentFactory.getInquiryView();
        view.setHeaderText(dataObjectEntry.getObjectLabel());
        view.setDataObjectClassName(dataObjectEntry.getDataObjectClass());
        this.addAttributeSectionsToInquiryView(view, dataObjectEntry);
        this.addCollectionSectionsToInquiryView(view, dataObjectEntry);
        return view;
    }

    protected void addAttributesToLookupCriteria(LookupView view, DataObjectEntry dataObjectEntry) {
        AttributeDefinitionBase activeAttribute = null;
        for (AttributeDefinition attr : dataObjectEntry.getAttributes()) {
            boolean dontDisplay = this.hasHintOfType(attr.getDataObjectAttribute(), UifDisplayHintType.NO_LOOKUP_CRITERIA);
            if (dontDisplay |= attr.getControlField() instanceof HiddenControl) continue;
            if (attr.getName().equals("active")) {
                activeAttribute = attr;
                continue;
            }
            LookupInputField field = ComponentFactory.getLookupCriteriaInputField();
            field.setPropertyName(attr.getName());
            field.setLabel(attr.getLabel());
            view.getCriteriaFields().add(field);
        }
        if (activeAttribute != null) {
            LookupInputField field = ComponentFactory.getLookupCriteriaInputField();
            field.setPropertyName(activeAttribute.getName());
            field.setLabel(activeAttribute.getLabel());
            view.getCriteriaFields().add(field);
        }
    }

    protected void addAttributesToLookupResults(LookupView view, DataObjectEntry dataObjectEntry) {
        AttributeDefinitionBase activeAttribute = null;
        for (AttributeDefinition attr : dataObjectEntry.getAttributes()) {
            boolean dontDisplay = this.hasHintOfType(attr.getDataObjectAttribute(), UifDisplayHintType.NO_LOOKUP_RESULT);
            if (dontDisplay |= attr.getControlField() instanceof HiddenControl) continue;
            if (attr.getName().equals("active")) {
                activeAttribute = attr;
                continue;
            }
            DataField field = ComponentFactory.getDataField();
            field.setPropertyName(attr.getName());
            view.getResultFields().add(field);
        }
        if (activeAttribute != null) {
            DataField field = ComponentFactory.getDataField();
            field.setPropertyName(activeAttribute.getName());
            view.getResultFields().add(field);
        }
    }

    @Override
    public LookupView deriveLookupViewFromMetadata(DataObjectEntry dataObjectEntry) {
        LookupView view = ComponentFactory.getLookupView();
        view.setHeaderText(dataObjectEntry.getObjectLabel() + " Lookup");
        view.setDataObjectClass(dataObjectEntry.getDataObjectClass());
        view.setCriteriaFields(new ArrayList<Component>());
        view.setResultFields(new ArrayList<Component>());
        view.setDefaultSortAttributeNames(dataObjectEntry.getPrimaryKeys());
        this.addAttributesToLookupCriteria(view, dataObjectEntry);
        this.addAttributesToLookupResults(view, dataObjectEntry);
        return view;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

