/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.datadictionary.HelpDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.widget.Helpable;
import org.kuali.rice.krad.uif.widget.WidgetBase;

@BeanTag(name="help", parent="Uif-Help")
public class Help
extends WidgetBase {
    private static final long serialVersionUID = -1514436681476297241L;
    private static final Logger LOG = Logger.getLogger(Help.class);
    private Action helpAction;
    private HelpDefinition helpDefinition;
    private String externalHelpUrl;
    private String tooltipHelpContent;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if (this.helpAction == null) {
            if (this.hasValueOrPropertyExpression(this.externalHelpUrl, this, "externalHelpUrl") || this.helpDefinition != null && this.hasValueOrPropertyExpression(this.helpDefinition.getParameterName(), this.helpDefinition, "parameterName") && this.hasValueOrPropertyExpression(this.helpDefinition.getParameterDetailType(), this.helpDefinition, "parameterDetailType")) {
                this.helpAction = ComponentFactory.getHelpAction();
                this.helpAction.addDataAttribute("role", "help");
            }
        } else {
            this.helpAction.addDataAttribute("role", "help");
        }
    }

    private boolean hasValueOrPropertyExpression(String defaultValue, UifDictionaryBean dictionaryBean, String expressionName) {
        return StringUtils.isNotBlank((String)defaultValue) || dictionaryBean != null && dictionaryBean.getPropertyExpressions() != null && StringUtils.isNotBlank((String)dictionaryBean.getPropertyExpression(expressionName));
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.buildExternalHelp(parent);
        this.buildTooltipHelp(parent);
        if (StringUtils.isBlank((String)this.externalHelpUrl) && StringUtils.isBlank((String)this.tooltipHelpContent)) {
            this.setRender(false);
        }
        if (parent != null && !(parent instanceof InputField) && this.helpAction != null) {
            this.helpAction.getLibraryCssClasses().remove("btn");
            this.helpAction.getLibraryCssClasses().remove("btn-default");
            this.helpAction.getLibraryCssClasses().add("uif-iconOnly");
        }
    }

    protected void buildExternalHelp(LifecycleElement parent) {
        if (StringUtils.isBlank((String)this.externalHelpUrl) && this.helpDefinition != null) {
            if (StringUtils.isBlank((String)this.helpDefinition.getParameterNamespace())) {
                this.helpDefinition.setParameterNamespace(ViewLifecycle.getView().getNamespaceCode());
            }
            String parameterNamespace = this.helpDefinition.getParameterNamespace();
            String parameterDetailType = this.helpDefinition.getParameterDetailType();
            String parameterName = this.helpDefinition.getParameterName();
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            if (parameterNamespace == null && this.helpDefinition.getPropertyExpression("parameterNamespace") != null) {
                parameterNamespace = (String)expressionEvaluator.evaluateExpression(this.getContext(), this.helpDefinition.getPropertyExpression("parameterNamespace"));
            }
            if (parameterDetailType == null && this.helpDefinition.getPropertyExpression("parameterDetailType") != null) {
                parameterDetailType = (String)expressionEvaluator.evaluateExpression(this.getContext(), this.helpDefinition.getPropertyExpression("parameterDetailType"));
            }
            if (parameterName == null && this.helpDefinition.getPropertyExpression("parameterName") != null) {
                parameterName = (String)expressionEvaluator.evaluateExpression(this.getContext(), this.helpDefinition.getPropertyExpression("parameterName"));
            }
            if (StringUtils.isNotBlank((String)parameterNamespace) && StringUtils.isNotBlank((String)parameterDetailType) && StringUtils.isNotBlank((String)parameterName)) {
                this.externalHelpUrl = this.getParameterService().getParameterValueAsFilteredString(parameterNamespace, parameterDetailType, parameterName);
            }
        }
        if (StringUtils.isNotBlank((String)this.externalHelpUrl)) {
            this.getHelpAction().setActionScript("openHelpWindow('" + this.externalHelpUrl + "')");
            String helpTitle = parent instanceof Helpable && ((Helpable)((Object)parent)).getHelp() == this ? MessageFormat.format(CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("help.icon.title.tag.with.field.label"), ((Helpable)((Object)parent)).getHelpTitle()) : CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("help.icon.title.tag");
            this.getHelpAction().setTitle(helpTitle);
        }
    }

    protected void buildTooltipHelp(LifecycleElement parent) {
        if (StringUtils.isNotBlank((String)this.tooltipHelpContent) && this.isRender() && this.getToolTip() != null && parent instanceof Helpable && ((Helpable)((Object)parent)).getHelp() == this) {
            this.getToolTip().setTooltipContent(this.tooltipHelpContent);
            ((Helpable)((Object)parent)).setTooltipOfComponent(this.getToolTip());
        }
    }

    @BeanTagAttribute
    public Action getHelpAction() {
        return this.helpAction;
    }

    public void setHelpAction(Action helpAction) {
        this.helpAction = helpAction;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    @BeanTagAttribute
    public String getExternalHelpUrl() {
        return this.externalHelpUrl;
    }

    public void setExternalHelpUrl(String externalHelpUrl) {
        this.externalHelpUrl = externalHelpUrl;
    }

    @BeanTagAttribute
    public String getTooltipHelpContent() {
        return this.tooltipHelpContent;
    }

    public void setTooltipHelpContent(String tooltipHelpContent) {
        this.tooltipHelpContent = tooltipHelpContent;
    }

    protected ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }
}

