/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="locationSuggest", parent="Uif-LocationSuggest")
public class LocationSuggest
extends Suggest {
    private static final long serialVersionUID = 5940714417896326889L;
    private String baseUrl;
    private String additionalUrlPathPropertyName;
    private String hrefPropertyName;
    private String objectIdPropertyName;
    private Map<String, String> requestParameterPropertyNames;
    private Map<String, String> additionalRequestParameters;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.requestParameterPropertyNames == null) {
            this.requestParameterPropertyNames = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((String)this.objectIdPropertyName)) {
            this.requestParameterPropertyNames.put(this.objectIdPropertyName, this.objectIdPropertyName);
        }
    }

    @Override
    public LocationSuggestPostData getPostData() {
        return new LocationSuggestPostData(this);
    }

    @BeanTagAttribute
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @BeanTagAttribute
    public String getAdditionalUrlPathPropertyName() {
        return this.additionalUrlPathPropertyName;
    }

    public void setAdditionalUrlPathPropertyName(String additionalUrlPathPropertyName) {
        this.additionalUrlPathPropertyName = additionalUrlPathPropertyName;
    }

    @BeanTagAttribute
    public String getHrefPropertyName() {
        return this.hrefPropertyName;
    }

    public void setHrefPropertyName(String hrefPropertyName) {
        this.hrefPropertyName = hrefPropertyName;
    }

    @BeanTagAttribute
    public String getObjectIdPropertyName() {
        return this.objectIdPropertyName;
    }

    public void setObjectIdPropertyName(String objectIdPropertyName) {
        this.objectIdPropertyName = objectIdPropertyName;
    }

    @BeanTagAttribute
    public Map<String, String> getRequestParameterPropertyNames() {
        return this.requestParameterPropertyNames;
    }

    public void setRequestParameterPropertyNames(Map<String, String> requestParameterPropertyNames) {
        this.requestParameterPropertyNames = requestParameterPropertyNames;
    }

    @BeanTagAttribute
    public Map<String, String> getAdditionalRequestParameters() {
        return this.additionalRequestParameters;
    }

    public void setAdditionalRequestParameters(Map<String, String> additionalRequestParameters) {
        this.additionalRequestParameters = additionalRequestParameters;
    }

    public String getRequestParameterPropertyNameJsObject() {
        if (this.requestParameterPropertyNames != null && !this.requestParameterPropertyNames.isEmpty()) {
            return ScriptUtils.translateValue(this.requestParameterPropertyNames);
        }
        return "{}";
    }

    public String getAdditionalRequestParameterString() {
        if (this.additionalRequestParameters != null) {
            return KRADUtils.getRequestStringFromMap(this.additionalRequestParameters);
        }
        return "";
    }

    public static class LocationSuggestPostData
    extends Suggest.SuggestPostData {
        private static final long serialVersionUID = -4326794621463438438L;
        private String baseUrl;
        private String additionalUrlPathPropertyName;
        private String hrefPropertyName;
        private String objectIdPropertyName;
        private Map<String, String> requestParameterPropertyNames;
        private Map<String, String> additionalRequestParameters;

        public LocationSuggestPostData(LocationSuggest suggest) {
            super(suggest);
            this.baseUrl = suggest.getBaseUrl();
            this.additionalUrlPathPropertyName = suggest.getAdditionalUrlPathPropertyName();
            this.hrefPropertyName = suggest.getHrefPropertyName();
            this.objectIdPropertyName = suggest.getObjectIdPropertyName();
            this.requestParameterPropertyNames = suggest.getRequestParameterPropertyNames();
            this.additionalRequestParameters = suggest.getAdditionalRequestParameters();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getAdditionalUrlPathPropertyName() {
            return this.additionalUrlPathPropertyName;
        }

        public String getHrefPropertyName() {
            return this.hrefPropertyName;
        }

        public String getObjectIdPropertyName() {
            return this.objectIdPropertyName;
        }

        public Map<String, String> getRequestParameterPropertyNames() {
            return this.requestParameterPropertyNames;
        }

        public Map<String, String> getAdditionalRequestParameters() {
            return this.additionalRequestParameters;
        }
    }
}

