/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util.documentserializer;

import java.util.Collection;
import java.util.Map;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityMetadata;
import org.kuali.rice.krad.util.documentserializer.PropertySerializerTrie;
import org.kuali.rice.krad.util.documentserializer.PropertyType;
import org.kuali.rice.krad.util.documentserializer.SerializationState;

public abstract class PropertySerializabilityEvaluatorBase
implements PropertySerializabilityEvaluator {
    protected PropertySerializerTrie serializableProperties;

    @Override
    public void initializeEvaluatorForDocument(Document document) {
    }

    @Override
    public void initializeEvaluatorForDataObject(Object businessObject) {
    }

    @Override
    public PropertyType determinePropertyType(Object propertyValue) {
        if (propertyValue == null) {
            return PropertyType.PRIMITIVE;
        }
        if (propertyValue instanceof BusinessObject) {
            return PropertyType.BUSINESS_OBJECT;
        }
        if (propertyValue instanceof Collection) {
            return PropertyType.COLLECTION;
        }
        if (propertyValue instanceof Map) {
            return PropertyType.MAP;
        }
        return PropertyType.PRIMITIVE;
    }

    @Override
    public boolean isPropertySerializable(SerializationState state, Object containingObject, String childPropertyName, Object childPropertyValue) {
        int i;
        boolean allPropertiesMatched = true;
        PropertySerializabilityMetadata metadata = this.serializableProperties.getRootPropertySerializibilityMetadata();
        for (i = 0; i < state.numPropertyElements(); ++i) {
            String nextPropertyName = state.getElementName(i);
            PropertySerializabilityMetadata nextMetadata = metadata.getSerializableChildProperty(nextPropertyName);
            if (nextMetadata == null) {
                allPropertiesMatched = false;
                break;
            }
            metadata = nextMetadata;
        }
        if (allPropertiesMatched) {
            return this.evaluateCompleteMatch(state, containingObject, metadata, childPropertyName, childPropertyValue);
        }
        return this.evaluatePartialMatch(state, i, containingObject, metadata, childPropertyName, childPropertyValue);
    }

    protected boolean evaluateCompleteMatch(SerializationState state, Object containingObject, PropertySerializabilityMetadata metadata, String childPropertyName, Object childPropertyValue) {
        if (metadata.getPropertySerializability().equals((Object)PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT_AND_ALL_PRIMITIVES) && this.isPrimitiveObject(childPropertyValue)) {
            return true;
        }
        return metadata.getSerializableChildProperty(childPropertyName) != null;
    }

    protected boolean evaluatePartialMatch(SerializationState state, int lastMatchedStateIndex, Object containingObject, PropertySerializabilityMetadata metadata, String childPropertyName, Object childPropertyValue) {
        if (metadata.getPropertySerializability().equals((Object)PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT_AND_ALL_PRIMITIVES)) {
            return this.isPrimitiveObject(childPropertyValue);
        }
        return false;
    }

    protected boolean isPrimitiveObject(Object object) {
        return PropertyType.PRIMITIVE.equals((Object)this.determinePropertyType(object));
    }
}

