/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.MDC;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.AuthenticationService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthenticationException;
import org.kuali.rice.krad.util.KRADUtils;

public class UserLoginFilter
implements Filter {
    private static final String MDC_USER = "user";
    private IdentityService identityService;
    private PermissionService permissionService;
    private ConfigurationService kualiConfigurationService;
    private ParameterService parameterService;
    private FilterConfig filterConfig;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.establishUserSession(request);
            this.establishSessionCookie(request, response);
            this.establishBackdoorUser(request);
            this.addToMDC(request);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.removeFromMDC();
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private void establishUserSession(HttpServletRequest request) {
        if (!this.isUserSessionEstablished(request)) {
            String principalName = ((AuthenticationService)GlobalResourceLoader.getResourceLoader().getService(new QName("kimAuthenticationService"))).getPrincipalName(request);
            if (StringUtils.isBlank((String)principalName)) {
                throw new AuthenticationException("Blank User from AuthenticationService - This should never happen.");
            }
            Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
            if (principal == null) {
                throw new AuthenticationException("Unknown User: " + principalName);
            }
            if (!this.isAuthorizedToLogin(principal.getPrincipalId())) {
                throw new AuthenticationException("You cannot log in, because you are not an active Kuali user.\nPlease ask someone to activate your account if you need to use Kuali Systems.\nThe user id provided was: " + principalName + ".\n");
            }
            UserSession userSession = new UserSession(principalName);
            if (userSession.getPerson() == null) {
                throw new AuthenticationException("Invalid User: " + principalName);
            }
            request.getSession().setAttribute("UserSession", (Object)userSession);
        }
    }

    private boolean isAuthorizedToLogin(String principalId) {
        return this.getPermissionService().isAuthorized(principalId, "KUALI", "Log In Kuali Portal", Collections.singletonMap("principalId", principalId));
    }

    private void establishSessionCookie(HttpServletRequest request, HttpServletResponse response) {
        String kualiSessionId = this.getKualiSessionId(request.getCookies());
        if (kualiSessionId == null) {
            kualiSessionId = UUID.randomUUID().toString();
            response.addCookie(new Cookie("kualiSessionId", kualiSessionId));
        }
        KRADUtils.getUserSessionFromRequest(request).setKualiSessionId(kualiSessionId);
    }

    private String getKualiSessionId(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"kualiSessionId".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void establishBackdoorUser(HttpServletRequest request) {
        String backdoor = request.getParameter("backdoorId");
        if (StringUtils.isNotBlank((String)backdoor) && !this.getKualiConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(this.getKualiConfigurationService().getPropertyValueAsString("environment")) && this.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "Backdoor", "SHOW_BACK_DOOR_LOGIN_IND").booleanValue()) {
            try {
                KRADUtils.getUserSessionFromRequest(request).setBackdoorUser(backdoor);
            }
            catch (RiceRuntimeException riceRuntimeException) {
                // empty catch block
            }
        }
    }

    private void addToMDC(HttpServletRequest request) {
        MDC.put((String)MDC_USER, (Object)KRADUtils.getUserSessionFromRequest(request).getPrincipalName());
    }

    private void removeFromMDC() {
        MDC.remove((String)MDC_USER);
    }

    private boolean isUserSessionEstablished(HttpServletRequest request) {
        return request.getSession().getAttribute("UserSession") != null;
    }

    private IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    private ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    private ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }
}

