/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.ReferenceObjectBindingGenTest;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBo;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoServiceImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReferenceObjectBindingBoServiceImplGenTest {
    private ReferenceObjectBindingBoServiceImpl service;
    private ReferenceObjectBinding referenceObjectBinding;
    private DataObjectService mockDataObjectService = (DataObjectService)Mockito.mock(DataObjectService.class);

    @Before
    public void setUp() {
        this.service = new ReferenceObjectBindingBoServiceImpl();
        this.service.setDataObjectService(this.mockDataObjectService);
    }

    @Test
    public void test_updateReferenceObjectBinding_success() {
        ReferenceObjectBinding data = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        ReferenceObjectBinding findResult = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        ReferenceObjectBindingBo saveResult = this.service.from(ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding());
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)this.service.from(findResult));
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(ReferenceObjectBindingBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.any(PersistenceOption.class)})).thenReturn((Object)saveResult);
        ReferenceObjectBinding updatedData = this.service.updateReferenceObjectBinding(data);
        Assert.assertNotNull((Object)updatedData);
    }

    @Test
    public void test_from_null_yields_null() {
        Assert.assertNull((Object)this.service.from(null));
    }

    @Test
    public void test_from() {
        ReferenceObjectBinding def = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        ReferenceObjectBindingBo def2 = this.service.from(def);
        Assert.assertEquals((Object)def2.getKrmsDiscriminatorType(), (Object)def.getKrmsDiscriminatorType());
        Assert.assertEquals((Object)def2.getKrmsObjectId(), (Object)def.getKrmsObjectId());
        Assert.assertEquals((Object)def2.getNamespace(), (Object)def.getNamespace());
        Assert.assertEquals((Object)def2.getReferenceDiscriminatorType(), (Object)def.getReferenceDiscriminatorType());
        Assert.assertEquals((Object)def2.getReferenceObjectId(), (Object)def.getReferenceObjectId());
        Assert.assertEquals((Object)def2.getId(), (Object)def.getId());
    }

    @Test
    public void test_to() {
        ReferenceObjectBinding def = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        ReferenceObjectBindingBo referenceObjectBindingBo = this.service.from(def);
        ReferenceObjectBinding def2 = ReferenceObjectBindingBo.to((ReferenceObjectBindingBo)referenceObjectBindingBo);
        Assert.assertEquals((Object)def, (Object)def2);
    }

    @Test
    public void test_createReferenceObjectBinding_success() {
        ReferenceObjectBinding findResult = null;
        ReferenceObjectBindingBo saveResult = this.service.from(ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding());
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)this.service.from(findResult));
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(ReferenceObjectBindingBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.any(PersistenceOption.class)})).thenReturn((Object)saveResult);
        ReferenceObjectBinding def = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        ReferenceObjectBinding referenceObjectBinding = this.service.createReferenceObjectBinding(def);
        Assert.assertNotNull((Object)referenceObjectBinding);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByCollectionName_null_fail() {
        this.service.findReferenceObjectBindingsByCollectionName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByKrmsDiscriminatorType_null_fail() {
        this.service.findReferenceObjectBindingsByKrmsDiscriminatorType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByKrmsObject_null_fail() {
        this.service.findReferenceObjectBindingsByKrmsObject(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByNamespace_null_fail() {
        this.service.findReferenceObjectBindingsByNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByReferenceDiscriminatorType_null_fail() {
        this.service.findReferenceObjectBindingsByReferenceDiscriminatorType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByReferenceObject_null_fail() {
        this.service.findReferenceObjectBindingsByReferenceObject(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createReferenceObjectBinding_null_fail() {
        this.service.createReferenceObjectBinding(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateReferenceObjectBinding_null_fail() {
        this.service.updateReferenceObjectBinding(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteReferenceObjectBinding_null_fail() {
        this.service.deleteReferenceObjectBinding(null);
    }

    @Test
    public void test_createReferenceObjectBinding() {
        ReferenceObjectBinding def = ReferenceObjectBindingGenTest.buildFullReferenceObjectBinding();
        this.referenceObjectBinding = this.service.createReferenceObjectBinding(def);
    }

    public ReferenceObjectBinding getReferenceObjectBinding() {
        return this.referenceObjectBinding;
    }

    public void setReferenceObjectBindingBoServiceImpl(ReferenceObjectBindingBoServiceImpl impl) {
        this.service = impl;
    }

    public static ReferenceObjectBindingBoServiceImplGenTest create(ReferenceObjectBindingBoServiceImpl impl) {
        ReferenceObjectBindingBoServiceImplGenTest test = new ReferenceObjectBindingBoServiceImplGenTest();
        test.setReferenceObjectBindingBoServiceImpl(impl);
        return test;
    }
}

