/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;
import org.kuali.rice.krms.impl.ui.CustomOperatorUiTranslator;
import org.kuali.rice.krms.impl.ui.TermParameter;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;

@Entity
@Table(name="KRMS_PROP_T")
public class PropositionBo
implements PropositionDefinitionContract,
Versioned,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    private static final String PROP_SEQ_NAME = "KRMS_PROP_S";
    static final RepositoryBoIncrementer propositionIdIncrementer = new RepositoryBoIncrementer("KRMS_PROP_S");
    static final RepositoryBoIncrementer propositionParameterIdIncrementer = new RepositoryBoIncrementer("KRMS_PROP_PARM_S");
    @PortableSequenceGenerator(name="KRMS_PROP_S")
    @GeneratedValue(generator="KRMS_PROP_S")
    @Id
    @Column(name="PROP_ID")
    private String id;
    @Column(name="DESC_TXT")
    private String description;
    @Column(name="RULE_ID")
    private String ruleId;
    @Column(name="TYP_ID")
    private String typeId;
    @Column(name="DSCRM_TYP_CD")
    private String propositionTypeCode;
    @PrivateOwned
    @OneToMany(orphanRemoval=true, targetEntity=PropositionParameterBo.class, mappedBy="proposition", cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @OrderBy(value="sequenceNumber")
    private List<PropositionParameterBo> parameters = new ArrayList<PropositionParameterBo>();
    @Column(name="CMPND_OP_CD")
    private String compoundOpCode;
    @Column(name="CMPND_SEQ_NO")
    private Integer compoundSequenceNumber;
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    @OneToMany(targetEntity=PropositionBo.class, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinTable(name="KRMS_CMPND_PROP_PROPS_T", joinColumns={@JoinColumn(name="CMPND_PROP_ID", referencedColumnName="PROP_ID")}, inverseJoinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="PROP_ID")})
    @OrderBy(value="compoundSequenceNumber")
    private List<PropositionBo> compoundComponents;
    @Transient
    private String parameterDisplayString;
    @Transient
    private boolean editMode = false;
    @Transient
    private String categoryId;
    @Transient
    private String termSpecId;
    @Transient
    private boolean showCustomValue;
    @Transient
    private String termParameter;
    @Transient
    private List<TermParameter> termParameterList = new ArrayList<TermParameter>();
    @Transient
    private String newTermDescription = "new term " + UUID.randomUUID().toString();
    @Transient
    private Map<String, String> termParameters = new HashMap<String, String>();
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    private void setupParameterDisplayString() {
        List<PropositionParameterBo> parameters;
        if (PropositionType.SIMPLE.getCode().equalsIgnoreCase(this.getPropositionTypeCode()) && (parameters = this.getParameters()) != null && parameters.size() == 3) {
            StringBuilder sb = new StringBuilder();
            String valueDisplay = this.getParamValue(parameters.get(1));
            String lhs = this.getParamValue(parameters.get(0));
            String opr = this.getParamValue(parameters.get(2));
            sb.append(ScriptUtils.escapeHtml((String)lhs)).append(" ").append(opr);
            if (opr != null && (opr.equals("!=null") || opr.equals("=null"))) {
                valueDisplay = null;
            }
            if (valueDisplay != null) {
                sb.append(" ").append(ScriptUtils.escapeHtml((String)valueDisplay));
            }
            this.setParameterDisplayString(sb.toString());
        }
    }

    private String getParamValue(PropositionParameterBo param) {
        String functionName;
        CustomOperatorUiTranslator customOperatorUiTranslator = KrmsServiceLocatorInternal.getCustomOperatorUiTranslator();
        if (PropositionParameterType.TERM.getCode().equalsIgnoreCase(param.getParameterType())) {
            String termName = "";
            String termId = param.getValue();
            if (termId != null && termId.length() > 0) {
                if (termId.startsWith("parameterized:")) {
                    if (!StringUtils.isBlank((String)this.newTermDescription)) {
                        termName = this.newTermDescription;
                    } else {
                        TermSpecificationBo termSpec = (TermSpecificationBo)this.getDataObjectService().find(TermSpecificationBo.class, (Object)termId.substring(1 + termId.indexOf(":")));
                        termName = termSpec.getName() + "(...)";
                    }
                } else {
                    TermBo term = (TermBo)this.getDataObjectService().find(TermBo.class, (Object)termId);
                    termName = term.getSpecification().getName();
                }
            }
            return termName;
        }
        if ((PropositionParameterType.FUNCTION.getCode().equalsIgnoreCase(param.getParameterType()) || PropositionParameterType.OPERATOR.getCode().equalsIgnoreCase(param.getParameterType())) && customOperatorUiTranslator.isCustomOperatorFormValue(param.getValue()) && !StringUtils.isEmpty((String)(functionName = customOperatorUiTranslator.getCustomOperatorName(param.getValue())))) {
            return functionName;
        }
        return param.getValue();
    }

    public String getParameterDisplayString() {
        this.setupParameterDisplayString();
        return this.parameterDisplayString;
    }

    public void setParameterDisplayString(String parameterDisplayString) {
        this.parameterDisplayString = parameterDisplayString;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setTypeId(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            this._persistence_set_typeId(null);
        } else {
            this._persistence_set_typeId(typeId);
        }
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public Map<String, String> getTermParameters() {
        return this.termParameters;
    }

    public void setTermParameters(Map<String, String> termParameters) {
        this.termParameters = termParameters;
    }

    public DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }

    public static PropositionDefinition to(PropositionBo bo) {
        if (bo == null) {
            return null;
        }
        return PropositionDefinition.Builder.create((PropositionDefinitionContract)bo).build();
    }

    public static PropositionBo from(PropositionDefinition im) {
        if (im == null) {
            return null;
        }
        PropositionBo bo = new PropositionBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_description(im.getDescription());
        bo.setRuleId(im.getRuleId());
        bo._persistence_set_typeId(im.getTypeId());
        bo._persistence_set_propositionTypeCode(im.getPropositionTypeCode());
        bo._persistence_set_parameters(new ArrayList());
        for (PropositionParameter parm : im.getParameters()) {
            PropositionParameterBo parmBo = PropositionParameterBo.from(parm);
            bo._persistence_get_parameters().add(parmBo);
            parmBo.setProposition(bo);
        }
        bo._persistence_set_compoundOpCode(im.getCompoundOpCode());
        bo._persistence_set_compoundSequenceNumber(im.getCompoundSequenceNumber());
        bo._persistence_set_compoundComponents(new ArrayList());
        if (im.getCompoundComponents() != null) {
            for (PropositionDefinition prop : im.getCompoundComponents()) {
                bo._persistence_get_compoundComponents().add(PropositionBo.from(prop));
            }
        }
        bo._persistence_set_versionNumber(im.getVersionNumber());
        return bo;
    }

    public static PropositionBo createSimplePropositionBoStub(PropositionBo sibling, String pType) {
        PropositionBo prop = null;
        if (PropositionType.SIMPLE.getCode().equalsIgnoreCase(pType)) {
            prop = new PropositionBo();
            prop.setId(propositionIdIncrementer.getNewId());
            prop.setPropositionTypeCode(pType);
            prop.setEditMode(true);
            if (sibling != null) {
                prop.setRuleId(sibling.getRuleId());
            }
            PropositionParameterBo pTerm = new PropositionParameterBo();
            pTerm.setId(propositionParameterIdIncrementer.getNewId());
            pTerm.setParameterType("T");
            pTerm.setProposition(prop);
            pTerm.setSequenceNumber(new Integer("0"));
            pTerm.setVersionNumber(new Long(1L));
            pTerm.setValue("");
            PropositionParameterBo pOp = new PropositionParameterBo();
            pOp.setId(propositionParameterIdIncrementer.getNewId());
            pOp.setParameterType("O");
            pOp.setProposition(prop);
            pOp.setSequenceNumber(new Integer("2"));
            pOp.setVersionNumber(new Long(1L));
            PropositionParameterBo pConst = new PropositionParameterBo();
            pConst.setId(propositionParameterIdIncrementer.getNewId());
            pConst.setParameterType("C");
            pConst.setProposition(prop);
            pConst.setSequenceNumber(new Integer("1"));
            pConst.setVersionNumber(new Long(1L));
            pConst.setValue("");
            ArrayList<PropositionParameterBo> paramList = new ArrayList<PropositionParameterBo>(3);
            paramList.add(pTerm);
            paramList.add(pConst);
            paramList.add(pOp);
            prop.setParameters(paramList);
        }
        return prop;
    }

    public static PropositionBo createCompoundPropositionBoStub(PropositionBo existing, boolean addNewChild) {
        PropositionBo prop = new PropositionBo();
        prop.setId(propositionIdIncrementer.getNewId());
        prop.setPropositionTypeCode(PropositionType.COMPOUND.getCode());
        prop.setCompoundOpCode(LogicalOperator.AND.getCode());
        prop.setDescription("");
        prop.setEditMode(true);
        if (existing != null) {
            prop.setRuleId(existing.getRuleId());
        }
        ArrayList<PropositionBo> components = new ArrayList<PropositionBo>(2);
        components.add(existing);
        if (addNewChild) {
            PropositionBo newProp = PropositionBo.createSimplePropositionBoStub(existing, PropositionType.SIMPLE.getCode());
            components.add(newProp);
            prop.setEditMode(false);
        }
        prop.setCompoundComponents(components);
        return prop;
    }

    public static PropositionBo createCompoundPropositionBoStub2(PropositionBo existing) {
        PropositionBo prop = new PropositionBo();
        prop.setId(propositionIdIncrementer.getNewId());
        prop.setPropositionTypeCode(PropositionType.COMPOUND.getCode());
        prop.setRuleId(existing.getRuleId());
        prop.setCompoundOpCode(LogicalOperator.AND.getCode());
        prop.setDescription("");
        prop.setEditMode(true);
        ArrayList<PropositionBo> components = new ArrayList<PropositionBo>();
        components.add(existing);
        prop.setCompoundComponents(components);
        return prop;
    }

    public static PropositionBo copyProposition(PropositionBo existing) {
        PropositionBo newProp = new PropositionBo();
        newProp.setId(propositionIdIncrementer.getNewId());
        newProp.setDescription(existing.getDescription());
        newProp.setPropositionTypeCode(existing.getPropositionTypeCode());
        newProp.setTypeId(existing.getTypeId());
        newProp.setCompoundOpCode(existing.getCompoundOpCode());
        newProp.setCompoundSequenceNumber(existing.getCompoundSequenceNumber());
        ArrayList<PropositionParameterBo> newParms = new ArrayList<PropositionParameterBo>();
        for (PropositionParameterBo parm : existing.getParameters()) {
            PropositionParameterBo p = new PropositionParameterBo();
            p.setId(propositionParameterIdIncrementer.getNewId());
            p.setParameterType(parm.getParameterType());
            p.setProposition(newProp);
            p.setSequenceNumber(parm.getSequenceNumber());
            p.setValue(parm.getValue());
            newParms.add(p);
        }
        newProp.setParameters(newParms);
        ArrayList<PropositionBo> newCompoundComponents = new ArrayList<PropositionBo>();
        for (PropositionBo component : existing.getCompoundComponents()) {
            PropositionBo newComponent = PropositionBo.copyProposition(component);
            newCompoundComponents.add(newComponent);
        }
        newProp.setCompoundComponents(newCompoundComponents);
        return newProp;
    }

    public String getTermSpecId() {
        return this.termSpecId;
    }

    public void setTermSpecId(String componentId) {
        this.termSpecId = componentId;
    }

    public boolean isShowCustomValue() {
        return this.showCustomValue;
    }

    public void setShowCustomValue(boolean showCustomValue) {
        this.showCustomValue = showCustomValue;
    }

    public String getTermParameter() {
        return this.termParameter;
    }

    public void setTermParameter(String termParameter) {
        this.termParameter = termParameter;
    }

    public List<TermParameter> getTermParameterList() {
        return this.termParameterList;
    }

    public void setTermParameterList(List<TermParameter> termParameterList) {
        this.termParameterList = termParameterList;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getRuleId() {
        return this._persistence_get_ruleId();
    }

    public void setRuleId(String ruleId) {
        this._persistence_set_ruleId(ruleId);
        if (this.getCompoundComponents() != null) {
            for (PropositionBo child : this.getCompoundComponents()) {
                child.setRuleId(ruleId);
            }
        }
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public String getPropositionTypeCode() {
        return this._persistence_get_propositionTypeCode();
    }

    public void setPropositionTypeCode(String propositionTypeCode) {
        this._persistence_set_propositionTypeCode(propositionTypeCode);
    }

    public List<PropositionParameterBo> getParameters() {
        return this._persistence_get_parameters();
    }

    public void setParameters(List<PropositionParameterBo> parameters) {
        this._persistence_set_parameters(parameters);
    }

    public String getCompoundOpCode() {
        return this._persistence_get_compoundOpCode();
    }

    public void setCompoundOpCode(String compoundOpCode) {
        this._persistence_set_compoundOpCode(compoundOpCode);
    }

    public Integer getCompoundSequenceNumber() {
        return this._persistence_get_compoundSequenceNumber();
    }

    public void setCompoundSequenceNumber(Integer compoundSequenceNumber) {
        this._persistence_set_compoundSequenceNumber(compoundSequenceNumber);
    }

    public List<PropositionBo> getCompoundComponents() {
        return this._persistence_get_compoundComponents();
    }

    public void setCompoundComponents(List<PropositionBo> compoundComponents) {
        this._persistence_set_compoundComponents(compoundComponents);
    }

    public boolean getShowCustomValue() {
        return this.showCustomValue;
    }

    public String getNewTermDescription() {
        return this.newTermDescription;
    }

    public void setNewTermDescription(String newTermDescription) {
        this.newTermDescription = newTermDescription;
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PropositionBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "compoundOpCode") {
            return this.compoundOpCode;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "ruleId") {
            return this.ruleId;
        }
        if (string == "propositionTypeCode") {
            return this.propositionTypeCode;
        }
        if (string == "compoundSequenceNumber") {
            return this.compoundSequenceNumber;
        }
        if (string == "parameters") {
            return this.parameters;
        }
        if (string == "compoundComponents") {
            return this.compoundComponents;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "compoundOpCode") {
            this.compoundOpCode = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "ruleId") {
            this.ruleId = (String)object;
            return;
        }
        if (string == "propositionTypeCode") {
            this.propositionTypeCode = (String)object;
            return;
        }
        if (string == "compoundSequenceNumber") {
            this.compoundSequenceNumber = (Integer)object;
            return;
        }
        if (string == "parameters") {
            this.parameters = (List)object;
            return;
        }
        if (string == "compoundComponents") {
            this.compoundComponents = (List)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_compoundOpCode() {
        this._persistence_checkFetched("compoundOpCode");
        return this.compoundOpCode;
    }

    public void _persistence_set_compoundOpCode(String string) {
        this._persistence_checkFetchedForSet("compoundOpCode");
        this._persistence_propertyChange("compoundOpCode", this.compoundOpCode, string);
        this.compoundOpCode = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public String _persistence_get_ruleId() {
        this._persistence_checkFetched("ruleId");
        return this.ruleId;
    }

    public void _persistence_set_ruleId(String string) {
        this._persistence_checkFetchedForSet("ruleId");
        this._persistence_propertyChange("ruleId", this.ruleId, string);
        this.ruleId = string;
    }

    public String _persistence_get_propositionTypeCode() {
        this._persistence_checkFetched("propositionTypeCode");
        return this.propositionTypeCode;
    }

    public void _persistence_set_propositionTypeCode(String string) {
        this._persistence_checkFetchedForSet("propositionTypeCode");
        this._persistence_propertyChange("propositionTypeCode", this.propositionTypeCode, string);
        this.propositionTypeCode = string;
    }

    public Integer _persistence_get_compoundSequenceNumber() {
        this._persistence_checkFetched("compoundSequenceNumber");
        return this.compoundSequenceNumber;
    }

    public void _persistence_set_compoundSequenceNumber(Integer n) {
        this._persistence_checkFetchedForSet("compoundSequenceNumber");
        this._persistence_propertyChange("compoundSequenceNumber", this.compoundSequenceNumber, n);
        this.compoundSequenceNumber = n;
    }

    public List _persistence_get_parameters() {
        this._persistence_checkFetched("parameters");
        return this.parameters;
    }

    public void _persistence_set_parameters(List list) {
        this._persistence_checkFetchedForSet("parameters");
        this._persistence_propertyChange("parameters", this.parameters, list);
        this.parameters = list;
    }

    public List _persistence_get_compoundComponents() {
        this._persistence_checkFetched("compoundComponents");
        return this.compoundComponents;
    }

    public void _persistence_set_compoundComponents(List list) {
        this._persistence_checkFetchedForSet("compoundComponents");
        this._persistence_propertyChange("compoundComponents", this.compoundComponents, list);
        this.compoundComponents = list;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, string);
        this.typeId = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

