/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.dao.impl;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;

public class MessageQueueDAOJpaImpl
implements MessageQueueDAO {
    private static final Logger LOG = Logger.getLogger(MessageQueueDAOJpaImpl.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<PersistedMessageBO> findAll() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Returning all persisted messages");
        }
        Query query = this.entityManager.createNamedQuery("PersistedMessageBO.FindAll");
        return query.getResultList();
    }

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding next " + maxRows + " messages"));
        }
        Query query = this.entityManager.createNamedQuery("PersistedMessageBO.FindAll");
        query.setMaxResults(maxRows);
        return query.getResultList();
    }

    @Override
    public PersistedMessagePayload findByPersistedMessageByRouteQueueId(Long routeQueueId) {
        return (PersistedMessagePayload)this.entityManager.find(PersistedMessagePayload.class, (Object)routeQueueId);
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        return (PersistedMessageBO)this.entityManager.find(PersistedMessageBO.class, (Object)routeQueueId);
    }

    @Override
    public List<PersistedMessageBO> findByServiceName(QName serviceName, String methodName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding messages for service name " + serviceName));
        }
        Query query = this.entityManager.createNamedQuery("PersistedMessageBO.FindByServiceName");
        query.setParameter("serviceName", (Object)serviceName.toString());
        query.setParameter("methodName", (Object)methodName);
        return query.getResultList();
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        Criteria criteria = new Criteria(PersistedMessageBO.class.getName());
        for (Map.Entry<String, String> entry : criteriaValues.entrySet()) {
            criteria.eq(entry.getKey(), (Object)entry.getValue());
        }
        QueryByCriteria query = new QueryByCriteria(this.entityManager, criteria);
        return query.toQuery().getResultList();
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        String applicationId = CoreConfigHelper.getApplicationId();
        Query query = this.entityManager.createNamedQuery("PersistedMessageBO.GetNextDocuments");
        query.setParameter("applicationId", (Object)applicationId);
        query.setParameter("queueStatus", (Object)"E");
        query.setParameter("ipNumber", (Object)RiceUtilities.getIpNumber());
        if (maxDocuments != null) {
            query.setMaxResults(maxDocuments.intValue());
        }
        return query.getResultList();
    }

    @Override
    public void remove(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing message " + routeQueue));
        }
        if (routeQueue.getRouteQueueId() == null) {
            throw new RiceRuntimeException("can't delete a PersistedMessageBO with no id");
        }
        routeQueue = (PersistedMessageBO)this.entityManager.merge((Object)routeQueue);
        this.entityManager.remove((Object)routeQueue);
        if (routeQueue.getPayload() != null) {
            PersistedMessagePayload payload = (PersistedMessagePayload)this.entityManager.merge((Object)routeQueue.getPayload());
            this.entityManager.remove((Object)payload);
        }
    }

    @Override
    public void save(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Persisting message " + routeQueue));
        }
        PersistedMessageBO jpaInstance = (PersistedMessageBO)this.entityManager.merge((Object)routeQueue);
        Long routeQueueId = jpaInstance.getRouteQueueId();
        Integer verNo = jpaInstance.getLockVerNbr();
        routeQueue.setRouteQueueId(routeQueueId);
        routeQueue.setLockVerNbr(verNo);
        if (routeQueue.getPayload() != null) {
            routeQueue.getPayload().setRouteQueueId(routeQueueId);
            this.entityManager.merge((Object)routeQueue.getPayload());
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

