/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.dao.impl;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class MessageQueueDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements MessageQueueDAO {
    private static final Logger LOG = Logger.getLogger(MessageQueueDAOOjbImpl.class);

    @Override
    public void remove(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing message " + routeQueue));
        }
        Criteria crit = new Criteria();
        crit.addEqualTo("routeQueueId", (Object)routeQueue.getRouteQueueId());
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(PersistedMessageBO.class, crit));
        crit = new Criteria();
        crit.addEqualTo("routeQueueId", (Object)routeQueue.getPayload().getRouteQueueId());
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(PersistedMessagePayload.class, crit));
    }

    @Override
    public void save(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Persisting message " + routeQueue));
        }
        this.getPersistenceBrokerTemplate().store((Object)routeQueue);
        routeQueue.getPayload().setRouteQueueId(routeQueue.getRouteQueueId());
        this.getPersistenceBrokerTemplate().store((Object)routeQueue.getPayload());
    }

    @Override
    public List<PersistedMessageBO> findAll() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Returning all persisted messages");
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PersistedMessageBO.class));
    }

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding next " + maxRows + " messages"));
        }
        QueryByCriteria query = new QueryByCriteria(PersistedMessageBO.class);
        query.setStartAtIndex(0);
        query.setEndAtIndex(maxRows);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        Criteria crit = new Criteria();
        String value = null;
        for (String key : criteriaValues.keySet()) {
            value = criteriaValues.get(key);
            if (StringUtils.isBlank((String)key) && StringUtils.isBlank((String)value)) {
                throw new IllegalArgumentException("Either the key or value was blank in criteriaValues (" + key + "=" + value + ")");
            }
            if (!key.equals("routeQueueId")) {
                value = value.contains("*") ? value.replace("*", "%") : value.concat("%");
            }
            if (StringUtils.containsOnly((String)value, (String)"%")) continue;
            crit.addLike((Object)key, (Object)value);
        }
        QueryByCriteria query = new QueryByCriteria(PersistedMessageBO.class, crit);
        query.setFetchSize(maxRows);
        query.setStartAtIndex(0);
        query.setEndAtIndex(maxRows);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("routeQueueId", (Object)routeQueueId);
        return (PersistedMessageBO)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(PersistedMessageBO.class, criteria));
    }

    @Override
    public PersistedMessagePayload findByPersistedMessageByRouteQueueId(Long routeQueueId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("routeQueueId", (Object)routeQueueId);
        return (PersistedMessagePayload)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(PersistedMessagePayload.class, criteria));
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        Criteria crit = new Criteria();
        String applicationId = CoreConfigHelper.getApplicationId();
        crit.addEqualTo("applicationId", (Object)applicationId);
        crit.addNotEqualTo((Object)"queueStatus", (Object)"E");
        crit.addEqualTo("ipNumber", (Object)RiceUtilities.getIpNumber());
        QueryByCriteria query = new QueryByCriteria(PersistedMessageBO.class, crit);
        query.addOrderByAscending("queuePriority");
        query.addOrderByAscending("routeQueueId");
        query.addOrderByAscending("queueDate");
        if (maxDocuments != null) {
            query.setEndAtIndex(maxDocuments.intValue());
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public List<PersistedMessageBO> findByServiceName(QName serviceName, String methodName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding messages for service name " + serviceName));
        }
        Criteria crit = new Criteria();
        crit.addEqualTo("serviceName", (Object)serviceName.toString());
        crit.addEqualTo("methodName", (Object)methodName);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PersistedMessageBO.class, crit));
    }
}

