/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.net.URL;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.BusClientFailureProxy;
import org.kuali.rice.ksb.messaging.bam.BAMClientProxy;
import org.kuali.rice.ksb.messaging.serviceconnectors.ServiceConnector;
import org.springframework.util.Assert;

public abstract class AbstractServiceConnector
implements ServiceConnector {
    private ServiceConfiguration serviceConfiguration;
    private URL alternateEndpointUrl;
    private CredentialsSource credentialsSource;

    public AbstractServiceConnector(ServiceConfiguration serviceConfiguration) {
        this(serviceConfiguration, null);
    }

    public AbstractServiceConnector(ServiceConfiguration serviceConfiguration, URL alternateEndpointUrl) {
        Assert.notNull((Object)serviceConfiguration, (String)"serviceConfiguration cannot be null");
        this.serviceConfiguration = serviceConfiguration;
        this.alternateEndpointUrl = alternateEndpointUrl;
    }

    public URL getActualEndpointUrl() {
        if (this.alternateEndpointUrl != null) {
            return this.alternateEndpointUrl;
        }
        return this.getServiceConfiguration().getEndpointUrl();
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    @Override
    public void setCredentialsSource(CredentialsSource credentialsSource) {
        this.credentialsSource = credentialsSource;
    }

    protected CredentialsSource getCredentialsSource() {
        return this.credentialsSource;
    }

    protected Object getServiceProxyWithFailureMode(Object service, ServiceConfiguration serviceConfiguration) {
        Object bamWrappedClientProxy = BAMClientProxy.wrap(service, serviceConfiguration);
        return BusClientFailureProxy.wrap(bamWrappedClientProxy, serviceConfiguration);
    }
}

