/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.messaging.HttpClientHelper;
import org.kuali.rice.ksb.messaging.KSBHttpInvokerProxyFactoryBean;
import org.kuali.rice.ksb.messaging.KSBHttpInvokerRequestExecutor;
import org.kuali.rice.ksb.messaging.serviceconnectors.AbstractServiceConnector;
import org.kuali.rice.ksb.security.httpinvoker.AuthenticationCommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class HttpInvokerConnector
extends AbstractServiceConnector {
    private static final Logger LOG = Logger.getLogger(HttpInvokerConnector.class);
    private HttpClientParams httpClientParams;
    private boolean httpClientInitialized = false;
    private static final String IDLE_CONNECTION_THREAD_INTERVAL_PROPERTY = "ksb.thinClient.idleConnectionThreadInterval";
    private static final String IDLE_CONNECTION_TIMEOUT_PROPERTY = "ksb.thinClient.idleConnectionTimeout";
    private static final String DEFAULT_IDLE_CONNECTION_THREAD_INTERVAL = "7500";
    private static final String DEFAULT_IDLE_CONNECTION_TIMEOUT = "5000";
    private static final String RETRY_SOCKET_EXCEPTION_PROPERTY = "ksb.thinClient.retrySocketException";
    private static IdleConnectionTimeoutThread ictt;

    public HttpInvokerConnector(JavaServiceConfiguration serviceConfiguration, URL alternateEndpointUrl) {
        super((ServiceConfiguration)serviceConfiguration, alternateEndpointUrl);
        this.initializeHttpClientParams();
    }

    public JavaServiceConfiguration getServiceConfiguration() {
        return (JavaServiceConfiguration)super.getServiceConfiguration();
    }

    @Override
    public Object getService() {
        LOG.debug((Object)("Getting connector for endpoint " + this.getActualEndpointUrl()));
        KSBHttpInvokerProxyFactoryBean client = new KSBHttpInvokerProxyFactoryBean();
        client.setServiceUrl(this.getActualEndpointUrl().toExternalForm());
        client.setServiceConfiguration(this.getServiceConfiguration());
        KSBHttpInvokerRequestExecutor executor = this.getCredentialsSource() != null ? new AuthenticationCommonsHttpInvokerRequestExecutor(this.getHttpClient(), this.getCredentialsSource(), (ServiceConfiguration)this.getServiceConfiguration()) : new KSBHttpInvokerRequestExecutor(this.getHttpClient());
        executor.setSecure(this.getServiceConfiguration().getBusSecurity());
        client.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)executor);
        client.afterPropertiesSet();
        return this.getServiceProxyWithFailureMode(client.getObject(), (ServiceConfiguration)this.getServiceConfiguration());
    }

    public HttpClient getHttpClient() {
        return new HttpClient(this.httpClientParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeHttpClientParams() {
        Class<HttpInvokerConnector> clazz = HttpInvokerConnector.class;
        synchronized (HttpInvokerConnector.class) {
            if (!this.httpClientInitialized) {
                this.httpClientParams = new HttpClientParams();
                this.configureDefaultHttpClientParams((HttpParams)this.httpClientParams);
                Properties configProps = ConfigContext.getCurrentContextConfig().getProperties();
                for (String string : configProps.keySet()) {
                    if (!string.startsWith("http.")) continue;
                    HttpClientHelper.setParameter((HttpParams)this.httpClientParams, string, (String)configProps.get(string));
                }
                this.runIdleConnectionTimeout();
                this.httpClientInitialized = true;
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    protected void configureDefaultHttpClientParams(HttpParams params) {
        params.setParameter("http.connection-manager.class", MultiThreadedHttpConnectionManager.class);
        params.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        params.setLongParameter("http.connection-manager.timeout", 10000L);
        HashMap<HostConfiguration, Integer> maxHostConnectionsMap = new HashMap<HostConfiguration, Integer>();
        maxHostConnectionsMap.put(HostConfiguration.ANY_HOST_CONFIGURATION, new Integer(20));
        params.setParameter("http.connection-manager.max-per-host", maxHostConnectionsMap);
        params.setIntParameter("http.connection-manager.max-total", 20);
        params.setIntParameter("http.connection.timeout", 10000);
        params.setIntParameter("http.socket.timeout", 120000);
        boolean retrySocketException = new Boolean(ConfigContext.getCurrentContextConfig().getProperty(RETRY_SOCKET_EXCEPTION_PROPERTY));
        if (retrySocketException) {
            LOG.info((Object)"Installing custom HTTP retry handler to retry requests in face of SocketExceptions");
            params.setParameter("http.method.retry-handler", (Object)new CustomHttpMethodRetryHandler());
        }
    }

    private void runIdleConnectionTimeout() {
        if (ictt != null) {
            String connectionTimeout;
            String timeoutInterval = ConfigContext.getCurrentContextConfig().getProperty(IDLE_CONNECTION_THREAD_INTERVAL_PROPERTY);
            if (StringUtils.isBlank((String)timeoutInterval)) {
                timeoutInterval = DEFAULT_IDLE_CONNECTION_THREAD_INTERVAL;
            }
            if (StringUtils.isBlank((String)(connectionTimeout = ConfigContext.getCurrentContextConfig().getProperty(IDLE_CONNECTION_TIMEOUT_PROPERTY)))) {
                connectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
            }
            ictt.addConnectionManager(this.getHttpClient().getHttpConnectionManager());
            ictt.setTimeoutInterval((long)new Integer(timeoutInterval).intValue());
            ictt.setConnectionTimeout((long)new Integer(connectionTimeout).intValue());
            ictt.start();
        }
    }

    public static void shutdownIdleConnectionTimeout() {
        if (ictt != null) {
            try {
                ictt.shutdown();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to shutdown idle connection thread.", (Throwable)e);
            }
        }
    }

    private static final class CustomHttpMethodRetryHandler
    extends DefaultHttpMethodRetryHandler {
        private static final int MAX_RETRIES = 1;

        public CustomHttpMethodRetryHandler() {
            super(1, true);
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            boolean shouldRetry = super.retryMethod(method, exception, executionCount);
            if (!shouldRetry && executionCount < 1) {
                if (exception instanceof SocketException) {
                    LOG.warn((Object)"Retrying request because of SocketException!", (Throwable)exception);
                    shouldRetry = true;
                } else if (exception instanceof SocketTimeoutException) {
                    LOG.warn((Object)"Retrying request because of SocketTimeoutException!", (Throwable)exception);
                    shouldRetry = true;
                }
            }
            return shouldRetry;
        }
    }
}

