/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.security.admin.KeyStoreEntryDataContainer;
import org.kuali.rice.ksb.security.admin.service.JavaSecurityManagementService;
import org.springframework.beans.factory.InitializingBean;

public class JavaSecurityManagementServiceImpl
implements JavaSecurityManagementService,
InitializingBean {
    protected final String CLIENT_KEY_GENERATOR_ALGORITHM = "RSA";
    protected final String CLIENT_SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    protected final int CLIENT_KEY_PAIR_KEY_SIZE = 512;
    private final int CLIENT_CERT_EXPIRATION_DAYS = 9999;
    private static final String MODULE_SHA_RSA_ALGORITHM = "SHA1withRSA";
    private static final String MODULE_JKS_TYPE = "JKS";
    private String moduleKeyStoreLocation;
    private String moduleKeyStoreAlias;
    private String moduleKeyStorePassword;
    private KeyStore moduleKeyStore;
    private PrivateKey modulePrivateKey;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((String)this.getModuleKeyStoreLocation())) {
            this.setModuleKeyStoreLocation(ConfigContext.getCurrentContextConfig().getKeystoreFile());
        }
        if (StringUtils.isEmpty((String)this.getModuleKeyStoreAlias())) {
            this.setModuleKeyStoreAlias(ConfigContext.getCurrentContextConfig().getKeystoreAlias());
        }
        if (StringUtils.isEmpty((String)this.getModuleKeyStorePassword())) {
            this.setModuleKeyStorePassword(ConfigContext.getCurrentContextConfig().getKeystorePassword());
        }
        this.verifyConfiguration();
        this.moduleKeyStore = this.loadKeyStore();
        this.modulePrivateKey = this.loadPrivateKey();
    }

    protected void verifyConfiguration() {
        if (StringUtils.isEmpty((String)this.getModuleKeyStoreLocation())) {
            throw new RuntimeException("Value for configuration parameter 'keystore.file' could not be found.  Please ensure that the keystore is configured properly.");
        }
        if (StringUtils.isEmpty((String)this.getModuleKeyStoreAlias())) {
            throw new RuntimeException("Value for configuration parameter 'keystore.alias' could not be found.  Please ensure that the keystore is configured properly.");
        }
        if (StringUtils.isEmpty((String)this.getModuleKeyStorePassword())) {
            throw new RuntimeException("Value for configuration parameter 'keystore.password' could not be found.  Please ensure that the keystore is configured properly.");
        }
        File keystoreFile = new File(this.getModuleKeyStoreLocation());
        if (!keystoreFile.exists()) {
            throw new RuntimeException("Value for configuration parameter 'keystore.file' is invalid.  The file does not exist on the filesystem, location was: '" + this.getModuleKeyStoreLocation() + "'");
        }
        if (!keystoreFile.canRead()) {
            throw new RuntimeException("Value for configuration parameter 'keystore.file' is invalid.  The file exists but is not readable (please check permissions), location was: '" + this.getModuleKeyStoreLocation() + "'");
        }
    }

    protected KeyStore loadKeyStore() throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        block4: {
            keyStore = KeyStore.getInstance(this.getModuleKeyStoreType());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(this.getModuleKeyStoreLocation());
                keyStore.load(stream, this.getModuleKeyStorePassword().toCharArray());
                stream.close();
            }
            catch (Exception e) {
                if (stream == null) break block4;
                try {
                    stream.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        return keyStore;
    }

    protected PrivateKey loadPrivateKey() throws GeneralSecurityException {
        return (PrivateKey)this.getModuleKeyStore().getKey(this.getModuleKeyStoreAlias(), this.getModuleKeyStorePassword().toCharArray());
    }

    @Override
    public void removeClientCertificate(String alias) throws KeyStoreException {
        KeyStore moduleKeyStore = this.getModuleKeyStore();
        if (!moduleKeyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
            throw new RuntimeException("Only entries of type " + KeyStoreEntryDataContainer.DISPLAYABLE_ENTRY_TYPES.get(KeyStore.TrustedCertificateEntry.class) + " can be removed");
        }
        this.getModuleKeyStore().deleteEntry(alias);
    }

    protected void addClientCertificateToModuleKeyStore(String alias, Certificate clientCertificate) throws KeyStoreException {
        this.getModuleKeyStore().setEntry(alias, new KeyStore.TrustedCertificateEntry(clientCertificate), null);
    }

    @Override
    public boolean isAliasInKeystore(String alias) throws KeyStoreException {
        return this.getModuleKeyStore().containsAlias(alias);
    }

    @Override
    public String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        return this.getModuleKeyStore().getCertificateAlias(certificate);
    }

    @Override
    public KeyStore generateClientKeystore(String alias, String clientPassphrase) throws GeneralSecurityException {
        if (this.isAliasInKeystore(alias)) {
            throw new KeyStoreException("Alias '" + alias + "' already exists in module keystore");
        }
        KeyStore ks = null;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(512);
            KeyPair pair = keyGen.generateKeyPair();
            Certificate cert = this.generateCertificate(pair, alias);
            ks = this.generateKeyStore(cert, pair.getPrivate(), alias, clientPassphrase);
            ks.setEntry(this.getModuleKeyStoreAlias(), new KeyStore.TrustedCertificateEntry(this.getCertificate(this.getModuleKeyStoreAlias())), null);
            this.addClientCertificateToModuleKeyStore(alias, cert);
            return ks;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create new KeyStore", e);
        }
    }

    protected Certificate generateCertificate(KeyPair keyPair, String alias) throws GeneralSecurityException {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        certificateGenerator.setSignatureAlgorithm("MD5WithRSA");
        certificateGenerator.setSerialNumber(new BigInteger("1"));
        X509Principal nameInfo = new X509Principal("CN=" + alias);
        certificateGenerator.setIssuerDN((X509Name)nameInfo);
        certificateGenerator.setSubjectDN((X509Name)nameInfo);
        certificateGenerator.setNotBefore(new Date());
        Calendar c = Calendar.getInstance();
        c.add(5, 9999);
        certificateGenerator.setNotAfter(c.getTime());
        certificateGenerator.setPublicKey(keyPair.getPublic());
        return certificateGenerator.generate(keyPair.getPrivate(), BouncyCastleProvider.PROVIDER_NAME);
    }

    protected KeyStore generateKeyStore(Certificate cert, PrivateKey privateKey, String alias, String keyStorePassword) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(this.getModuleKeyStoreType());
        ks.load(null, keyStorePassword.toCharArray());
        ks.setEntry(alias, new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{cert}), new KeyStore.PasswordProtection(keyStorePassword.toCharArray()));
        return ks;
    }

    @Override
    public List<KeyStoreEntryDataContainer> getListOfModuleKeyStoreEntries() {
        ArrayList<KeyStoreEntryDataContainer> keyStoreEntries = new ArrayList<KeyStoreEntryDataContainer>();
        try {
            KeyStore moduleKeyStore = this.getModuleKeyStore();
            Enumeration<String> enumer = moduleKeyStore.aliases();
            while (enumer.hasMoreElements()) {
                String alias = enumer.nextElement();
                KeyStoreEntryDataContainer dataContainer = new KeyStoreEntryDataContainer(alias, moduleKeyStore.getCreationDate(alias));
                KeyStore.PasswordProtection passwordProtection = null;
                if (moduleKeyStore.isKeyEntry(alias)) {
                    passwordProtection = new KeyStore.PasswordProtection(this.getModuleKeyStorePassword().toCharArray());
                }
                KeyStore.Entry entry = moduleKeyStore.getEntry(alias, passwordProtection);
                dataContainer.setType(entry.getClass());
                keyStoreEntries.add(dataContainer);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (UnrecoverableEntryException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return keyStoreEntries;
    }

    @Override
    public String getModuleSignatureAlgorithm() {
        return this.getModuleAlgorithm();
    }

    @Override
    public Certificate getCertificate(String alias) throws KeyStoreException {
        return this.getModuleKeyStore().getCertificate(alias);
    }

    protected String getModuleKeyStoreType() {
        return MODULE_JKS_TYPE;
    }

    protected String getModuleAlgorithm() {
        return MODULE_SHA_RSA_ALGORITHM;
    }

    @Override
    public String getModuleKeyStoreLocation() {
        return this.moduleKeyStoreLocation;
    }

    public void setModuleKeyStoreLocation(String moduleKeyStoreLocation) {
        this.moduleKeyStoreLocation = moduleKeyStoreLocation;
    }

    @Override
    public String getModuleKeyStoreAlias() {
        return this.moduleKeyStoreAlias;
    }

    public void setModuleKeyStoreAlias(String moduleKeyStoreAlias) {
        this.moduleKeyStoreAlias = moduleKeyStoreAlias;
    }

    public String getModuleKeyStorePassword() {
        return this.moduleKeyStorePassword;
    }

    public void setModuleKeyStorePassword(String moduleKeyStorePassword) {
        this.moduleKeyStorePassword = moduleKeyStorePassword;
    }

    public KeyStore getModuleKeyStore() {
        return this.moduleKeyStore;
    }

    @Override
    public PrivateKey getModulePrivateKey() {
        return this.modulePrivateKey;
    }
}

