/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.registry.RemoveAndPublishResult;
import org.kuali.rice.ksb.api.registry.ServiceEndpoint;
import org.kuali.rice.ksb.api.registry.ServiceEndpointContract;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.bus.LocalService;
import org.kuali.rice.ksb.impl.bus.RemoteService;
import org.kuali.rice.ksb.impl.bus.diff.CompleteServiceDiff;
import org.kuali.rice.ksb.impl.bus.diff.LocalServicesDiff;
import org.kuali.rice.ksb.impl.bus.diff.RemoteServicesDiff;
import org.kuali.rice.ksb.impl.bus.diff.ServiceRegistryDiffCalculator;
import org.kuali.rice.ksb.messaging.serviceexporters.ServiceExportManager;
import org.kuali.rice.ksb.messaging.threadpool.KSBScheduledPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ServiceBusImpl
extends BaseLifecycle
implements ServiceBus,
InitializingBean,
DisposableBean {
    private static final Logger LOG = Logger.getLogger(ServiceBusImpl.class);
    private final Object serviceLock = new Object();
    private final Object synchronizeLock = new Object();
    private final Random randomNumber = new Random();
    private String instanceId;
    private ServiceRegistry serviceRegistry;
    private ServiceRegistryDiffCalculator diffCalculator;
    private ServiceExportManager serviceExportManager;
    private KSBScheduledPool scheduledPool;
    private ScheduledFuture<?> registrySyncFuture;
    private final Map<QName, LocalService> localServices = new HashMap<QName, LocalService>();
    private final Map<QName, Set<RemoteService>> clientRegistryCache = new HashMap<QName, Set<RemoteService>>();

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.instanceId)) {
            throw new IllegalStateException("a valid instanceId was not injected");
        }
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("serviceRegistry was not injected");
        }
        if (this.diffCalculator == null) {
            throw new IllegalStateException("diffCalculator was not injected");
        }
        if (this.scheduledPool == null) {
            throw new IllegalStateException("scheduledPool was not injected");
        }
    }

    public void start() throws Exception {
        this.startSynchronizationThread();
        super.start();
    }

    protected boolean isDevMode() {
        return ConfigContext.getCurrentContextConfig().getDevMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSynchronizationThread() {
        Object object = this.synchronizeLock;
        synchronized (object) {
            LOG.info((Object)"Starting Service Bus synchronization thread...");
            if (!this.isDevMode()) {
                int refreshRate = ConfigContext.getCurrentContextConfig().getRefreshRate();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServiceBusImpl.this.synchronize();
                        }
                        catch (Throwable t) {
                            LOG.error((Object)"Failed to execute background service bus synchronization.", t);
                        }
                    }
                };
                this.registrySyncFuture = this.scheduledPool.scheduleWithFixedDelay(runnable, 30L, refreshRate, TimeUnit.SECONDS);
            }
            LOG.info((Object)"...Service Bus synchronization thread successfully started.");
        }
    }

    public void destroy() throws Exception {
        LOG.info((Object)"Stopping the Service Bus...");
        this.stopSynchronizationThread();
        this.serviceRegistry.takeInstanceOffline(this.getInstanceId());
        LOG.info((Object)"...Service Bus successfully stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSynchronizationThread() {
        Object object = this.synchronizeLock;
        synchronized (object) {
            if (this.registrySyncFuture != null) {
                if (!this.registrySyncFuture.cancel(false)) {
                    LOG.warn((Object)"Failed to cancel registry sychronization.");
                }
                this.registrySyncFuture = null;
            }
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public List<Endpoint> getEndpoints(QName serviceName) {
        return this.getEndpoints(serviceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getEndpoints(QName serviceName, String applicationId) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Object object = this.serviceLock;
        synchronized (object) {
            Endpoint endpoint;
            Iterator iterator;
            endpoints.addAll(this.getRemoteEndpoints(serviceName));
            Endpoint localEndpoint = this.getLocalEndpoint(serviceName);
            if (localEndpoint != null) {
                iterator = endpoints.iterator();
                while (iterator.hasNext()) {
                    endpoint = (Endpoint)iterator.next();
                    if (!localEndpoint.getServiceConfiguration().equals(endpoint.getServiceConfiguration())) continue;
                    iterator.remove();
                    break;
                }
                if (StringUtils.isBlank((String)applicationId) || StringUtils.equals((String)localEndpoint.getServiceConfiguration().getApplicationId(), (String)applicationId)) {
                    endpoints.add(0, localEndpoint);
                }
            }
            if (StringUtils.isNotBlank((String)applicationId)) {
                iterator = endpoints.iterator();
                while (iterator.hasNext()) {
                    endpoint = (Endpoint)iterator.next();
                    if (StringUtils.equals((String)endpoint.getServiceConfiguration().getApplicationId(), (String)applicationId)) continue;
                    iterator.remove();
                }
            }
        }
        return Collections.unmodifiableList(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getRemoteEndpoints(QName serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Object object = this.serviceLock;
        synchronized (object) {
            Set<RemoteService> remoteServices = this.clientRegistryCache.get(serviceName);
            if (remoteServices != null) {
                for (RemoteService remoteService : remoteServices) {
                    endpoints.add(remoteService.getEndpoint());
                }
            }
        }
        return Collections.unmodifiableList(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getLocalEndpoint(QName serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        Object object = this.serviceLock;
        synchronized (object) {
            LocalService localService = this.localServices.get(serviceName);
            if (localService != null) {
                return localService.getEndpoint();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<QName, Endpoint> getLocalEndpoints() {
        HashMap<QName, Endpoint> localEndpoints = new HashMap<QName, Endpoint>();
        Object object = this.serviceLock;
        synchronized (object) {
            for (QName localServiceName : this.localServices.keySet()) {
                LocalService localService = this.localServices.get(localServiceName);
                localEndpoints.put(localServiceName, localService.getEndpoint());
            }
        }
        return Collections.unmodifiableMap(localEndpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getAllEndpoints() {
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        Object object = this.serviceLock;
        synchronized (object) {
            for (QName serviceName : this.localServices.keySet()) {
                allEndpoints.add(this.localServices.get(serviceName).getEndpoint());
            }
            for (QName serviceName : this.clientRegistryCache.keySet()) {
                Set<RemoteService> remoteServices = this.clientRegistryCache.get(serviceName);
                for (RemoteService remoteService : remoteServices) {
                    allEndpoints.add(remoteService.getEndpoint());
                }
            }
        }
        return Collections.unmodifiableList(allEndpoints);
    }

    public Endpoint getEndpoint(QName serviceName) {
        return this.getEndpoint(serviceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint(QName serviceName, String applicationId) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        Endpoint availableEndpoint = null;
        Object object = this.serviceLock;
        synchronized (object) {
            availableEndpoint = this.getLocalEndpoint(serviceName);
            if (availableEndpoint == null || !StringUtils.isBlank((String)applicationId) && !availableEndpoint.getServiceConfiguration().getApplicationId().equals(applicationId)) {
                Set<RemoteService> remoteServices = this.clientRegistryCache.get(serviceName);
                if ((remoteServices = this.filterByApplicationId(applicationId, remoteServices)) != null && !remoteServices.isEmpty()) {
                    RemoteService[] remoteServiceArray = remoteServices.toArray(new RemoteService[0]);
                    RemoteService availableRemoteService = remoteServiceArray[this.randomNumber.nextInt(remoteServiceArray.length)];
                    availableEndpoint = availableRemoteService.getEndpoint();
                }
            }
        }
        return availableEndpoint;
    }

    protected Set<RemoteService> filterByApplicationId(String applicationId, Set<RemoteService> remoteServices) {
        if (StringUtils.isBlank((String)applicationId) || remoteServices == null || remoteServices.isEmpty()) {
            return remoteServices;
        }
        HashSet<RemoteService> filtered = new HashSet<RemoteService>();
        for (RemoteService remoteService : remoteServices) {
            if (!remoteService.getServiceInfo().getApplicationId().equals(applicationId)) continue;
            filtered.add(remoteService);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getConfiguredEndpoint(ServiceConfiguration serviceConfiguration) {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("serviceConfiguration cannot be null");
        }
        Object object = this.serviceLock;
        synchronized (object) {
            Endpoint localEndpoint = this.getLocalEndpoint(serviceConfiguration.getServiceName());
            if (localEndpoint != null && localEndpoint.getServiceConfiguration().equals(serviceConfiguration)) {
                return localEndpoint;
            }
            List<Endpoint> remoteEndpoints = this.getRemoteEndpoints(serviceConfiguration.getServiceName());
            for (Endpoint remoteEndpoint : remoteEndpoints) {
                if (!remoteEndpoint.getServiceConfiguration().equals(serviceConfiguration)) continue;
                return remoteEndpoint;
            }
        }
        return null;
    }

    public Object getService(QName serviceName) {
        return this.getService(serviceName, null);
    }

    public Object getService(QName serviceName, String applicationId) {
        Endpoint availableEndpoint = this.getEndpoint(serviceName, applicationId);
        if (availableEndpoint == null) {
            return null;
        }
        return availableEndpoint.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceConfiguration publishService(ServiceDefinition serviceDefinition, boolean synchronize) {
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("serviceDefinition cannot be null");
        }
        LocalService localService = new LocalService(this.getInstanceId(), serviceDefinition);
        Object object = this.serviceLock;
        synchronized (object) {
            this.serviceExportManager.exportService(serviceDefinition);
            this.localServices.put(serviceDefinition.getServiceName(), localService);
        }
        if (synchronize) {
            this.synchronize();
        }
        return localService.getEndpoint().getServiceConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceConfiguration> publishServices(List<ServiceDefinition> serviceDefinitions, boolean synchronize) {
        if (serviceDefinitions == null) {
            throw new IllegalArgumentException("serviceDefinitions list cannot be null");
        }
        ArrayList<ServiceConfiguration> serviceConfigurations = new ArrayList<ServiceConfiguration>();
        Object object = this.serviceLock;
        synchronized (object) {
            for (ServiceDefinition serviceDefinition : serviceDefinitions) {
                ServiceConfiguration serviceConfiguration = this.publishService(serviceDefinition, false);
                serviceConfigurations.add(serviceConfiguration);
            }
        }
        if (synchronize) {
            this.synchronize();
        }
        return Collections.unmodifiableList(serviceConfigurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeService(QName serviceName, boolean synchronize) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName cannot be null");
        }
        boolean serviceRemoved = false;
        Object object = this.serviceLock;
        synchronized (object) {
            LocalService localService = this.localServices.remove(serviceName);
            serviceRemoved = localService != null;
            this.serviceExportManager.removeService(serviceName);
        }
        if (serviceRemoved && synchronize) {
            this.synchronize();
        }
        return serviceRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Boolean> removeServices(List<QName> serviceNames, boolean synchronize) {
        if (serviceNames == null) {
            throw new IllegalArgumentException("serviceNames cannot be null");
        }
        boolean serviceRemoved = false;
        ArrayList<Boolean> servicesRemoved = new ArrayList<Boolean>();
        Object object = this.serviceLock;
        synchronized (object) {
            for (QName serviceName : serviceNames) {
                this.serviceExportManager.removeService(serviceName);
                LocalService localService = this.localServices.remove(serviceName);
                if (localService != null) {
                    servicesRemoved.add(Boolean.TRUE);
                    serviceRemoved = true;
                    continue;
                }
                servicesRemoved.add(Boolean.FALSE);
            }
        }
        if (serviceRemoved && synchronize) {
            this.synchronize();
        }
        return servicesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeAndProcess(SyncProcessor processor) {
        if (!this.isDevMode()) {
            Object object = this.synchronizeLock;
            synchronized (object) {
                ArrayList<RemoteService> clientRegistryCacheList;
                ArrayList<LocalService> localServicesList;
                Object object2 = this.serviceLock;
                synchronized (object2) {
                    localServicesList = new ArrayList<LocalService>(this.localServices.values());
                    clientRegistryCacheList = new ArrayList<RemoteService>();
                    for (Set<RemoteService> remoteServices : this.clientRegistryCache.values()) {
                        clientRegistryCacheList.addAll(remoteServices);
                    }
                }
                CompleteServiceDiff serviceDiff = this.diffCalculator.diffServices(this.getInstanceId(), localServicesList, clientRegistryCacheList);
                this.logCompleteServiceDiff(serviceDiff);
                processor.sync(serviceDiff);
            }
        }
    }

    public void synchronize() {
        this.synchronizeAndProcess(new SyncProcessor(){

            @Override
            public void sync(CompleteServiceDiff diff) {
                RemoteServicesDiff remoteServicesDiff = diff.getRemoteServicesDiff();
                ServiceBusImpl.this.processRemoteServiceDiff(remoteServicesDiff);
                LocalServicesDiff localServicesDiff = diff.getLocalServicesDiff();
                ServiceBusImpl.this.processLocalServiceDiff(localServicesDiff);
            }
        });
    }

    public void synchronizeRemoteServices() {
        this.synchronizeAndProcess(new SyncProcessor(){

            @Override
            public void sync(CompleteServiceDiff diff) {
                RemoteServicesDiff remoteServicesDiff = diff.getRemoteServicesDiff();
                ServiceBusImpl.this.processRemoteServiceDiff(remoteServicesDiff);
            }
        });
    }

    public void synchronizeLocalServices() {
        this.synchronizeAndProcess(new SyncProcessor(){

            @Override
            public void sync(CompleteServiceDiff diff) {
                LocalServicesDiff localServicesDiff = diff.getLocalServicesDiff();
                ServiceBusImpl.this.processLocalServiceDiff(localServicesDiff);
            }
        });
    }

    protected void logCompleteServiceDiff(CompleteServiceDiff serviceDiff) {
        int servicesToRemove;
        int servicesToUpdate;
        LocalServicesDiff localServicesDiff;
        int servicesToPublish;
        int removedServices;
        RemoteServicesDiff remoteServicesDiff = serviceDiff.getRemoteServicesDiff();
        int newServices = remoteServicesDiff.getNewServices().size();
        if (newServices + (removedServices = remoteServicesDiff.getRemovedServices().size()) + (servicesToPublish = (localServicesDiff = serviceDiff.getLocalServicesDiff()).getLocalServicesToPublish().size()) + (servicesToUpdate = localServicesDiff.getLocalServicesToUpdate().size()) + (servicesToRemove = localServicesDiff.getServicesToRemoveFromRegistry().size()) > 0) {
            LOG.info((Object)("Found service changes during synchronization: remoteNewServices=" + newServices + ", remoteRemovedServices=" + removedServices + ", localServicesToPublish=" + servicesToPublish + ", localServicesToUpdate=" + servicesToUpdate + ", localServicesToRemove=" + servicesToRemove));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRemoteServiceDiff(RemoteServicesDiff remoteServicesDiff) {
        Object object = this.serviceLock;
        synchronized (object) {
            List<RemoteService> removedServices = remoteServicesDiff.getRemovedServices();
            for (RemoteService removedRemoteService : removedServices) {
                boolean wasRemoved;
                Set<RemoteService> remoteServiceSet = this.clientRegistryCache.get(removedRemoteService.getServiceName());
                if (remoteServiceSet == null || (wasRemoved = remoteServiceSet.remove(removedRemoteService))) continue;
                LOG.warn((Object)("Failed to remove remoteService during synchronization: " + removedRemoteService));
            }
            List<ServiceInfo> newServices = remoteServicesDiff.getNewServices();
            for (ServiceInfo newService : newServices) {
                Set<RemoteService> remoteServiceSet = this.clientRegistryCache.get(newService.getServiceName());
                if (remoteServiceSet == null) {
                    remoteServiceSet = new HashSet<RemoteService>();
                    this.clientRegistryCache.put(newService.getServiceName(), remoteServiceSet);
                }
                remoteServiceSet.add(new RemoteService(newService, this.serviceRegistry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLocalServiceDiff(LocalServicesDiff localServicesDiff) {
        RemoveAndPublishResult result;
        ArrayList<String> removeServiceEndpointIds = new ArrayList<String>();
        ArrayList<ServiceEndpoint> publishServiceEndpoints = new ArrayList<ServiceEndpoint>();
        for (ServiceInfo serviceToRemove : localServicesDiff.getServicesToRemoveFromRegistry()) {
            removeServiceEndpointIds.add(serviceToRemove.getServiceId());
        }
        for (LocalService localService : localServicesDiff.getLocalServicesToPublish()) {
            publishServiceEndpoints.add(localService.getServiceEndpoint());
        }
        for (LocalService localService : localServicesDiff.getLocalServicesToUpdate().keySet()) {
            ServiceInfo registryServiceInfo = localServicesDiff.getLocalServicesToUpdate().get(localService);
            publishServiceEndpoints.add(this.rebuildServiceEndpointForUpdate(localService.getServiceEndpoint(), registryServiceInfo));
        }
        boolean batchMode = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.ksb.batch.mode", false);
        if (!(batchMode || removeServiceEndpointIds.isEmpty() && publishServiceEndpoints.isEmpty() || (result = this.serviceRegistry.removeAndPublish(removeServiceEndpointIds, publishServiceEndpoints)).getServicesPublished().isEmpty())) {
            Object object = this.serviceLock;
            synchronized (object) {
                for (ServiceEndpoint publishedService : result.getServicesPublished()) {
                    this.rebuildLocalServiceEndpointAfterPublishing(publishedService);
                }
            }
        }
    }

    protected ServiceEndpoint rebuildServiceEndpointForUpdate(ServiceEndpoint originalEndpoint, ServiceInfo registryServiceInfo) {
        ServiceEndpoint.Builder builder = ServiceEndpoint.Builder.create((ServiceEndpointContract)originalEndpoint);
        builder.getInfo().setServiceId(registryServiceInfo.getServiceId());
        builder.getInfo().setServiceDescriptorId(registryServiceInfo.getServiceDescriptorId());
        builder.getDescriptor().setId(registryServiceInfo.getServiceDescriptorId());
        return builder.build();
    }

    protected void rebuildLocalServiceEndpointAfterPublishing(ServiceEndpoint publishedService) {
        QName serviceName = publishedService.getInfo().getServiceName();
        if (this.localServices.containsKey(serviceName)) {
            LocalService newLocalService = new LocalService(this.localServices.get(serviceName), publishedService);
            this.localServices.put(serviceName, newLocalService);
        }
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setDiffCalculator(ServiceRegistryDiffCalculator diffCalculator) {
        this.diffCalculator = diffCalculator;
    }

    public void setServiceExportManager(ServiceExportManager serviceExportManager) {
        this.serviceExportManager = serviceExportManager;
    }

    public void setScheduledPool(KSBScheduledPool scheduledPool) {
        this.scheduledPool = scheduledPool;
    }

    private static interface SyncProcessor {
        public void sync(CompleteServiceDiff var1);
    }
}

