/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseInvocationHandler;
import org.kuali.rice.core.api.util.reflect.TargetedInvocationHandler;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.serviceproxies.MessageSender;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class AsynchronousServiceCallProxy
extends BaseInvocationHandler
implements TargetedInvocationHandler {
    private static final Logger LOG = Logger.getLogger(AsynchronousServiceCallProxy.class);
    private AsynchronousCallback callback;
    private List<Endpoint> endpoints;
    private Serializable context;
    private String value1;
    private String value2;

    protected AsynchronousServiceCallProxy(List<Endpoint> endpoints, AsynchronousCallback callback, Serializable context, String value1, String value2) {
        this.endpoints = endpoints;
        this.callback = callback;
        this.context = context;
        this.value1 = value1;
        this.value2 = value2;
    }

    public static Object createInstance(List<Endpoint> endpoints, AsynchronousCallback callback, Serializable context, String value1, String value2) {
        if (endpoints == null || endpoints.isEmpty()) {
            throw new RuntimeException("Cannot create service proxy, no service(s) passed in.");
        }
        try {
            return Proxy.newProxyInstance(ClassLoaderUtils.getDefaultClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)endpoints.get(0).getService()), (InvocationHandler)((Object)new AsynchronousServiceCallProxy(endpoints, callback, context, value1, value2)));
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating messages for method invocation: " + method.getName()));
        }
        AsynchronousCall methodCall = null;
        PersistedMessageBO message = null;
        AsynchronousServiceCallProxy asynchronousServiceCallProxy = this;
        synchronized (asynchronousServiceCallProxy) {
            for (Endpoint endpoint : this.endpoints) {
                ServiceConfiguration serviceConfiguration = endpoint.getServiceConfiguration();
                methodCall = new AsynchronousCall((Class[])method.getParameterTypes(), arguments, serviceConfiguration, method.getName(), this.callback, this.context);
                message = PersistedMessageBO.buildMessage(serviceConfiguration, methodCall);
                message.setValue1(this.value1);
                message.setValue2(this.value2);
                message = this.saveMessage(message);
                this.executeMessage(message);
                if (!serviceConfiguration.isQueue()) continue;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("finished creating messages for method invocation: " + method.getName()));
        }
        return null;
    }

    protected String proxyToString(Object proxy) {
        StringBuilder builder = new StringBuilder();
        builder.append("Service call proxy (" + ((Object)((Object)this)).getClass().getName() + ") - for endpoints with service name: ");
        if (CollectionUtils.isNotEmpty(this.endpoints)) {
            builder.append(this.endpoints.get(0).getServiceConfiguration().getServiceName().toString());
        } else {
            builder.append("<< no endpoints on this proxy!!! >>");
        }
        return builder.toString();
    }

    protected PersistedMessageBO saveMessage(PersistedMessageBO message) {
        message.setQueueStatus("R");
        return KSBServiceLocator.getMessageQueueService().save(message);
    }

    protected void executeMessage(PersistedMessageBO message) throws Exception {
        MessageSender.sendMessage(message);
    }

    public Object getTarget() {
        return this.endpoints;
    }

    public AsynchronousCallback getCallback() {
        return this.callback;
    }

    public void setCallback(AsynchronousCallback callback) {
        this.callback = callback;
    }
}

