/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.HashMap;
import java.util.UUID;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.RegisterChangeLogCommand;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseRegisterChangeLogMojo
extends AbstractLiquibaseChangeLogMojo {
    protected String hubProjectId;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.hubProjectId == null) {
            throw new MojoFailureException("\nThe Hub project ID must be specified.");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        RegisterChangeLogCommand registerChangeLog = (RegisterChangeLogCommand)CommandFactory.getInstance().getCommand("registerChangeLog");
        registerChangeLog.setChangeLogFile(this.changeLogFile);
        registerChangeLog.setHubProjectId(UUID.fromString(this.hubProjectId));
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", (String)database);
        argsMap.put("liquibase", (String)liquibase);
        argsMap.put("changeLog", (String)liquibase.getDatabaseChangeLog());
        registerChangeLog.configure(argsMap);
        try {
            CommandResult result = registerChangeLog.execute();
            if (!result.succeeded) {
                throw new LiquibaseException(result.message);
            }
            Scope.getCurrentScope().getUI().sendMessage(result.print());
        }
        catch (CommandExecutionException cee) {
            throw new LiquibaseException("Error executing registerChangeLog", (Throwable)cee);
        }
    }
}

