/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.CursorType;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoIterableImpl;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncReadOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class FindIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements FindIterable<TResult> {
    private final AsyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final FindOptions findOptions;
    private Bson filter;

    FindIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, Bson filter, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new AsyncOperations(namespace, documentClass, readPreference, codecRegistry, retryReads);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.filter = (Bson)Assertions.notNull((String)"filter", (Object)filter);
        this.findOptions = new FindOptions();
    }

    @Override
    public FindIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindIterable<TResult> collation(@Nullable Collation collation) {
        this.findOptions.collation(collation);
        return this;
    }

    @Override
    public FindIterable<TResult> modifiers(@Nullable Bson modifiers) {
        this.findOptions.modifiers(modifiers);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(@Nullable Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(@Nullable Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public FindIterable<TResult> comment(@Nullable String comment) {
        this.findOptions.comment(comment);
        return this;
    }

    @Override
    public FindIterable<TResult> hint(@Nullable Bson hint) {
        this.findOptions.hint(hint);
        return this;
    }

    @Override
    public FindIterable<TResult> max(@Nullable Bson max) {
        this.findOptions.max(max);
        return this;
    }

    @Override
    public FindIterable<TResult> min(@Nullable Bson min) {
        this.findOptions.min(min);
        return this;
    }

    @Override
    public FindIterable<TResult> maxScan(long maxScan) {
        this.findOptions.maxScan(maxScan);
        return this;
    }

    @Override
    public FindIterable<TResult> returnKey(boolean returnKey) {
        this.findOptions.returnKey(returnKey);
        return this;
    }

    @Override
    public FindIterable<TResult> showRecordId(boolean showRecordId) {
        this.findOptions.showRecordId(showRecordId);
        return this;
    }

    @Override
    public FindIterable<TResult> snapshot(boolean snapshot) {
        this.findOptions.snapshot(snapshot);
        return this;
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull((String)"callback", callback);
        this.getExecutor().execute(this.operations.findFirst(this.filter, this.resultClass, this.findOptions), this.getReadPreference(), this.getReadConcern(), this.getClientSession(), new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        public void onResult(List<TResult> result, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (result == null || result.isEmpty()) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(result.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        return this.createFindOperation();
    }

    private AsyncReadOperation<AsyncBatchCursor<TResult>> createFindOperation() {
        return this.operations.find(this.filter, this.resultClass, this.findOptions);
    }
}

